/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseBlockUtils;
import gcewing.architecture.BaseContainer;
import gcewing.architecture.BaseDataChannel;
import gcewing.architecture.BlockPos;
import gcewing.architecture.SawbenchTE;
import gcewing.architecture.SlotSawbench;
import gcewing.architecture.SlotSawbenchResult;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2FPacketSetSlot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SawbenchContainer
extends BaseContainer {
    public static int guWidth = 242;
    public static int guiHeight = 224;
    public static int inputSlotLeft = 12;
    public static int inputSlotTop = 19;
    public static int outputSlotLeft = 12;
    public static int outputSlotTop = 57;
    SawbenchTE te;
    BaseContainer.SlotRange sawbenchSlotRange;
    Slot materialSlot;
    Slot resultSlot;

    public static Container create(EntityPlayer player, World world, BlockPos pos) {
        TileEntity te = BaseBlockUtils.getWorldTileEntity((IBlockAccess)world, pos);
        if (te instanceof SawbenchTE) {
            return new SawbenchContainer(player, (SawbenchTE)te);
        }
        return null;
    }

    public SawbenchContainer(EntityPlayer player, SawbenchTE te) {
        super(guWidth, guiHeight);
        this.te = te;
        this.sawbenchSlotRange = new BaseContainer.SlotRange(this);
        this.materialSlot = this.func_75146_a(new Slot((IInventory)te, 0, inputSlotLeft, inputSlotTop));
        this.resultSlot = this.func_75146_a(new SlotSawbenchResult(te, 1, outputSlotLeft, outputSlotTop));
        this.sawbenchSlotRange.end();
        this.addPlayerSlots(player, 8, guiHeight - 81);
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return this.te.func_70300_a(player);
    }

    @Override
    protected BaseContainer.SlotRange transferSlotRange(int srcSlotIndex, ItemStack stack) {
        if (this.playerSlotRange.contains(srcSlotIndex)) {
            return this.sawbenchSlotRange;
        }
        return this.playerSlotRange;
    }

    @Override
    public void func_75142_b() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            ItemStack newstack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
            ItemStack oldstack = (ItemStack)this.field_75153_a.get(i);
            if (ItemStack.func_77989_b((ItemStack)oldstack, (ItemStack)newstack)) continue;
            oldstack = newstack == null ? null : newstack.func_77946_l();
            this.field_75153_a.set(i, oldstack);
            for (Object crafter : this.field_75149_d) {
                if (crafter instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)crafter).field_71135_a.func_147359_a((Packet)new S2FPacketSetSlot(this.field_75152_c, i, newstack));
                    continue;
                }
                ((ICrafting)crafter).func_71111_a((Container)this, i, newstack);
            }
        }
    }

    @BaseDataChannel.ServerMessageHandler(value="SelectShape")
    public void onSelectShape(EntityPlayer player, BaseDataChannel.ChannelInput data) {
        int page = data.readInt();
        int slot = data.readInt();
        this.te.setSelectedShape(page, slot);
    }

    public void func_75141_a(int i, ItemStack stack) {
        Slot slot = this.func_75139_a(i);
        if (slot instanceof SlotSawbench) {
            ((SlotSawbench)slot).updateFromServer(stack);
        } else {
            super.func_75141_a(i, stack);
        }
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int index) {
        Slot slot = this.func_75139_a(index);
        if (slot == this.resultSlot) {
            return this.transferStackInResultSlot(player, index);
        }
        return super.func_82846_b(player, index);
    }

    protected ItemStack transferStackInResultSlot(EntityPlayer player, int index) {
        boolean materialWasPending = this.te.pendingMaterialUsage;
        ItemStack origMaterialStack = this.te.usePendingMaterial();
        ItemStack result = super.func_82846_b(player, index);
        if (materialWasPending) {
            this.te.returnUnusedMaterial(origMaterialStack);
        }
        return result;
    }
}

