/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import java.lang.reflect.Method;
import java.util.Random;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.asie.lib.AnvilDyeTweak;
import pl.asie.lib.AsieLibEvents;
import pl.asie.lib.CommonProxy;
import pl.asie.lib.NetworkHandlerClient;
import pl.asie.lib.api.AsieLibAPI;
import pl.asie.lib.api.chat.INicknameHandler;
import pl.asie.lib.api.chat.INicknameRepository;
import pl.asie.lib.api.tool.IToolRegistry;
import pl.asie.lib.chat.ChatHandler;
import pl.asie.lib.chat.NicknameNetworkHandler;
import pl.asie.lib.chat.NicknameRepository;
import pl.asie.lib.client.BlockBaseRender;
import pl.asie.lib.integration.Integration;
import pl.asie.lib.integration.tool.ToolProviders;
import pl.asie.lib.network.PacketHandler;
import pl.asie.lib.tweak.enchantment.EnchantmentTweak;
import pl.asie.lib.util.color.RecipeColorizer;
import pl.asie.lib.util.color.RecipeDecolorizer;

@Mod(modid="asielib", name="AsieLib", version="0.5.3", dependencies="required-after:Forge@[10.13.2.1236,);after:CoFHAPI|block@[1.7.10R1.0.0,);after:CoFHAPI|energy@[1.7.10R1.0.0,);after:CoFHAPI|tileentity@[1.7.10R1.0.0,);after:CoFHAPI|item@[1.7.10R1.0.0,)")
public class AsieLibMod
extends AsieLibAPI {
    public Configuration config;
    public static Random rand = new Random();
    public static Logger log;
    public static ChatHandler chat;
    public static NicknameRepository nick;
    public static PacketHandler packet;
    public static boolean ENABLE_DYNAMIC_ENERGY_CALCULATION;
    @Mod.Instance(value="asielib")
    public static AsieLibMod instance;
    @SidedProxy(clientSide="pl.asie.lib.ClientProxy", serverSide="pl.asie.lib.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        AsieLibAPI.instance = this;
        ToolProviders.registerToolProviders();
        log = LogManager.getLogger((String)"asielib");
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.config.load();
        chat = new ChatHandler(this.config);
        if (AsieLibMod.chat.enableChatFeatures) {
            MinecraftForge.EVENT_BUS.register((Object)chat);
            FMLCommonHandler.instance().bus().register((Object)chat);
        }
        MinecraftForge.EVENT_BUS.register((Object)new AsieLibEvents());
        ENABLE_DYNAMIC_ENERGY_CALCULATION = this.config.getBoolean("enableDynamicEnergyUsageCalculation", "general", true, "If you want to disable dynamic generation of current/peak energy usage, use this.");
        if (System.getProperty("user.dir").contains(".asielauncher")) {
            log.info("Hey, you! Yes, you! Thanks for using AsieLauncher! ~asie");
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (proxy.isClient()) {
            new BlockBaseRender();
        }
        packet = new PacketHandler("asielib", new NetworkHandlerClient(), null);
        if (this.config.get("enchantments", "usefulBaneOfArthropods", false, "Might make Bane Of Arthropods actually useful (Experimental)").getBoolean(false)) {
            EnchantmentTweak.registerBaneEnchantment(this.config.getInt("baneEnchantmentID", "enchantments", 244, 0, 255, "The enchantment ID for the better Bane Of Arthropods"));
            EnchantmentTweak tweak = new EnchantmentTweak();
            MinecraftForge.EVENT_BUS.register((Object)tweak);
            FMLCommonHandler.instance().bus().register((Object)tweak);
        }
        nick = new NicknameRepository();
        MinecraftForge.EVENT_BUS.register((Object)nick);
        NicknameNetworkHandler nicknameHandler = new NicknameNetworkHandler();
        this.registerNicknameHandler(nicknameHandler);
        FMLCommonHandler.instance().bus().register((Object)nicknameHandler);
        if (this.config.get("tweaks", "dyeItemNamesInAnvil", true).getBoolean(true)) {
            MinecraftForge.EVENT_BUS.register((Object)new AnvilDyeTweak());
        }
        RecipeSorter.register((String)"asielib:colorizer", RecipeColorizer.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore");
        RecipeSorter.register((String)"asielib:decolorizer", RecipeDecolorizer.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:asielib:colorizer");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.config.save();
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent event) {
        chat.registerCommands(event);
        nick.loadNicknames();
    }

    @Mod.EventHandler
    public void onServerStop(FMLServerStoppingEvent event) {
        nick.saveNicknames();
    }

    @Override
    public void registerNicknameHandler(INicknameHandler handler) {
        if (nick != null) {
            nick.addHandler(handler);
        }
    }

    @Override
    public INicknameRepository getNicknameRepository() {
        return nick;
    }

    @Mod.EventHandler
    public void receiveIMC(FMLInterModComms.IMCEvent event) {
        ImmutableList messages = event.getMessages();
        for (FMLInterModComms.IMCMessage message : messages) {
            if (!message.key.equalsIgnoreCase("addtoolprovider") || !message.isStringMessage()) continue;
            try {
                String methodString = message.getStringValue();
                String[] methodParts = methodString.split("\\.");
                String methodName = methodParts[methodParts.length - 1];
                String className = methodString.substring(0, methodString.length() - methodName.length() - 1);
                try {
                    Class<?> c = Class.forName(className);
                    Method method = c.getDeclaredMethod(methodName, IToolRegistry.class);
                    method.invoke(null, Integration.toolRegistry);
                }
                catch (ClassNotFoundException e) {
                    log.warn("Could not find class " + className, (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    log.warn("Could not find method " + methodString, (Throwable)e);
                }
                catch (Exception e) {
                    log.warn("Exception while trying to call method " + methodString, (Throwable)e);
                }
            }
            catch (Exception e) {
                log.warn("Exception while trying to register a ToolProvider", (Throwable)e);
            }
        }
    }
}

