/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.compat.ticon;

import fox.spiteful.avaritia.compat.ticon.TConTextureResourcePackBase;
import java.awt.image.BufferedImage;
import java.util.Random;
import net.minecraft.util.MathHelper;

public class NeutroniumIcons
extends TConTextureResourcePackBase {
    private double[] noise;

    public NeutroniumIcons() {
        super("avaritia_neutronium");
        int len = 256;
        Random randy = new Random(12345L);
        this.noise = new double[len];
        for (int i = 0; i < len; ++i) {
            this.noise[i] = randy.nextDouble();
        }
    }

    @Override
    public BufferedImage modifyImage(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        if (image.getType() != 2) {
            BufferedImage temp = new BufferedImage(w, h, 2);
            int[] data = new int[w * h];
            image.getRGB(0, 0, w, h, data, 0, w);
            temp.setRGB(0, 0, w, h, data, 0, w);
            image = temp;
        }
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int c = image.getRGB(x, y);
                int l = MathHelper.func_76128_c((double)Math.min(255.0, (double)(255 - this.brightness(c)) * 1.05));
                int a = rgb.getAlpha(c);
                if (this.isEdge(image, x, y, w, h, a)) {
                    double n = this.noise[(y * w + x) % this.noise.length];
                    double e = Math.min(1.0, (double)l / 255.0 * 0.5 + 0.5 + n * 0.2);
                    int r = MathHelper.func_76128_c((double)(e * 188.0));
                    int g = MathHelper.func_76128_c((double)(e * 192.0));
                    int b = MathHelper.func_76128_c((double)(e * 219.0));
                    image.setRGB(x, y, this.colour(r, g, b, a));
                    continue;
                }
                image.setRGB(x, y, this.colour(l, l, l, a));
            }
        }
        return image;
    }

    private boolean isEdge(BufferedImage image, int x, int y, int w, int h, int a) {
        if (a != 0) {
            if (x == 0 || x == w - 1 || y == 0 || y == h - 1) {
                return true;
            }
            if (rgb.getAlpha(image.getRGB(x - 1, y)) != 255 || rgb.getAlpha(image.getRGB(x + 1, y)) != 255 || rgb.getAlpha(image.getRGB(x, y - 1)) != 255 || rgb.getAlpha(image.getRGB(x, y + 1)) != 255) {
                return true;
            }
        }
        return false;
    }
}

