/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.items;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fox.spiteful.avaritia.Avaritia;
import fox.spiteful.avaritia.Config;
import fox.spiteful.avaritia.LudicrousText;
import fox.spiteful.avaritia.PotionHelper;
import fox.spiteful.avaritia.compat.Compat;
import fox.spiteful.avaritia.entity.EntityImmortalItem;
import fox.spiteful.avaritia.items.LudicrousItems;
import fox.spiteful.avaritia.render.ICosmicRenderItem;
import fox.spiteful.avaritia.render.ModelArmorInfinity;
import gregtech.api.hazards.Hazard;
import gregtech.api.hazards.IHazardProtector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.living.LivingEvent;
import thaumcraft.api.IGoggles;
import thaumcraft.api.IVisDiscountGear;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.nodes.IRevealer;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.item.IPhantomInkable;
import vazkii.botania.api.mana.IManaDiscountArmor;

@Optional.InterfaceList(value={@Optional.Interface(iface="thaumcraft.api.IGoggles", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.nodes.IRevealer", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.IVisDiscountGear", modid="Thaumcraft"), @Optional.Interface(iface="vazkii.botania.api.item.IPhantomInkable", modid="Botania"), @Optional.Interface(iface="vazkii.botania.api.mana.IManaDiscountArmor", modid="Botania"), @Optional.Interface(iface="vazkii.botania.api.item.IManaProficiencyArmor", modid="Botania"), @Optional.Interface(iface="gregtech.api.hazards.IHazardProtector", modid="gregtech_nh")})
public class ItemArmorInfinity
extends ItemArmor
implements ICosmicRenderItem,
IGoggles,
IRevealer,
IVisDiscountGear,
IPhantomInkable,
IManaDiscountArmor,
IManaProficiencyArmor,
IHazardProtector {
    public static final ItemArmor.ArmorMaterial infinite_armor = EnumHelper.addArmorMaterial((String)"infinity", (int)9999, (int[])new int[]{6, 16, 12, 6}, (int)1000);
    public IIcon cosmicMask;
    public final int slot;

    public ItemArmorInfinity(int slot) {
        super(infinite_armor, 0, slot);
        this.slot = slot;
        this.func_77637_a(Avaritia.tab);
        this.func_77655_b("infinity_armor_" + slot);
        this.func_111206_d("avaritia:infinity_armor_" + slot);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "avaritia:textures/models/infinity_armor.png";
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (this.field_77881_a == 0) {
            player.func_70050_g(300);
            player.func_71024_bL().func_75122_a(20, 20.0f);
        } else if (this.field_77881_a == 1) {
            Collection effects = player.func_70651_bq();
            if (effects.size() > 0) {
                ArrayList<Potion> bad = new ArrayList<Potion>();
                for (PotionEffect potionEffect : effects) {
                    if (!PotionHelper.badPotion(Potion.field_76425_a[potionEffect.func_76456_a()])) continue;
                    bad.add(Potion.field_76425_a[potionEffect.func_76456_a()]);
                }
                if (bad.size() > 0) {
                    for (Potion potion : bad) {
                        player.func_82170_o(potion.field_76415_H);
                    }
                }
            }
        } else if (this.field_77881_a == 2 && player.func_70027_ad()) {
            player.func_70066_B();
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return LudicrousItems.cosmic;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemstack, int armorSlot) {
        ModelArmorInfinity model = armorSlot == 2 ? ModelArmorInfinity.legModel : ModelArmorInfinity.armorModel;
        model.update(entityLiving, itemstack, armorSlot);
        return model;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(stack);
        return multimap;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showIngamePopups(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        return this.field_77881_a == 0;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showNodes(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        return this.field_77881_a == 0;
    }

    @Optional.Method(modid="Thaumcraft")
    public int getVisDiscount(ItemStack itemStack, EntityPlayer entityPlayer, Aspect aspect) {
        return 20;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean par4) {
        if (Compat.thaumic) {
            list.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"tc.visdiscount") + ": " + this.getVisDiscount(stack, player, null) + "%");
        }
        if (Compat.botan && this.hasPhantomInk(stack)) {
            list.add(StatCollector.func_74838_a((String)"botaniamisc.hasPhantomInk").replaceAll("&", "\u00a7"));
        }
        if (this.slot == 3 && Config.fast) {
            list.add("");
            list.add(EnumChatFormatting.BLUE + "+" + EnumChatFormatting.ITALIC + LudicrousText.makeSANIC("SANIC") + EnumChatFormatting.RESET + "" + EnumChatFormatting.BLUE + "% Speed");
        }
        super.func_77624_a(stack, player, list, par4);
    }

    public boolean hasPhantomInk(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return false;
        }
        return stack.func_77978_p().func_74767_n("phantomInk");
    }

    public void setPhantomInk(ItemStack stack, boolean ink) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        tag.func_74757_a("phantomInk", ink);
    }

    @Optional.Method(modid="Botania")
    public float getDiscount(ItemStack stack, int slot, EntityPlayer player) {
        return 0.25f;
    }

    @Optional.Method(modid="Botania")
    public boolean shouldGiveProficiency(ItemStack itemStack, int i, EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        super.func_94581_a(ir);
        this.cosmicMask = ir.func_94245_a("avaritia:infinity_armor_" + this.slot + "_mask");
    }

    @Override
    public IIcon getMaskTexture(ItemStack stack, EntityPlayer player) {
        return this.cosmicMask;
    }

    @Override
    public float getMaskMultiplier(ItemStack stack, EntityPlayer player) {
        return 1.0f;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityImmortalItem(world, location, itemstack);
    }

    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        return false;
    }

    @Optional.Method(modid="gregtech_nh")
    public boolean protectsAgainst(ItemStack itemStack, Hazard hazard) {
        return true;
    }

    public static class abilityHandler {
        public static List<String> playersWithHat = new ArrayList<String>();
        public static List<String> playersWithChest = new ArrayList<String>();
        public static List<String> playersWithLeg = new ArrayList<String>();
        public static List<String> playersWithFoot = new ArrayList<String>();

        public static boolean playerHasHat(EntityPlayer player) {
            ItemStack armour = player.func_82169_q(3);
            return armour != null && armour.func_77973_b() == LudicrousItems.infinity_helm;
        }

        public static boolean playerHasChest(EntityPlayer player) {
            ItemStack armour = player.func_82169_q(2);
            return armour != null && armour.func_77973_b() == LudicrousItems.infinity_armor;
        }

        public static boolean playerHasLeg(EntityPlayer player) {
            ItemStack armour = player.func_82169_q(1);
            return armour != null && armour.func_77973_b() == LudicrousItems.infinity_pants;
        }

        public static boolean playerHasFoot(EntityPlayer player) {
            ItemStack armour = player.func_82169_q(0);
            return armour != null && armour.func_77973_b() == LudicrousItems.infinity_shoes;
        }

        public static String playerKey(EntityPlayer player) {
            return player.func_146103_bH().getName() + ":" + player.field_70170_p.field_72995_K;
        }

        @SubscribeEvent
        public void updatePlayerAbilityStatus(LivingEvent.LivingUpdateEvent event) {
            if (event.entityLiving instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.entityLiving;
                String key = abilityHandler.playerKey(player);
                Boolean hasHat = abilityHandler.playerHasHat(player);
                if (playersWithHat.contains(key)) {
                    if (!hasHat.booleanValue()) {
                        playersWithHat.remove(key);
                    }
                } else if (hasHat.booleanValue()) {
                    playersWithHat.add(key);
                }
                Boolean hasChest = abilityHandler.playerHasChest(player);
                if (playersWithChest.contains(key)) {
                    if (hasChest.booleanValue()) {
                        player.field_71075_bZ.field_75101_c = true;
                    } else {
                        if (!player.field_71075_bZ.field_75098_d) {
                            player.field_71075_bZ.field_75101_c = false;
                            player.field_71075_bZ.field_75100_b = false;
                        }
                        playersWithChest.remove(key);
                    }
                } else if (hasChest.booleanValue()) {
                    playersWithChest.add(key);
                }
                Boolean hasLeg = abilityHandler.playerHasLeg(player);
                if (playersWithLeg.contains(key)) {
                    if (!hasLeg.booleanValue()) {
                        playersWithLeg.remove(key);
                    }
                } else if (hasLeg.booleanValue()) {
                    playersWithLeg.add(key);
                }
                Boolean hasFoot = abilityHandler.playerHasFoot(player) && Config.fast;
                if (playersWithFoot.contains(key)) {
                    if (hasFoot.booleanValue()) {
                        boolean swimming;
                        boolean flying = player.field_71075_bZ.field_75100_b;
                        boolean bl = swimming = player.func_70055_a(Material.field_151586_h) || player.func_70090_H();
                        if (player.field_70122_E || flying || swimming) {
                            boolean sneaking = player.func_70093_af();
                            player.field_70138_W = sneaking ? 0.5f : 1.0f;
                            float speed = 0.15f * (flying ? 1.1f : 1.0f) * (sneaking ? 0.1f : 1.0f);
                            if (player.field_70701_bs > 0.0f) {
                                player.func_70060_a(0.0f, 1.0f, speed);
                            } else if (player.field_70701_bs < 0.0f) {
                                player.func_70060_a(0.0f, 1.0f, -speed * 0.3f);
                            }
                            if (player.field_70702_br != 0.0f) {
                                player.func_70060_a(1.0f, 0.0f, speed * 0.5f * Math.signum(player.field_70702_br));
                            }
                            if (flying) {
                                if (player.field_70181_x > 0.0 && player.field_70181_x < 2.0) {
                                    player.field_70181_x *= 1.5;
                                } else if (player.field_70181_x < 0.0 && player.field_70181_x > -2.0) {
                                    player.field_70181_x *= 1.5;
                                }
                            }
                        }
                    } else {
                        playersWithFoot.remove(key);
                    }
                } else if (hasFoot.booleanValue()) {
                    playersWithFoot.add(key);
                }
            }
        }

        @SubscribeEvent
        public void jumpBoost(LivingEvent.LivingJumpEvent event) {
            EntityPlayer player;
            String key;
            if (event.entityLiving instanceof EntityPlayer && playersWithFoot.contains(key = abilityHandler.playerKey(player = (EntityPlayer)event.entityLiving))) {
                player.field_70181_x += (double)0.4f;
            }
        }
    }
}

