/*
 * Decompiled with CFR 0.152.
 */
package baubles.common.event;

import baubles.api.IBauble;
import baubles.common.Baubles;
import baubles.common.container.InventoryBaubles;
import baubles.common.event.EventHandlerNetwork;
import baubles.common.lib.PlayerHandler;
import com.google.common.io.Files;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class EventHandlerEntity {
    private File playerDirectory;

    @SubscribeEvent
    public void playerTick(LivingEvent.LivingUpdateEvent event) {
        Entity entity = event.entity;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            InventoryBaubles baubles = PlayerHandler.getPlayerBaubles(player);
            for (int a = 0; a < baubles.func_70302_i_(); ++a) {
                if (baubles.func_70301_a(a) == null || !(baubles.func_70301_a(a).func_77973_b() instanceof IBauble)) continue;
                ((IBauble)baubles.func_70301_a(a).func_77973_b()).onWornTick(baubles.func_70301_a(a), (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void playerDeath(PlayerDropsEvent event) {
        if (event.entity instanceof EntityPlayer && !event.entity.field_70170_p.field_72995_K && !event.entity.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            PlayerHandler.getPlayerBaubles(event.entityPlayer).dropItemsAt(event.drops, (Entity)event.entityPlayer);
        }
    }

    @SubscribeEvent
    public void playerLoad(PlayerEvent.LoadFromFile event) {
        this.playerLoadDo(event.entityPlayer, event.playerDirectory, event.entityPlayer.field_71075_bZ.field_75098_d);
        this.playerDirectory = event.playerDirectory;
    }

    private void playerLoadDo(EntityPlayer player, File directory, Boolean gamemode) {
        File filep;
        PlayerHandler.clearPlayerBaubles(player);
        String fileExtension = "baub";
        String fileExtensionBackup = "baubback";
        File mainFile = this.getPlayerFile("baub", directory, player.func_70005_c_());
        File backupFile = this.getPlayerFile("baubback", directory, player.func_70005_c_());
        if (!mainFile.exists() && (filep = this.getPlayerFile("baub", directory, player.func_146103_bH().getId().toString())).exists()) {
            try {
                Files.copy((File)filep, (File)mainFile);
                Baubles.log.info("Using and converting UUID Baubles savefile for " + player.func_70005_c_());
                filep.delete();
                File fb = this.getPlayerFile("baubback", directory, player.func_146103_bH().getId().toString());
                if (fb.exists()) {
                    fb.delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        PlayerHandler.loadPlayerBaubles(player, mainFile, backupFile);
        EventHandlerNetwork.syncBaubles(player);
    }

    public File getPlayerFile(String extension, File playerDirectory, String playerName) {
        if ("dat".equals(extension)) {
            throw new IllegalArgumentException("The extension 'dat' is reserved");
        }
        return new File(playerDirectory, playerName + "." + extension);
    }

    @SubscribeEvent
    public void playerSave(PlayerEvent.SaveToFile event) {
        this.playerSaveDo(event.entityPlayer, event.playerDirectory, event.entityPlayer.field_71075_bZ.field_75098_d);
    }

    private void playerSaveDo(EntityPlayer player, File directory, Boolean gamemode) {
        PlayerHandler.savePlayerBaubles(player, this.getPlayerFile("baub", directory, player.func_70005_c_()), this.getPlayerFile("baubback", directory, player.func_70005_c_()));
    }
}

