/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.beebetteratbees.client.gui;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import cpw.mods.fml.relauncher.ReflectionHelper;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import hellfirepvp.beebetteratbees.client.gui.AbstractTreeGUIHandler;
import hellfirepvp.beebetteratbees.client.gui.CachedBeeMutationTree;
import hellfirepvp.beebetteratbees.client.gui.CachedRecipe;
import hellfirepvp.beebetteratbees.common.BeeBetterAtBees;
import hellfirepvp.beebetteratbees.common.ModConfig;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class BBABGuiRecipeTreeHandler
extends AbstractTreeGUIHandler {
    public static final int BEE_TYPE_PRINCESS = 1;
    public static final int BEE_TYPE_DRONE = 0;
    private static IBeeRoot speciesRoot;
    private Map<Rectangle, Collection<String>> tipBoxes = new HashMap<Rectangle, Collection<String>>();
    private static final Color lineColorBlack;
    private static final Color lineColorRed;
    private static final int offsetCorrection = 8;
    private static final int possibleChildOffset = 16;

    public static List<IBeeMutation> getMutationsWithResult(IAllele allele) {
        if (speciesRoot == null) {
            return new LinkedList<IBeeMutation>();
        }
        LinkedList<IBeeMutation> out = new LinkedList<IBeeMutation>();
        for (IBeeMutation mutation : speciesRoot.getMutations(false)) {
            if (!mutation.getTemplate()[0].equals(allele)) continue;
            out.add(mutation);
        }
        return out;
    }

    public static ItemStack createStack(IAlleleSpecies species, int type) {
        ISpeciesRoot root = species.getRoot();
        IAllele[] template = root.getTemplate(species.getUID());
        if (template == null) {
            BeeBetterAtBees.log.warn("Template for %s doesn't exist! Skipping...", new Object[]{species.getUID()});
            return null;
        }
        IIndividual individual = root.templateAsIndividual(template);
        individual.analyze();
        ItemStack stack = root.getMemberStack(individual, type);
        if (stack == null) {
            BeeBetterAtBees.log.warn("Got no MemberStack back when creating bee (%s) ?", new Object[]{species.getUID()});
        }
        return stack;
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (speciesRoot == null) {
            return;
        }
        if (outputId.equals("item")) {
            this.loadCraftingRecipes((ItemStack)results[0]);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (speciesRoot == null) {
            return;
        }
        if (!speciesRoot.isMember(result)) {
            return;
        }
        IBee resultIndividual = speciesRoot.getMember(result);
        if (resultIndividual == null) {
            BeeBetterAtBees.log.warn("IIndividual is null searching recipe for %s", new Object[]{result.toString()});
            return;
        }
        if (resultIndividual.getGenome() == null) {
            BeeBetterAtBees.log.warn("Genome is null when searching recipe for %s", new Object[]{result.toString()});
            return;
        }
        if (resultIndividual.getGenome().getPrimary() == null) {
            BeeBetterAtBees.log.warn("Species is null when searching recipe for %s", new Object[]{result.toString()});
            return;
        }
        IAlleleSpecies species = resultIndividual.getGenome().getPrimary();
        for (IBeeMutation mutation : speciesRoot.getMutations(false)) {
            if (!mutation.getTemplate()[0].equals(species) || mutation.isSecret() && !ModConfig.shouldShowSecretRecipes) continue;
            this.arecipes.add(new CachedBeeMutationTree(mutation));
        }
        this.cleanupDuplicateRecipes();
    }

    @Override
    public void drawExtras(int recipe) {
        CachedRecipe rec = (CachedRecipe)this.arecipes.get(recipe);
        if (rec instanceof CachedBeeMutationTree) {
            HashMap<Rectangle, Collection<String>> boxes = new HashMap<Rectangle, Collection<String>>(4);
            CachedBeeMutationTree.PositionedMutationNodeStack root = ((CachedBeeMutationTree)rec).getRootStack();
            BBABGuiRecipeTreeHandler.drawExtrasFrom(root, boxes);
            this.tipBoxes = boxes;
        }
    }

    public static void drawExtrasFrom(CachedBeeMutationTree.PositionedMutationNodeStack nodeStack, Map<Rectangle, Collection<String>> infoBoxes) {
        float chance;
        int nodeX = nodeStack.relx;
        int nodeY = nodeStack.rely;
        if (nodeStack.leftChild == null || nodeStack.rightChild == null) {
            if (nodeStack.hasPossibleChildren) {
                float chance2;
                Color drawColor = lineColorBlack;
                if (nodeStack.requirements != null && !nodeStack.requirements.isEmpty()) {
                    drawColor = lineColorRed;
                }
                if ((chance2 = nodeStack.baseChance) > 0.0f) {
                    int length = BBABGuiRecipeTreeHandler.drawChanceInfo(nodeX, nodeY, chance2, Minecraft.func_71410_x().field_71466_p, drawColor);
                    if (nodeStack.requirements != null && !nodeStack.requirements.isEmpty()) {
                        Rectangle rec = new Rectangle(nodeX + 4, nodeY + 17, (int)((float)length * 0.75f), 5);
                        infoBoxes.put(rec, nodeStack.requirements);
                    }
                }
                BBABGuiRecipeTreeHandler.drawLine(nodeX + 8, nodeY + 8, nodeX + 8 - 4, nodeY + 8 + 16, drawColor);
                BBABGuiRecipeTreeHandler.drawLine(nodeX + 8, nodeY + 8, nodeX + 8 + 4, nodeY + 8 + 16, drawColor);
            }
            return;
        }
        Color drawColor = lineColorBlack;
        if (nodeStack.requirements != null && !nodeStack.requirements.isEmpty()) {
            drawColor = lineColorRed;
        }
        if ((chance = nodeStack.baseChance) > 0.0f) {
            int length = BBABGuiRecipeTreeHandler.drawChanceInfo(nodeX, nodeY, chance, Minecraft.func_71410_x().field_71466_p, drawColor);
            if (nodeStack.requirements != null && !nodeStack.requirements.isEmpty()) {
                Rectangle rec = new Rectangle(nodeX + 4, nodeY + 17, (int)((float)length * 0.75f), 5);
                infoBoxes.put(rec, nodeStack.requirements);
            }
        }
        CachedBeeMutationTree.PositionedMutationNodeStack left = nodeStack.leftChild;
        BBABGuiRecipeTreeHandler.drawLine(nodeX + 8, nodeY + 8, left.relx + 8, left.rely + 8, drawColor);
        CachedBeeMutationTree.PositionedMutationNodeStack right = nodeStack.rightChild;
        BBABGuiRecipeTreeHandler.drawLine(nodeX + 8, nodeY + 8, right.relx + 8, right.rely + 8, drawColor);
        BBABGuiRecipeTreeHandler.drawExtrasFrom(left, infoBoxes);
        BBABGuiRecipeTreeHandler.drawExtrasFrom(right, infoBoxes);
    }

    private static int drawChanceInfo(int nodeX, int nodeY, float chance, FontRenderer fr, Color drawColor) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(nodeX + 4), (float)(nodeY + 17), (float)0.0f);
        GL11.glScalef((float)0.65f, (float)0.65f, (float)0.65f);
        int chAsInt = (int)chance;
        StringBuilder sb = new StringBuilder().append(EnumChatFormatting.BOLD);
        if (chAsInt <= 0) {
            sb.append("<1%");
        } else {
            sb.append(chAsInt).append("%");
        }
        int length = fr.func_78276_b(sb.toString(), 0, 0, drawColor.getRGB());
        GL11.glPopMatrix();
        return length;
    }

    @Override
    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        if (GuiContainerManager.shouldShowTooltip((GuiContainer)gui) && currenttip.size() == 0) {
            Point pos = GuiDraw.getMousePosition();
            Point guiOffset = this.getGuiOffset((GuiContainer)gui);
            Point relMouse = new Point(pos.x - guiOffset.x - 5, pos.y - guiOffset.y - 16);
            for (Rectangle rec : this.tipBoxes.keySet()) {
                if (!rec.contains(relMouse)) continue;
                return new LinkedList<String>(this.tipBoxes.get(rec));
            }
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    private Point getGuiOffset(GuiContainer ct) {
        try {
            Field fP = ReflectionHelper.findField(GuiContainer.class, (String[])new String[]{"guiLeft", "field_147003_i"});
            fP.setAccessible(true);
            int left = (Integer)fP.get(ct);
            fP = ReflectionHelper.findField(GuiContainer.class, (String[])new String[]{"guiTop", "field_147009_r"});
            fP.setAccessible(true);
            int top = (Integer)fP.get(ct);
            return new Point(left, top);
        }
        catch (Exception exception) {
            return new Point(0, 0);
        }
    }

    private static void drawLine(double lx, double ly, double hx, double hy, Color color) {
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)true);
        GL11.glLineWidth((float)3.0f);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78371_b(3);
        tes.func_78370_a(color.getRed(), color.getGreen(), color.getBlue(), 127);
        tes.func_78377_a(lx, ly, 0.0);
        tes.func_78377_a(hx, hy, 0.0);
        tes.func_78381_a();
        GL11.glDisable((int)2848);
        GL11.glDepthMask((boolean)false);
        GL11.glLineWidth((float)2.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    @Override
    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (speciesRoot == null) {
            return;
        }
        if (inputId.equals("item")) {
            this.loadUsageRecipes((ItemStack)ingredients[0]);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (speciesRoot == null) {
            return;
        }
        if (!speciesRoot.isMember(ingredient)) {
            return;
        }
        IBee individual = speciesRoot.getMember(ingredient);
        if (individual == null) {
            BeeBetterAtBees.log.warn("IIndividual is null searching recipe for %s", new Object[]{ingredient.toString()});
            return;
        }
        if (individual.getGenome() == null) {
            BeeBetterAtBees.log.warn("Genome is null when searching recipe for %s", new Object[]{ingredient.toString()});
            return;
        }
        if (individual.getGenome().getPrimary() == null) {
            BeeBetterAtBees.log.warn("Species is null when searching recipe for %s", new Object[]{ingredient.toString()});
            return;
        }
        IAlleleSpecies species = individual.getGenome().getPrimary();
        for (IBeeMutation mutation : speciesRoot.getMutations(false)) {
            if (!mutation.getAllele0().equals(species) && !mutation.getAllele1().equals(species) || mutation.isSecret() && !ModConfig.shouldShowSecretRecipes) continue;
            this.arecipes.add(new CachedBeeMutationTree(mutation));
        }
        this.cleanupDuplicateRecipes();
    }

    private void cleanupDuplicateRecipes() {
        for (CachedRecipe recipe : this.arecipes) {
            if (!(recipe instanceof CachedBeeMutationTree)) continue;
            boolean clean = true;
            Iterator iterator = this.arecipes.iterator();
            while (iterator.hasNext()) {
                CachedRecipe recipeOther = (CachedRecipe)iterator.next();
                if (recipe == recipeOther || !recipe.equals(recipeOther)) continue;
                iterator.remove();
                clean = false;
            }
            if (clean) continue;
            this.cleanupDuplicateRecipes();
            break;
        }
    }

    @Override
    public String getGuiTexture() {
        return "beebetteratbees:textures/gui/neiBlank.png";
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"bbab.gui.breedtree");
    }

    public static void loadBeeRoot() {
        speciesRoot = (IBeeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
        if (speciesRoot == null) {
            BeeBetterAtBees.log.warn("Bee Species Root not found, this mod has no use without it.");
        } else {
            BeeBetterAtBees.log.info("Bee Species Root found!");
        }
    }

    static {
        lineColorBlack = new Color(0, 0, 0);
        lineColorRed = new Color(169, 0, 10);
    }
}

