/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.party;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumPartyStatus;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.party.IParty;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.INBTPartial;
import betterquesting.core.BetterQuesting;
import betterquesting.network.handlers.NetInviteSync;
import betterquesting.network.handlers.NetQuestSync;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.party.PartyManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;

public class PartyInvitations
implements INBTPartial<NBTTagList, UUID> {
    public static final PartyInvitations INSTANCE = new PartyInvitations();
    private final HashMap<UUID, HashMap<Integer, Long>> invites = new HashMap();

    public synchronized void postInvite(@Nonnull UUID uuid, int id, long expiryTime) {
        if (expiryTime <= 0L) {
            BetterQuesting.logger.error("Received an invite that has already expired!");
            return;
        }
        IParty party = (IParty)PartyManager.INSTANCE.getValue(id);
        if (party == null || party.getStatus(uuid) != null) {
            return;
        }
        HashMap list = this.invites.computeIfAbsent(uuid, key -> new HashMap());
        list.put(id, System.currentTimeMillis() + expiryTime);
    }

    public synchronized boolean acceptInvite(@Nonnull UUID uuid, int id) {
        boolean valid;
        HashMap<Integer, Long> userInvites = this.invites.get(uuid);
        if (userInvites == null || userInvites.size() <= 0) {
            return false;
        }
        long timestamp = userInvites.get(id);
        IParty party = (IParty)PartyManager.INSTANCE.getValue(id);
        boolean bl = valid = timestamp > System.currentTimeMillis();
        if (valid && party != null) {
            for (DBEntry entry : QuestDatabase.INSTANCE.getEntries()) {
                ((IQuest)entry.getValue()).resetUser(uuid, true);
            }
            EntityPlayerMP player = QuestingAPI.getPlayer(uuid);
            if (player != null) {
                NetQuestSync.sendSync(player, null, false, true, true);
            }
            party.setStatus(uuid, EnumPartyStatus.MEMBER);
            PartyManager.SyncPartyQuests(party, true);
        }
        userInvites.remove(id);
        if (userInvites.size() <= 0) {
            this.invites.remove(uuid);
        }
        return valid;
    }

    public synchronized void revokeInvites(@Nonnull UUID uuid, int ... ids) {
        HashMap<Integer, Long> userInvites = this.invites.get(uuid);
        if (userInvites == null || userInvites.size() <= 0) {
            return;
        }
        for (int i : ids) {
            userInvites.remove(i);
        }
        if (userInvites.size() <= 0) {
            this.invites.remove(uuid);
        }
    }

    public synchronized List<Map.Entry<Integer, Long>> getPartyInvites(@Nonnull UUID uuid) {
        HashMap<Integer, Long> userInvites = this.invites.get(uuid);
        if (userInvites == null || userInvites.size() <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Map.Entry<Integer, Long>> list = new ArrayList<Map.Entry<Integer, Long>>(userInvites.entrySet());
        list.sort(Comparator.comparing(Map.Entry::getValue));
        return list;
    }

    public synchronized void purgeInvites(int partyID) {
        this.invites.values().forEach(value -> {
            Long cfr_ignored_0 = (Long)value.remove(partyID);
        });
    }

    public synchronized void cleanExpired() {
        MinecraftServer server = MinecraftServer.func_71276_C();
        Iterator<Map.Entry<UUID, HashMap<Integer, Long>>> iterA = this.invites.entrySet().iterator();
        while (iterA.hasNext()) {
            Map.Entry<UUID, HashMap<Integer, Long>> userInvites = iterA.next();
            ArrayList<Integer> revoked = new ArrayList<Integer>();
            Iterator<Map.Entry<Integer, Long>> iterB = userInvites.getValue().entrySet().iterator();
            while (iterB.hasNext()) {
                Map.Entry<Integer, Long> entry = iterB.next();
                if (entry.getValue() >= System.currentTimeMillis()) continue;
                revoked.add(entry.getKey());
                iterB.remove();
            }
            EntityPlayerMP player = null;
            for (Object o : server.func_71203_ab().field_72404_b) {
                if (!((EntityPlayerMP)o).func_146103_bH().getId().equals(userInvites.getKey())) continue;
                player = (EntityPlayerMP)o;
                break;
            }
            if (player != null && revoked.size() >= 0) {
                int[] revAry = new int[revoked.size()];
                for (int i = 0; i < revoked.size(); ++i) {
                    revAry[i] = (Integer)revoked.get(i);
                }
                NetInviteSync.sendRevoked(player, revAry);
            }
            if (userInvites.getValue().size() > 0) continue;
            iterA.remove();
        }
    }

    public synchronized void reset() {
        this.invites.clear();
    }

    @Override
    public synchronized NBTTagList writeToNBT(NBTTagList nbt, @Nullable List<UUID> subset) {
        if (subset != null) {
            subset.forEach(uuid -> {
                NBTTagCompound userTag = new NBTTagCompound();
                userTag.func_74778_a("uuid", uuid.toString());
                Map userMap = this.invites.get(uuid);
                if (userMap == null) {
                    userMap = Collections.emptyMap();
                }
                NBTTagList invList = new NBTTagList();
                for (Map.Entry invEntry : userMap.entrySet()) {
                    NBTTagCompound invTag = new NBTTagCompound();
                    invTag.func_74768_a("partyID", ((Integer)invEntry.getKey()).intValue());
                    invTag.func_74772_a("expiry", ((Long)invEntry.getValue()).longValue());
                    invList.func_74742_a((NBTBase)invTag);
                }
                userTag.func_74782_a("invites", (NBTBase)invList);
                nbt.func_74742_a((NBTBase)userTag);
            });
        } else {
            for (Map.Entry<UUID, HashMap<Integer, Long>> userMap : this.invites.entrySet()) {
                NBTTagCompound userTag = new NBTTagCompound();
                userTag.func_74778_a("uuid", userMap.getKey().toString());
                NBTTagList invList = new NBTTagList();
                for (Map.Entry<Integer, Long> invEntry : userMap.getValue().entrySet()) {
                    NBTTagCompound invTag = new NBTTagCompound();
                    invTag.func_74768_a("partyID", invEntry.getKey().intValue());
                    invTag.func_74772_a("expiry", invEntry.getValue().longValue());
                    invList.func_74742_a((NBTBase)invTag);
                }
                userTag.func_74782_a("invites", (NBTBase)invList);
                nbt.func_74742_a((NBTBase)userTag);
            }
        }
        return nbt;
    }

    @Override
    public synchronized void readFromNBT(NBTTagList nbt, boolean merge) {
        if (!merge) {
            this.invites.clear();
        }
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            UUID uuid;
            NBTTagCompound userEntry = nbt.func_150305_b(i);
            try {
                uuid = UUID.fromString(userEntry.func_74779_i("uuid"));
            }
            catch (Exception e) {
                continue;
            }
            NBTTagList invList = userEntry.func_150295_c("invites", 10);
            HashMap map = this.invites.compute(uuid, (key, old) -> new HashMap());
            map.clear();
            for (int n = 0; n < invList.func_74745_c(); ++n) {
                long timestamp;
                NBTTagCompound invEntry = invList.func_150305_b(n);
                int partyID = invEntry.func_150297_b("partyID", 99) ? invEntry.func_74762_e("partyID") : -1;
                long l = timestamp = invEntry.func_150297_b("expiry", 99) ? invEntry.func_74763_f("expiry") : -1L;
                if (partyID < 0) continue;
                map.put(partyID, timestamp);
            }
        }
    }
}

