/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.misc;

import betterquesting.core.BetterQuesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.ResourcePackFileNotFoundException;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.IMetadataSerializer;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class QuestResourcesFile
implements IResourcePack,
Closeable {
    private static final File rootFolder = new File("config/betterquesting/resources/");
    public static final Splitter entryNameSplitter = Splitter.on((char)'/').omitEmptyStrings().limit(3);
    ArrayList<ZipFile> zipList = null;

    public InputStream func_110590_a(ResourceLocation loc) throws IOException {
        String locName = QuestResourcesFile.locationToName(loc);
        for (ZipFile zipfile : this.getZipFiles()) {
            ZipEntry zipentry = zipfile.getEntry(locName);
            if (zipentry == null) continue;
            return zipfile.getInputStream(zipentry);
        }
        throw new ResourcePackFileNotFoundException(rootFolder, locName);
    }

    public boolean func_110589_b(ResourceLocation loc) {
        String locName = QuestResourcesFile.locationToName(loc);
        try {
            for (ZipFile zipfile : this.getZipFiles()) {
                ZipEntry zipentry = zipfile.getEntry(locName);
                if (zipentry == null) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public Set<String> func_110587_b() {
        HashSet hashset = Sets.newHashSet();
        try {
            for (ZipFile f : this.getZipFiles()) {
                hashset.addAll(this.GetZipDomains(f));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashset;
    }

    public Set<String> GetZipDomains(ZipFile zipfile) {
        Enumeration<? extends ZipEntry> enumeration = zipfile.entries();
        HashSet hashset = Sets.newHashSet();
        while (enumeration.hasMoreElements()) {
            ArrayList arraylist;
            ZipEntry zipentry = enumeration.nextElement();
            String s = zipentry.getName();
            if (!s.startsWith("assets/") || (arraylist = Lists.newArrayList((Iterable)entryNameSplitter.split((CharSequence)s))).size() <= 1) continue;
            String s1 = (String)arraylist.get(1);
            if (!s1.equals(s1.toLowerCase())) {
                this.logNameNotLowercase(s1, zipfile.getName());
                continue;
            }
            hashset.add(s1);
        }
        return hashset;
    }

    public IMetadataSection func_135058_a(IMetadataSerializer meta, String s) throws IOException {
        return null;
    }

    public BufferedImage func_110586_a() throws IOException {
        return null;
    }

    public String func_130077_b() {
        return "BetterQuesting_files";
    }

    private List<ZipFile> getZipFiles() throws IOException {
        if (this.zipList != null) {
            return this.zipList;
        }
        if (!rootFolder.exists()) {
            rootFolder.mkdirs();
        }
        File[] files = rootFolder.listFiles();
        this.zipList = new ArrayList();
        for (File f : files) {
            if (!f.exists() || !f.isFile()) continue;
            try {
                this.zipList.add(new ZipFile(f));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.zipList;
    }

    private static String locationToName(ResourceLocation loc) {
        return String.format("%s/%s/%s", "assets", loc.func_110624_b(), loc.func_110623_a());
    }

    protected void logNameNotLowercase(String name, String file) {
        BetterQuesting.logger.log(Level.WARN, "ResourcePack: ignored non-lowercase namespace: {} in {}", new Object[]{name, file});
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() throws IOException {
        if (this.zipList != null) {
            for (ZipFile zip : this.zipList) {
                if (zip == null) continue;
                zip.close();
            }
            this.zipList = null;
        }
    }
}

