/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelLine;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.editors.GuiQuestEditor;
import betterquesting.network.handlers.NetQuestAction;
import betterquesting.questing.QuestDatabase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.util.vector.ReadableVector4f;
import org.lwjgl.util.vector.Vector4f;

public class GuiQuest
extends GuiScreenCanvas
implements IPEventListener,
INeedsRefresh {
    private static Map<Integer, ScrollPosition> scrollsPositions = new HashMap<Integer, ScrollPosition>();
    private ScrollPosition scrollPosition;
    private final int questID;
    private IQuest quest;
    private PanelButton btnDetect;
    private PanelButton btnClaim;
    private CanvasEmpty cvInner;
    private IGuiRect rectReward;
    private IGuiRect rectTask;
    private CanvasEmpty pnReward;
    private CanvasScrolling csReward;
    private CanvasEmpty pnTask;
    private CanvasScrolling csTask;

    public GuiQuest(GuiScreen parent, int questID) {
        super(parent);
        this.questID = questID;
        this.scrollPosition = scrollsPositions.get(questID);
        if (this.scrollPosition == null) {
            this.scrollPosition = new ScrollPosition(0, 0);
            scrollsPositions.put(questID, this.scrollPosition);
        }
    }

    @Override
    public void initPanel() {
        PanelVScrollBar paDescScroll;
        PanelTextBox paDesc;
        CanvasScrolling cvDesc;
        super.initPanel();
        this.quest = (IQuest)QuestDatabase.INSTANCE.getValue(this.questID);
        if (this.quest == null) {
            this.field_146297_k.func_147108_a(this.parent);
            return;
        }
        PEventBroadcaster.INSTANCE.register(this, PEventButton.class);
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        PanelTextBox panTxt = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), QuestTranslation.translate(this.quest.getProperty(NativeProps.NAME), new Object[0])).setAlignment(1);
        panTxt.setColor(PresetColor.TEXT_HEADER.getColor());
        cvBackground.addPanel(panTxt);
        if (QuestingAPI.getAPI(ApiReference.SETTINGS).canUserEdit((EntityPlayer)this.field_146297_k.field_71439_g)) {
            cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 100, 16, 0), 0, QuestTranslation.translate("gui.back", new Object[0])));
            cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, 0, -16, 100, 16, 0), 1, QuestTranslation.translate("betterquesting.btn.edit", new Object[0])));
        } else {
            cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), 0, QuestTranslation.translate("gui.back", new Object[0])));
        }
        this.cvInner = new CanvasEmpty(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(16, 32, 16, 24), 0));
        cvBackground.addPanel(this.cvInner);
        if (this.quest.getRewards().size() > 0) {
            cvDesc = new CanvasScrolling(new GuiTransform(new Vector4f(0.0f, 0.0f, 0.5f, 0.5f), new GuiPadding(0, 0, 16, 16), 0));
            this.cvInner.addPanel(cvDesc);
            paDesc = new PanelTextBox(new GuiRectangle(0, 0, cvDesc.getTransform().getWidth(), 0), QuestTranslation.translate(this.quest.getProperty(NativeProps.DESC), new Object[0]), true);
            paDesc.setColor(PresetColor.TEXT_MAIN.getColor());
            cvDesc.addCulledPanel(paDesc, false);
            paDescScroll = new PanelVScrollBar(new GuiTransform(GuiAlign.quickAnchor(GuiAlign.TOP_CENTER, GuiAlign.MID_CENTER), new GuiPadding(-16, 0, 8, 16), 0));
            this.cvInner.addPanel(paDescScroll);
            cvDesc.setScrollDriverY(paDescScroll);
            paDescScroll.setEnabled(cvDesc.getScrollBounds().getHeight() > 0);
            this.btnClaim = new PanelButton(new GuiTransform(new Vector4f(0.0f, 1.0f, 0.5f, 1.0f), new GuiPadding(0, -16, 8, 0), 0), 6, QuestTranslation.translate("betterquesting.btn.claim", new Object[0]));
            this.btnClaim.setActive(false);
            this.cvInner.addPanel(this.btnClaim);
            this.rectReward = new GuiTransform(new Vector4f(0.0f, 0.5f, 0.5f, 1.0f), new GuiPadding(0, 0, 8, 16), 0);
            this.rectReward.setParent(this.cvInner.getTransform());
            this.refreshRewardPanel();
        } else {
            cvDesc = new CanvasScrolling(new GuiTransform(GuiAlign.HALF_LEFT, new GuiPadding(0, 0, 16, 0), 0));
            this.cvInner.addPanel(cvDesc);
            paDesc = new PanelTextBox(new GuiRectangle(0, 0, cvDesc.getTransform().getWidth(), 0), QuestTranslation.translate(this.quest.getProperty(NativeProps.DESC), new Object[0]), true);
            paDesc.setColor(PresetColor.TEXT_MAIN.getColor());
            cvDesc.addCulledPanel(paDesc, false);
            paDescScroll = new PanelVScrollBar(new GuiTransform(GuiAlign.quickAnchor(GuiAlign.TOP_CENTER, GuiAlign.BOTTOM_CENTER), new GuiPadding(-16, 0, 8, 0), 0));
            this.cvInner.addPanel(paDescScroll);
            cvDesc.setScrollDriverY(paDescScroll);
            paDescScroll.setEnabled(cvDesc.getScrollBounds().getHeight() > 0);
        }
        this.btnDetect = new PanelButton(new GuiTransform(new Vector4f(0.5f, 1.0f, 1.0f, 1.0f), new GuiPadding(8, -16, 0, 0), 0), 7, QuestTranslation.translate("betterquesting.btn.detect_submit", new Object[0]));
        this.btnDetect.setActive(false);
        this.cvInner.addPanel(this.btnDetect);
        this.rectTask = new GuiTransform(GuiAlign.HALF_RIGHT, new GuiPadding(8, 16, 0, 16), 0);
        this.rectTask.setParent(this.cvInner.getTransform());
        this.refreshTaskPanel();
        GuiTransform ls0 = new GuiTransform(GuiAlign.TOP_CENTER, 0, 0, 0, 0, 0);
        ls0.setParent(this.cvInner.getTransform());
        GuiTransform le0 = new GuiTransform(GuiAlign.BOTTOM_CENTER, 0, 0, 0, 0, 0);
        le0.setParent(this.cvInner.getTransform());
        PanelLine paLine0 = new PanelLine(ls0, le0, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), 1);
        this.cvInner.addPanel(paLine0);
    }

    @Override
    public void refreshGui() {
        this.refreshTaskPanel();
        this.refreshRewardPanel();
        this.updateButtons();
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        if (super.onMouseClick(mx, my, click)) {
            this.updateButtons();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        try {
            if (super.onMouseScroll(mx, my, scroll)) {
                this.updateButtons();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.csReward != null) {
                this.scrollPosition.setRewardScrollY(this.csReward.getScrollY());
            }
            if (this.csTask != null) {
                this.scrollPosition.setTaskScrollY(this.csTask.getScrollY());
            }
        }
    }

    @Override
    public boolean onKeyTyped(char c, int keycode) {
        if (super.onKeyTyped(c, keycode)) {
            this.updateButtons();
            return true;
        }
        return false;
    }

    @Override
    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 0) {
            this.field_146297_k.func_147108_a(this.parent);
        } else if (btn.getButtonID() == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestEditor(this, this.questID));
        } else if (btn.getButtonID() == 6) {
            NetQuestAction.requestClaim(new int[]{this.questID});
        } else if (btn.getButtonID() == 7) {
            NetQuestAction.requestDetect(new int[]{this.questID});
        }
    }

    private void refreshRewardPanel() {
        if (this.pnReward != null) {
            this.cvInner.removePanel(this.pnReward);
        }
        if (this.rectReward == null) {
            this.initPanel();
            return;
        }
        this.pnReward = new CanvasEmpty(this.rectReward);
        this.cvInner.addPanel(this.pnReward);
        int yOffset = 0;
        this.csReward = new CanvasScrolling(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 8, 0), 0));
        this.pnReward.addPanel(this.csReward);
        PanelVScrollBar scList = new PanelVScrollBar(new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 0, 0, 0), 0));
        this.pnReward.addPanel(scList);
        this.csReward.setScrollDriverY(scList);
        for (DBEntry entry : this.quest.getRewards().getEntries()) {
            IReward rew = (IReward)entry.getValue();
            PanelTextBox titleReward = new PanelTextBox(new GuiTransform((ReadableVector4f)new Vector4f(), 0, yOffset, this.rectReward.getWidth(), 12, 0), QuestTranslation.translate(rew.getUnlocalisedName(), new Object[0]));
            titleReward.setColor(PresetColor.TEXT_HEADER.getColor()).setAlignment(1);
            titleReward.setEnabled(true);
            this.csReward.addPanel(titleReward);
            IGuiPanel rewardGui = rew.getRewardGui(new GuiTransform(GuiAlign.FULL_BOX, 0, 0, this.rectReward.getWidth(), this.rectReward.getHeight(), 111), new DBEntry<IQuest>(this.questID, this.quest));
            rewardGui.initPanel();
            CanvasEmpty tempCanvas = new CanvasEmpty(new GuiTransform(GuiAlign.TOP_LEFT, 0, yOffset += 12, this.rectReward.getWidth(), rewardGui.getTransform().getHeight() - rewardGui.getTransform().getY(), 1));
            this.csReward.addPanel(tempCanvas);
            tempCanvas.addPanel(rewardGui);
            yOffset += tempCanvas.getTransform().getHeight();
        }
        this.csReward.setScrollY(this.scrollPosition.getRewardScrollY());
        this.updateButtons();
    }

    private void refreshTaskPanel() {
        if (this.pnTask != null) {
            this.cvInner.removePanel(this.pnTask);
        }
        this.pnTask = new CanvasEmpty(this.rectTask);
        this.cvInner.addPanel(this.pnTask);
        this.csTask = new CanvasScrolling(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 8, 0), 0));
        this.pnTask.addPanel(this.csTask);
        PanelVScrollBar scList = new PanelVScrollBar(new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 0, 0, 0), 0));
        this.pnTask.addPanel(scList);
        this.csTask.setScrollDriverY(scList);
        int yOffset = 0;
        List entries = this.quest.getTasks().getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            ITask tsk = (ITask)entries.get(i).getValue();
            String taskName = i + 1 + ". " + QuestTranslation.translate(tsk.getUnlocalisedName(), new Object[0]);
            PanelTextBox titleReward = new PanelTextBox(new GuiTransform((ReadableVector4f)new Vector4f(), 0, yOffset, this.rectTask.getWidth(), 12, 0), taskName);
            titleReward.setColor(PresetColor.TEXT_HEADER.getColor()).setAlignment(1);
            titleReward.setEnabled(true);
            this.csTask.addPanel(titleReward);
            IGuiPanel taskGui = tsk.getTaskGui(new GuiTransform(GuiAlign.FULL_BOX, 0, 0, this.rectTask.getWidth(), this.rectTask.getHeight(), 0), new DBEntry<IQuest>(this.questID, this.quest));
            taskGui.initPanel();
            CanvasEmpty tempCanvas = new CanvasEmpty(new GuiTransform(GuiAlign.TOP_LEFT, 0, yOffset += 10, this.rectTask.getWidth(), taskGui.getTransform().getHeight() - taskGui.getTransform().getY(), 1));
            this.csTask.addPanel(tempCanvas);
            tempCanvas.addPanel(taskGui);
            int guiHeight = tempCanvas.getTransform().getHeight();
            yOffset += guiHeight;
            yOffset += 8;
        }
        this.csTask.setScrollY(this.scrollPosition.getTaskScrollY());
        this.updateButtons();
    }

    private void updateButtons() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.btnClaim != null) {
            this.btnClaim.setActive(this.quest.getRewards().size() > 0 && this.quest.canClaim((EntityPlayer)mc.field_71439_g));
        }
        if (this.btnDetect != null) {
            this.btnDetect.setActive(this.quest.canSubmit((EntityPlayer)mc.field_71439_g));
        }
    }

    public static class ScrollPosition {
        private int taskScrollY;
        private int rewardScrollY;

        public ScrollPosition(int taskScrollY, int rewardScrollY) {
            this.taskScrollY = taskScrollY;
            this.rewardScrollY = rewardScrollY;
        }

        public int getTaskScrollY() {
            return this.taskScrollY;
        }

        public void setTaskScrollY(int taskScrollY) {
            this.taskScrollY = taskScrollY;
        }

        public int getRewardScrollY() {
            return this.rewardScrollY;
        }

        public void setRewardScrollY(int rewardScrollY) {
            this.rewardScrollY = rewardScrollY;
        }
    }
}

