/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.Tuple2;
import betterquesting.client.importers.ImportedQuestLines;
import betterquesting.client.importers.ImportedQuests;
import betterquesting.core.BetterQuesting;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeRegistry;
import betterquesting.network.handlers.NetChapterSync;
import betterquesting.network.handlers.NetQuestSync;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class NetImport {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting:import");

    public static void registerHandler() {
        PacketTypeRegistry.INSTANCE.registerServerHandler(ID_NAME, NetImport::onServer);
    }

    public static void sendImport(@Nonnull IQuestDatabase questDB, @Nonnull IQuestLineDatabase chapterDB) {
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74782_a("quests", (NBTBase)questDB.writeToNBT(new NBTTagList(), null));
        payload.func_74782_a("chapters", (NBTBase)chapterDB.writeToNBT(new NBTTagList(), null));
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple2<NBTTagCompound, EntityPlayerMP> message) {
        EntityPlayerMP sender = message.func_76340_b();
        if (sender.field_71133_b == null) {
            return;
        }
        boolean isOP = sender.field_71133_b.func_71203_ab().func_152596_g(sender.func_146103_bH());
        if (!isOP) {
            BetterQuesting.logger.log(Level.WARN, "Player " + sender.func_70005_c_() + " (UUID:" + QuestingAPI.getQuestingUUID((EntityPlayer)sender) + ") tried to import quests without OP permissions!");
            sender.func_146105_b((IChatComponent)new ChatComponentText(ChatFormatting.RED + "You need to be OP to edit quests!"));
            return;
        }
        ImportedQuests impQuestDB = new ImportedQuests();
        ImportedQuestLines impQuestLineDB = new ImportedQuestLines();
        impQuestDB.readFromNBT(message.func_76341_a().func_150295_c("quests", 10), false);
        impQuestLineDB.readFromNBT(message.func_76341_a().func_150295_c("chapters", 10), false);
        BetterQuesting.logger.log(Level.INFO, "Importing " + impQuestDB.size() + " quest(s) and " + impQuestLineDB.size() + " quest line(s) from " + sender.func_146103_bH().getName());
        HashMap<Integer, Integer> remapped = NetImport.getRemappedIDs(impQuestDB.getEntries());
        for (DBEntry entry : impQuestDB.getEntries()) {
            int[] oldIDs = Arrays.copyOf(((IQuest)entry.getValue()).getRequirements(), ((IQuest)entry.getValue()).getRequirements().length);
            for (int n = 0; n < oldIDs.length; ++n) {
                if (!remapped.containsKey(oldIDs[n])) continue;
                oldIDs[n] = remapped.get(oldIDs[n]);
            }
            ((IQuest)entry.getValue()).setRequirements(oldIDs);
            QuestDatabase.INSTANCE.add(remapped.get(entry.getID()), entry.getValue());
        }
        for (DBEntry questLine : impQuestLineDB.getEntries()) {
            ArrayList pendingQLE = new ArrayList();
            for (DBEntry dBEntry : ((IQuestLine)questLine.getValue()).getEntries()) {
                pendingQLE.add(dBEntry);
                ((IQuestLine)questLine.getValue()).removeID(dBEntry.getID());
            }
            for (DBEntry<Object> dBEntry : pendingQLE) {
                if (!remapped.containsKey(dBEntry.getID())) {
                    BetterQuesting.logger.error("Failed to import quest into quest line. Unable to remap ID " + dBEntry.getID());
                    continue;
                }
                ((IQuestLine)questLine.getValue()).add(remapped.get(dBEntry.getID()), dBEntry.getValue());
            }
            QuestLineDatabase.INSTANCE.add(QuestLineDatabase.INSTANCE.nextID(), questLine.getValue());
        }
        SaveLoadHandler.INSTANCE.markDirty();
        NetQuestSync.quickSync(-1, true, true);
        NetChapterSync.sendSync(null, null);
    }

    private static HashMap<Integer, Integer> getRemappedIDs(List<DBEntry<IQuest>> idList) {
        int[] nextIDs = NetImport.getNextIDs(idList.size());
        HashMap<Integer, Integer> remapped = new HashMap<Integer, Integer>();
        for (int i = 0; i < nextIDs.length; ++i) {
            remapped.put(idList.get(i).getID(), nextIDs[i]);
        }
        return remapped;
    }

    private static int[] getNextIDs(int num) {
        List listDB = QuestDatabase.INSTANCE.getEntries();
        int[] nxtIDs = new int[num];
        if (listDB.size() <= 0 || listDB.get(listDB.size() - 1).getID() == listDB.size() - 1) {
            for (int i = 0; i < num; ++i) {
                nxtIDs[i] = listDB.size() + i;
            }
            return nxtIDs;
        }
        int n1 = 0;
        int n2 = 0;
        for (int i = 0; i < num; ++i) {
            while (n2 < listDB.size() && listDB.get(n2).getID() == n1) {
                ++n1;
                ++n2;
            }
            nxtIDs[i] = n1++;
        }
        return nxtIDs;
    }
}

