/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.commands.admin;

import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.storage.DBEntry;
import betterquesting.commands.QuestCommandBase;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.network.handlers.NetQuestSync;
import betterquesting.questing.QuestDatabase;
import betterquesting.storage.NameCache;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class QuestCommandReset
extends QuestCommandBase {
    @Override
    public String getUsageSuffix() {
        return "[all|<quest_id>] [username|uuid]";
    }

    @Override
    public boolean validArgs(String[] args) {
        return args.length == 2 || args.length == 3;
    }

    @Override
    public List<String> autoComplete(MinecraftServer server, ICommandSender sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 2) {
            list.add("all");
            for (DBEntry i : QuestDatabase.INSTANCE.getEntries()) {
                list.add("" + i.getID());
            }
        } else if (args.length == 3) {
            return CommandBase.func_71530_a((String[])args, (String[])NameCache.INSTANCE.getAllNames().toArray(new String[0]));
        }
        return list;
    }

    @Override
    public String getCommand() {
        return "reset";
    }

    @Override
    public void runCommand(MinecraftServer server, CommandBase command, ICommandSender sender, String[] args) {
        String action = args[1];
        UUID uuid = null;
        if (args.length == 3 && (uuid = this.findPlayerID(server, sender, args[2])) == null) {
            throw this.getException(command);
        }
        String pName = uuid == null ? "NULL" : NameCache.INSTANCE.getName(uuid);
        EntityPlayerMP player = null;
        if (uuid != null) {
            for (EntityPlayerMP entityPlayerMP : server.func_71203_ab().field_72404_b) {
                if (!entityPlayerMP.func_146103_bH().getId().equals(uuid)) continue;
                player = entityPlayerMP;
                break;
            }
        }
        if (action.equalsIgnoreCase("all")) {
            for (DBEntry dBEntry : QuestDatabase.INSTANCE.getEntries()) {
                if (uuid != null) {
                    ((IQuest)dBEntry.getValue()).resetUser(uuid, true);
                    continue;
                }
                ((IQuest)dBEntry.getValue()).resetUser(null, true);
            }
            SaveLoadHandler.INSTANCE.markDirty();
            if (uuid != null) {
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("betterquesting.cmd.reset.player_all", new Object[]{pName}));
                if (player != null) {
                    NetQuestSync.sendSync(player, null, false, true, true);
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("betterquesting.cmd.reset.all_all", new Object[0]));
                NetQuestSync.quickSync(-1, false, true);
            }
        } else {
            try {
                int id = Integer.parseInt(action.trim());
                IQuest iQuest = (IQuest)QuestDatabase.INSTANCE.getValue(id);
                if (uuid != null) {
                    iQuest.resetUser(uuid, true);
                    SaveLoadHandler.INSTANCE.markDirty();
                    sender.func_145747_a((IChatComponent)new ChatComponentTranslation("betterquesting.cmd.reset.player_single", new Object[]{new ChatComponentTranslation(iQuest.getProperty(NativeProps.NAME), new Object[0]), pName}));
                    if (player != null) {
                        NetQuestSync.sendSync(player, new int[]{id}, false, true, true);
                    }
                } else {
                    iQuest.resetUser(null, true);
                    SaveLoadHandler.INSTANCE.markDirty();
                    sender.func_145747_a((IChatComponent)new ChatComponentTranslation("betterquesting.cmd.reset.all_single", new Object[]{new ChatComponentTranslation(iQuest.getProperty(NativeProps.NAME), new Object[0])}));
                    NetQuestSync.quickSync(id, false, true);
                }
            }
            catch (Exception e) {
                throw this.getException(command);
            }
        }
    }

    @Override
    public boolean isArgUsername(String[] args, int index) {
        return index == 2;
    }
}

