/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.core;

import betterquesting.api.placeholders.EntityPlaceholder;
import betterquesting.api.placeholders.FluidPlaceholder;
import betterquesting.api.placeholders.ItemPlaceholder;
import betterquesting.blocks.BlockObservationStation;
import betterquesting.blocks.BlockSubmitStation;
import betterquesting.blocks.TileObservationStation;
import betterquesting.blocks.TileSubmitStation;
import betterquesting.client.CreativeTabQuesting;
import betterquesting.commands.BQ_CommandAdmin;
import betterquesting.commands.BQ_CommandDebug;
import betterquesting.commands.BQ_CommandUser;
import betterquesting.commands.BQ_CopyProgress;
import betterquesting.core.proxies.CommonProxy;
import betterquesting.handlers.ConfigHandler;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.items.ItemExtraLife;
import betterquesting.items.ItemGuideBook;
import betterquesting.network.PacketQuesting;
import betterquesting.network.PacketTypeRegistry;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="betterquesting", name="BetterQuesting", version="3.1.8-GTNH", guiFactory="betterquesting.handlers.ConfigGuiFactory")
public class BetterQuesting {
    public static final String MODID = "betterquesting";
    public static final String NAME = "BetterQuesting";
    public static final String VERSION = "3.1.8-GTNH";
    public static final String PROXY = "betterquesting.core.proxies";
    public static final String CHANNEL = "BQ_NET_CHAN";
    public static final String FORMAT = "2.0.0";
    @Mod.Instance(value="betterquesting")
    public static BetterQuesting instance;
    @SidedProxy(clientSide="betterquesting.core.proxies.ClientProxy", serverSide="betterquesting.core.proxies.CommonProxy")
    public static CommonProxy proxy;
    public SimpleNetworkWrapper network;
    public static Logger logger;
    public static CreativeTabs tabQuesting;
    public static Item extraLife;
    public static Item guideBook;
    public static Block submitStation;
    public static Block observationStation;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel(CHANNEL);
        ConfigHandler.config = new Configuration(event.getSuggestedConfigurationFile(), true);
        ConfigHandler.initConfigs();
        proxy.registerHandlers();
        PacketTypeRegistry.INSTANCE.init();
        this.network.registerMessage(PacketQuesting.HandleClient.class, PacketQuesting.class, 0, Side.CLIENT);
        this.network.registerMessage(PacketQuesting.HandleServer.class, PacketQuesting.class, 0, Side.SERVER);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FluidRegistry.registerFluid((Fluid)FluidPlaceholder.fluidPlaceholder);
        GameRegistry.registerItem((Item)ItemPlaceholder.placeholder, (String)"placeholder");
        GameRegistry.registerItem((Item)extraLife, (String)"extra_life");
        GameRegistry.registerItem((Item)guideBook, (String)"guide_book");
        GameRegistry.registerBlock((Block)submitStation, (String)"submit_station");
        GameRegistry.registerTileEntity(TileSubmitStation.class, (String)"submit_station");
        GameRegistry.registerBlock((Block)observationStation, (String)"observation_station");
        GameRegistry.registerTileEntity(TileObservationStation.class, (String)"observation_station");
        if (!Loader.isModLoaded((String)"dreamcraft")) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(submitStation), (Object[])new Object[]{new ItemStack(Items.field_151122_aG), new ItemStack(Blocks.field_150359_w), new ItemStack((Block)Blocks.field_150486_ae)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(submitStation), (Object[])new Object[]{new ItemStack(Items.field_151122_aG), new ItemStack((Block)Blocks.field_150486_ae), new ItemStack(Blocks.field_150359_w)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(observationStation), (Object[])new Object[]{new ItemStack(submitStation), new ItemStack(Items.field_151132_bS)});
        }
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(extraLife, 1, 0), (Object[])new Object[]{new ItemStack(extraLife, 1, 2), new ItemStack(extraLife, 1, 2), new ItemStack(extraLife, 1, 2), new ItemStack(extraLife, 1, 2)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(extraLife, 1, 0), (Object[])new Object[]{new ItemStack(extraLife, 1, 2), new ItemStack(extraLife, 1, 2), new ItemStack(extraLife, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(extraLife, 1, 0), (Object[])new Object[]{new ItemStack(extraLife, 1, 1), new ItemStack(extraLife, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(extraLife, 2, 1), (Object[])new Object[]{new ItemStack(extraLife, 1, 0)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(extraLife, 1, 1), (Object[])new Object[]{new ItemStack(extraLife, 1, 2), new ItemStack(extraLife, 1, 2)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(extraLife, 2, 2), (Object[])new Object[]{new ItemStack(extraLife, 1, 1)});
        EntityRegistry.registerModEntity(EntityPlaceholder.class, (String)"placeholder", (int)0, (Object)this, (int)16, (int)1, (boolean)false);
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        ICommandManager command = server.func_71187_D();
        ServerCommandManager manager = (ServerCommandManager)command;
        manager.func_71560_a((ICommand)new BQ_CopyProgress());
        manager.func_71560_a((ICommand)new BQ_CommandAdmin());
        manager.func_71560_a((ICommand)new BQ_CommandUser());
        if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            manager.func_71560_a((ICommand)new BQ_CommandDebug());
        }
        SaveLoadHandler.INSTANCE.loadDatabases(server);
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        SaveLoadHandler.INSTANCE.unloadDatabases();
    }

    static {
        tabQuesting = new CreativeTabQuesting();
        extraLife = new ItemExtraLife();
        guideBook = new ItemGuideBook();
        submitStation = new BlockSubmitStation();
        observationStation = new BlockObservationStation();
    }
}

