/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.importers.hqm;

import betterquesting.api.client.importers.IImporter;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api.utils.FileExtensionFilter;
import betterquesting.api.utils.JsonHelper;
import bq_standard.importers.hqm.HQMUtilities;
import bq_standard.network.handlers.NetLootImport;
import bq_standard.rewards.loot.LootGroup;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class HQMBagImporter
implements IImporter {
    public static final HQMBagImporter INSTANCE = new HQMBagImporter();
    private List<LootGroup> hqmLoot = new ArrayList<LootGroup>();

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.importer.hqm_bag.name";
    }

    @Override
    public String getUnlocalisedDescription() {
        return "bq_standard.importer.hqm_bag.desc";
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileExtensionFilter(".json");
    }

    private void ImportJsonBags(JsonArray json) {
        for (JsonElement e : json) {
            if (e == null || !e.isJsonObject()) continue;
            JsonObject jGrp = e.getAsJsonObject();
            LootGroup group = new LootGroup();
            group.name = JsonHelper.GetString(jGrp, "name", "HQM Loot");
            try {
                int tmp = 0;
                JsonArray jWht = JsonHelper.GetArray(jGrp, "weights");
                for (int i = 0; i < jWht.size(); ++i) {
                    JsonElement w = jWht.get(i);
                    if (w == null || !w.isJsonPrimitive() || !w.getAsJsonPrimitive().isNumber()) continue;
                    tmp += w.getAsInt() * (jWht.size() - i);
                }
                group.weight = Math.max(1, tmp / 4);
            }
            catch (Exception ex) {
                group.weight = 1;
            }
            for (JsonElement e2 : JsonHelper.GetArray(jGrp, "groups")) {
                if (e2 == null || !e2.isJsonObject()) continue;
                JsonObject je = e2.getAsJsonObject();
                LootGroup.LootEntry lEntry = new LootGroup.LootEntry();
                lEntry.weight = JsonHelper.GetNumber(je, "limit", 1).intValue();
                for (JsonElement ji : JsonHelper.GetArray(je, "items")) {
                    if (ji == null || !ji.isJsonObject()) continue;
                    lEntry.items.add(HQMUtilities.HQMStackT1(ji.getAsJsonObject()));
                }
                group.add(group.nextID(), lEntry);
            }
            this.hqmLoot.add(group);
        }
    }

    @Override
    public void loadFiles(IQuestDatabase questDB, IQuestLineDatabase lineDB, File[] files) {
        this.hqmLoot.clear();
        for (File selected : files) {
            JsonArray json;
            if (selected == null || !selected.exists() || (json = this.ReadFromFile(selected)) == null || json.size() <= 0) continue;
            this.ImportJsonBags(json);
        }
        NBTTagCompound tags = new NBTTagCompound();
        NBTTagCompound base = new NBTTagCompound();
        NBTTagList jAry = new NBTTagList();
        for (LootGroup group : this.hqmLoot) {
            NBTTagCompound jGrp = new NBTTagCompound();
            group.writeToNBT(jGrp);
            jAry.func_74742_a((NBTBase)jGrp);
        }
        base.func_74782_a("groups", (NBTBase)jAry);
        tags.func_74782_a("data", (NBTBase)base);
        NetLootImport.importLoot(tags);
    }

    private JsonArray ReadFromFile(File file) {
        if (file == null || !file.exists()) {
            return new JsonArray();
        }
        try {
            InputStreamReader fr = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
            JsonArray json = (JsonArray)new Gson().fromJson((Reader)fr, JsonArray.class);
            fr.close();
            return json;
        }
        catch (Exception e) {
            return new JsonArray();
        }
    }
}

