/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.commands.admin;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.commands.QuestCommandBase;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.network.handlers.NetChapterSync;
import betterquesting.network.handlers.NetQuestSync;
import betterquesting.network.handlers.NetSettingSync;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestInstance;
import betterquesting.questing.QuestLineDatabase;
import betterquesting.storage.QuestSettings;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SortedSetMultimap;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;

public class QuestCommandDefaults
extends QuestCommandBase {
    public static final String DEFAULT_FILE = "DefaultQuests";
    public static final String LANG_FILE = "en_US.lang";
    public static final String SETTINGS_FILE = "QuestSettings.json";
    public static final String QUEST_LINES_FILE = "QuestLines.json";
    public static final String QUEST_DIR = "Quests";
    public static final String MULTI_QUEST_LINE_DIRECTORY = "MultipleQuestLine";
    public static final String NO_QUEST_LINE_DIRECTORY = "NoQuestLine";

    @Override
    public String getUsageSuffix() {
        return "[save|load|set] [file_name]";
    }

    @Override
    public boolean validArgs(String[] args) {
        return args.length == 2 || args.length == 3;
    }

    @Override
    public List<String> autoComplete(MinecraftServer server, ICommandSender sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 2) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"save", "savelegacy", "load", "set"});
        }
        if (args.length == 3) {
            list.add(DEFAULT_FILE);
        }
        return list;
    }

    @Override
    public String getCommand() {
        return "default";
    }

    @Override
    public void runCommand(MinecraftServer server, CommandBase command, ICommandSender sender, String[] args) {
        File legacyFile;
        File dataDir;
        String databaseName;
        if (args.length == 3 && !args[2].equalsIgnoreCase(DEFAULT_FILE)) {
            databaseName = args[2];
            dataDir = new File(BQ_Settings.defaultDir, "saved_quests/" + args[2]);
            legacyFile = new File(BQ_Settings.defaultDir, "saved_quests/" + args[2] + ".json");
        } else {
            databaseName = null;
            dataDir = new File(BQ_Settings.defaultDir, DEFAULT_FILE);
            legacyFile = new File(BQ_Settings.defaultDir, "DefaultQuests.json");
        }
        if (args[1].equalsIgnoreCase("save")) {
            QuestCommandDefaults.save(sender, databaseName, dataDir);
        } else if (args[1].equalsIgnoreCase("savelegacy")) {
            QuestCommandDefaults.saveLegacy(sender, databaseName, legacyFile);
        } else if (args[1].equalsIgnoreCase("load")) {
            if (!dataDir.exists() && legacyFile.exists()) {
                QuestCommandDefaults.loadLegacy(sender, databaseName, legacyFile, false);
            } else {
                QuestCommandDefaults.load(sender, databaseName, dataDir, false);
            }
        } else if (args[1].equalsIgnoreCase("set") && args.length == 3) {
            if (!dataDir.exists() && legacyFile.exists()) {
                QuestCommandDefaults.setLegacy(sender, databaseName, legacyFile);
            } else {
                QuestCommandDefaults.set(sender, databaseName, dataDir);
            }
        } else {
            throw this.getException(command);
        }
    }

    private static void sendChatMessage(@Nullable ICommandSender sender, String translationKey, Object ... args) {
        if (sender == null) {
            return;
        }
        sender.func_145747_a((IChatComponent)new ChatComponentTranslation(translationKey, args));
    }

    public static void save(@Nullable ICommandSender sender, @Nullable String databaseName, File dataDir) {
        BiFunction<String, String, String> buildFileName = (name, id) -> name.replaceAll("[^a-zA-Z0-9]", "") + "-" + id;
        File settingsFile = new File(dataDir, SETTINGS_FILE);
        if (dataDir.exists()) {
            if (!settingsFile.exists()) {
                QuestingAPI.getLogger().log(Level.ERROR, "Directory exists, but isn't a database\n{}", new Object[]{dataDir});
                QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.error", new Object[0]);
                return;
            }
            try {
                FileUtils.deleteDirectory((File)dataDir);
            }
            catch (IOException e) {
                QuestingAPI.getLogger().log(Level.ERROR, "Failed to delete directory\n" + dataDir, (Throwable)e);
                QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.error", new Object[0]);
                return;
            }
        }
        if (!dataDir.mkdirs()) {
            QuestingAPI.getLogger().log(Level.ERROR, "Failed to create directory\n{}", new Object[]{dataDir});
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.error", new Object[0]);
            return;
        }
        boolean editMode = QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE);
        QuestSettings.INSTANCE.setProperty(NativeProps.EDIT_MODE, false);
        NBTTagCompound settingsTag = QuestSettings.INSTANCE.writeToNBT(new NBTTagCompound());
        settingsTag.func_74778_a("format", "3.0.0");
        JsonHelper.WriteToFile(settingsFile, NBTConverter.NBTtoJSON_Compound(settingsTag, new JsonObject(), true));
        QuestSettings.INSTANCE.setProperty(NativeProps.EDIT_MODE, editMode);
        File questLinesFile = new File(dataDir, QUEST_LINES_FILE);
        NBTTagCompound questLinesTag = new NBTTagCompound();
        questLinesTag.func_74782_a("questLines", (NBTBase)QuestLineDatabase.INSTANCE.writeToNBT(new NBTTagList(), (List<UUID>)null));
        JsonHelper.WriteToFile(questLinesFile, NBTConverter.NBTtoJSON_Compound(questLinesTag, new JsonObject(), true));
        ListMultimap questToQuestLineMultimap = MultimapBuilder.hashKeys().arrayListValues().build();
        for (IQuestLine questLine : QuestLineDatabase.INSTANCE.values()) {
            questLine.keySet().forEach(key -> questToQuestLineMultimap.put(key, (Object)questLine));
        }
        TreeMap<UUID, IQuest> questsInMultipleQuestLines = new TreeMap<UUID, IQuest>();
        TreeMap<UUID, IQuest> questsInZeroQuestLines = new TreeMap<UUID, IQuest>();
        for (Map.Entry entry : QuestDatabase.INSTANCE.entrySet()) {
            UUID questId = entry.getKey();
            IQuest quest2 = (IQuest)entry.getValue();
            List questLines = questToQuestLineMultimap.get((Object)questId);
            File questDir = new File(dataDir, QUEST_DIR);
            switch (questLines.size()) {
                case 0: {
                    questsInZeroQuestLines.put(questId, quest2);
                    questDir = new File(questDir, NO_QUEST_LINE_DIRECTORY);
                    break;
                }
                case 1: {
                    IQuestLine questLine = (IQuestLine)questLines.get(0);
                    UUID questLineId = QuestLineDatabase.INSTANCE.lookupKey(questLine);
                    String questLineName = (String)questLine.getProperty(NativeProps.NAME);
                    questDir = new File(questDir, buildFileName.apply(questLineName, questLineId.toString()));
                    break;
                }
                default: {
                    questsInMultipleQuestLines.put(questId, quest2);
                    questDir = new File(questDir, MULTI_QUEST_LINE_DIRECTORY);
                }
            }
            String questName = quest2.getProperty(NativeProps.NAME);
            File questFile = new File(questDir, buildFileName.apply(questName, questId.toString()) + ".json");
            if (!questFile.exists() && !questFile.mkdirs()) {
                QuestingAPI.getLogger().log(Level.ERROR, "Failed to create directories\n{}", new Object[]{questFile});
                QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.error", new Object[0]);
                return;
            }
            NBTTagCompound questTag = quest2.writeToNBT(new NBTTagCompound());
            NBTConverter.UuidValueType.QUEST.writeId(questId, questTag);
            JsonHelper.WriteToFile(questFile, NBTConverter.NBTtoJSON_Compound(questTag, new JsonObject(), true));
        }
        File langFile = new File(dataDir, LANG_FILE);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(langFile.toPath(), new OpenOption[0]));){
            Function<String, String> removeNewlines = s -> s.replaceAll("\n", "");
            Function<String, String> escapeLangString = s -> s.replaceAll("%", "%%").replaceAll("\n", "%n");
            Consumer<IQuest> writeQuest = quest -> {
                UUID questId = QuestDatabase.INSTANCE.lookupKey(quest);
                try {
                    writer.write(String.format("\n# Quest: %s\n", removeNewlines.apply(quest.getProperty(NativeProps.NAME))));
                    writer.write(String.format("%s=%s\n", QuestTranslation.buildQuestNameKey(questId), escapeLangString.apply(quest.getProperty(NativeProps.NAME))));
                    writer.write(String.format("%s=%s\n", QuestTranslation.buildQuestDescriptionKey(questId), escapeLangString.apply(quest.getProperty(NativeProps.DESC))));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
            writer.write("### Quest Lines ###\n");
            for (Map.Entry<UUID, IQuestLine> entry : QuestLineDatabase.INSTANCE.getOrderedEntries()) {
                UUID questLineId = entry.getKey();
                IQuestLine questLine = entry.getValue();
                writer.write(String.format("\n\n## Quest Line: %s\n", removeNewlines.apply((String)questLine.getProperty(NativeProps.NAME))));
                writer.write(String.format("%s=%s\n", QuestTranslation.buildQuestLineNameKey(questLineId), escapeLangString.apply((String)questLine.getProperty(NativeProps.NAME))));
                writer.write(String.format("%s=%s\n", QuestTranslation.buildQuestLineDescriptionKey(questLineId), escapeLangString.apply((String)questLine.getProperty(NativeProps.DESC))));
                TreeMap<UUID, IQuest> quests = new TreeMap<UUID, IQuest>(QuestDatabase.INSTANCE.filterKeys(questLine.keySet()));
                QuestCommandDefaults.orderByRequirements(quests).forEach(writeQuest);
            }
            writer.write("\n\n### Quests in multiple quest lines ###\n");
            QuestCommandDefaults.orderByRequirements(questsInMultipleQuestLines).forEach(writeQuest);
            writer.write("\n\n### Quests in no quest lines ###\n");
            QuestCommandDefaults.orderByRequirements(questsInZeroQuestLines).forEach(writeQuest);
        }
        catch (IOException e) {
            QuestingAPI.getLogger().log(Level.ERROR, "Failed to create file\n" + langFile, (Throwable)e);
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.error", new Object[0]);
            return;
        }
        if (databaseName != null && !databaseName.equalsIgnoreCase(DEFAULT_FILE)) {
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.save2", databaseName);
        } else {
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.save", new Object[0]);
        }
    }

    public static void saveLegacy(@Nullable ICommandSender sender, @Nullable String databaseName, File legacyFile) {
        boolean editMode = QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE);
        NBTTagCompound base = new NBTTagCompound();
        QuestSettings.INSTANCE.setProperty(NativeProps.EDIT_MODE, false);
        base.func_74782_a("questSettings", (NBTBase)QuestSettings.INSTANCE.writeToNBT(new NBTTagCompound()));
        QuestSettings.INSTANCE.setProperty(NativeProps.EDIT_MODE, editMode);
        base.func_74782_a("questDatabase", (NBTBase)QuestDatabase.INSTANCE.writeToNBT(new NBTTagList(), (List<UUID>)null));
        base.func_74782_a("questLines", (NBTBase)QuestLineDatabase.INSTANCE.writeToNBT(new NBTTagList(), (List<UUID>)null));
        base.func_74778_a("format", "3.0.0");
        JsonHelper.WriteToFile(legacyFile, NBTConverter.NBTtoJSON_Compound(base, new JsonObject(), true));
        if (databaseName != null && !databaseName.equalsIgnoreCase(DEFAULT_FILE)) {
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.save2", databaseName + ".json");
        } else {
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.save", new Object[0]);
        }
    }

    public static void load(@Nullable ICommandSender sender, @Nullable String databaseName, File dataDir, boolean loadWorldSettings) {
        if (!dataDir.exists()) {
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.none", new Object[0]);
            return;
        }
        Function<File, NBTTagCompound> readNbt = file -> NBTConverter.JSONtoNBT_Object(JsonHelper.ReadFromFile(file), new NBTTagCompound(), true);
        boolean editMode = QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE);
        boolean hardMode = QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE);
        NBTTagList jsonP = QuestDatabase.INSTANCE.writeProgressToNBT(new NBTTagList(), (List<UUID>)null);
        File settingsFile = new File(dataDir, SETTINGS_FILE);
        if (!settingsFile.exists()) {
            QuestingAPI.getLogger().log(Level.ERROR, "Failed to find file\n{}", new Object[]{settingsFile});
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.error", new Object[0]);
            return;
        }
        QuestSettings.INSTANCE.readFromNBT(readNbt.apply(settingsFile));
        File questLinesFile = new File(dataDir, QUEST_LINES_FILE);
        if (!questLinesFile.exists()) {
            QuestingAPI.getLogger().log(Level.ERROR, "Failed to find file\n{}", new Object[]{questLinesFile});
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.error", new Object[0]);
            return;
        }
        NBTTagCompound questLinesTag = readNbt.apply(questLinesFile);
        QuestLineDatabase.INSTANCE.readFromNBT(questLinesTag.func_150295_c("questLines", 10), false);
        File questDir = new File(dataDir, QUEST_DIR);
        QuestDatabase.INSTANCE.clear();
        try (Stream<Path> paths = Files.walk(questDir.toPath(), new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                File questFile = path.toFile();
                NBTTagCompound questTag = (NBTTagCompound)readNbt.apply(questFile);
                UUID questId = NBTConverter.UuidValueType.QUEST.readId(questTag);
                QuestInstance quest = new QuestInstance();
                quest.readFromNBT(questTag);
                QuestDatabase.INSTANCE.put(questId, quest);
            });
        }
        catch (IOException e) {
            QuestingAPI.getLogger().log(Level.ERROR, "Failed to traverse directory\n" + questDir, (Throwable)e);
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.error", new Object[0]);
            return;
        }
        if (!loadWorldSettings) {
            QuestDatabase.INSTANCE.readProgressFromNBT(jsonP, false);
            QuestSettings.INSTANCE.setProperty(NativeProps.EDIT_MODE, editMode);
            QuestSettings.INSTANCE.setProperty(NativeProps.HARDCORE, hardMode);
        }
        if (databaseName != null && !databaseName.equalsIgnoreCase(DEFAULT_FILE)) {
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.load2", databaseName);
        } else {
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.load", new Object[0]);
        }
        NetSettingSync.sendSync(null);
        NetQuestSync.quickSync(null, true, true);
        NetChapterSync.sendSync(null, null);
        SaveLoadHandler.INSTANCE.markDirty();
    }

    public static void loadLegacy(@Nullable ICommandSender sender, @Nullable String databaseName, File legacyFile, boolean loadWorldSettings) {
        if (legacyFile.exists()) {
            boolean editMode = QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE);
            boolean hardMode = QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE);
            NBTTagList jsonP = QuestDatabase.INSTANCE.writeProgressToNBT(new NBTTagList(), (List<UUID>)null);
            JsonObject j1 = JsonHelper.ReadFromFile(legacyFile);
            NBTTagCompound nbt1 = NBTConverter.JSONtoNBT_Object(j1, new NBTTagCompound(), true);
            QuestSettings.INSTANCE.readFromNBT(nbt1.func_74775_l("questSettings"));
            QuestDatabase.INSTANCE.readFromNBT(nbt1.func_150295_c("questDatabase", 10), false);
            QuestLineDatabase.INSTANCE.readFromNBT(nbt1.func_150295_c("questLines", 10), false);
            if (!loadWorldSettings) {
                QuestDatabase.INSTANCE.readProgressFromNBT(jsonP, false);
                QuestSettings.INSTANCE.setProperty(NativeProps.EDIT_MODE, editMode);
                QuestSettings.INSTANCE.setProperty(NativeProps.HARDCORE, hardMode);
            }
            if (databaseName != null && !databaseName.equalsIgnoreCase(DEFAULT_FILE)) {
                QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.load2", databaseName + ".json");
            } else {
                QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.load", new Object[0]);
            }
            NetSettingSync.sendSync(null);
            NetQuestSync.quickSync(null, true, true);
            NetChapterSync.sendSync(null, null);
            SaveLoadHandler.INSTANCE.markDirty();
        } else {
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.none", new Object[0]);
        }
    }

    public static void set(@Nullable ICommandSender sender, String databaseName, File dataDir) {
        if (!dataDir.exists() || databaseName.equalsIgnoreCase(DEFAULT_FILE)) {
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.none", new Object[0]);
            return;
        }
        File defDir = new File(BQ_Settings.defaultDir, DEFAULT_FILE);
        if (defDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)defDir);
            }
            catch (IOException e) {
                QuestingAPI.getLogger().log(Level.ERROR, "Failed to delete directory\n" + defDir, (Throwable)e);
                QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.error", new Object[0]);
                return;
            }
        }
        try {
            FileUtils.copyDirectory((File)dataDir, (File)defDir);
        }
        catch (IOException e) {
            QuestingAPI.getLogger().log(Level.ERROR, "Failed to copy directory\n" + dataDir, (Throwable)e);
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.error", new Object[0]);
            return;
        }
        QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.set", databaseName);
    }

    public static void setLegacy(@Nullable ICommandSender sender, String databaseName, File legacyFile) {
        if (legacyFile.exists() && !databaseName.equalsIgnoreCase(DEFAULT_FILE)) {
            File defFile = new File(BQ_Settings.defaultDir, "DefaultQuests.json");
            if (defFile.exists()) {
                defFile.delete();
            }
            JsonHelper.CopyPaste(legacyFile, defFile);
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.set", databaseName);
        } else {
            QuestCommandDefaults.sendChatMessage(sender, "betterquesting.cmd.default.none", new Object[0]);
        }
    }

    private static List<IQuest> orderByRequirements(SortedMap<UUID, IQuest> quests) {
        final SortedSetMultimap predecessors = MultimapBuilder.hashKeys().treeSetValues(Map.Entry.comparingByKey()).build();
        final SortedSetMultimap successors = MultimapBuilder.hashKeys().treeSetValues(Map.Entry.comparingByKey()).build();
        quests.entrySet().forEach(entry -> {
            for (UUID requirementId : ((IQuest)entry.getValue()).getRequirements()) {
                IQuest requirement = (IQuest)quests.get(requirementId);
                if (requirement == null) continue;
                Map.Entry requirementEntry = Maps.immutableEntry((Object)requirementId, (Object)requirement);
                predecessors.put(entry, (Object)requirementEntry);
                successors.put((Object)requirementEntry, entry);
            }
        });
        final ArrayList<IQuest> orderedQuests = new ArrayList<IQuest>(quests.size());
        final HashSet addedQuests = new HashSet(quests.size());
        Consumer<Map.Entry<UUID, IQuest>> addQuest = new Consumer<Map.Entry<UUID, IQuest>>(){

            @Override
            public void accept(Map.Entry<UUID, IQuest> entry) {
                if (addedQuests.contains(entry)) {
                    return;
                }
                addedQuests.add(entry);
                for (Map.Entry predecessor : predecessors.get(entry)) {
                    this.accept(predecessor);
                }
                orderedQuests.add(entry.getValue());
                for (Map.Entry successor : successors.get(entry)) {
                    this.accept(successor);
                }
            }
        };
        quests.entrySet().forEach(addQuest);
        return orderedQuests;
    }
}

