/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.handlers;

import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.client.QuestNotification;
import betterquesting.client.gui2.GuiHome;
import betterquesting.commands.admin.QuestCommandDefaults;
import betterquesting.core.BetterQuesting;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestInstance;
import betterquesting.questing.QuestLineDatabase;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.LifeDatabase;
import betterquesting.storage.NameCache;
import betterquesting.storage.QuestSettings;
import com.google.gson.JsonObject;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import io.netty.util.internal.ConcurrentSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.io.FileUtils;

public class SaveLoadHandler {
    public static SaveLoadHandler INSTANCE = new SaveLoadHandler();
    private boolean hasUpdate = false;
    private boolean isDirty = false;
    private File fileDatabase = null;
    private File fileProgress = null;
    private File dirProgress = null;
    private File fileParties = null;
    private File fileLives = null;
    private File fileNames = null;
    private final Set<UUID> dirtyPlayers = new ConcurrentSet();

    public boolean hasUpdate() {
        return this.hasUpdate;
    }

    public void resetUpdate() {
        this.hasUpdate = false;
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public void addDirtyPlayers(UUID ... players) {
        this.dirtyPlayers.addAll(Arrays.asList(players));
    }

    public void addDirtyPlayers(Collection<UUID> players) {
        this.dirtyPlayers.addAll(players);
    }

    public void loadDatabases(MinecraftServer server) {
        this.hasUpdate = false;
        if (BetterQuesting.proxy.isClient()) {
            GuiHome.bookmark = null;
            QuestNotification.resetNotices();
        }
        if (BetterQuesting.proxy.isClient()) {
            BQ_Settings.curWorldDir = server.func_71209_f("saves/" + server.func_71270_I() + "/betterquesting");
            File rootDir = server.func_71209_f("saves/" + server.func_71270_I());
        } else {
            BQ_Settings.curWorldDir = server.func_71209_f(server.func_71270_I() + "/betterquesting");
            File rootDir = server.func_71209_f(server.func_71270_I());
        }
        this.fileDatabase = new File(BQ_Settings.curWorldDir, "QuestDatabase.json");
        this.fileProgress = new File(BQ_Settings.curWorldDir, "QuestProgress.json");
        this.dirProgress = new File(BQ_Settings.curWorldDir, "QuestProgress");
        this.fileParties = new File(BQ_Settings.curWorldDir, "QuestingParties.json");
        this.fileLives = new File(BQ_Settings.curWorldDir, "LifeDatabase.json");
        this.fileNames = new File(BQ_Settings.curWorldDir, "NameCache.json");
        this.loadConfig();
        this.loadProgress();
        this.LoadParties();
        this.loadNames();
        this.loadLives();
        BetterQuesting.logger.info("Loaded " + QuestDatabase.INSTANCE.size() + " quests");
        BetterQuesting.logger.info("Loaded " + QuestLineDatabase.INSTANCE.size() + " quest lines");
        BetterQuesting.logger.info("Loaded " + PartyManager.INSTANCE.size() + " parties");
        BetterQuesting.logger.info("Loaded " + NameCache.INSTANCE.size() + " names");
        MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Load(DatabaseEvent.DBType.ALL));
    }

    public void saveDatabases() {
        ArrayList<Future<Void>> allFutures = new ArrayList<Future<Void>>(5);
        if (!BQ_Settings.dirtyMode || this.isDirty || QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue()) {
            allFutures.add(this.saveConfig());
        }
        allFutures.addAll(this.saveProgress());
        allFutures.add(this.saveParties());
        allFutures.add(this.saveNames());
        allFutures.add(this.saveLives());
        MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Save(DatabaseEvent.DBType.ALL));
        for (Future future : allFutures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                BetterQuesting.logger.warn("Saving interrupted!", (Throwable)e);
            }
            catch (ExecutionException e) {
                BetterQuesting.logger.warn("Saving failed!", e.getCause());
            }
        }
        this.isDirty = false;
    }

    public void unloadDatabases() {
        BQ_Settings.curWorldDir = null;
        this.hasUpdate = false;
        this.isDirty = false;
        QuestSettings.INSTANCE.reset();
        QuestDatabase.INSTANCE.clear();
        QuestLineDatabase.INSTANCE.clear();
        LifeDatabase.INSTANCE.reset();
        NameCache.INSTANCE.reset();
        if (BetterQuesting.proxy.isClient()) {
            GuiHome.bookmark = null;
            QuestNotification.resetNotices();
        }
    }

    private void loadConfig() {
        QuestSettings.INSTANCE.reset();
        QuestDatabase.INSTANCE.clear();
        QuestLineDatabase.INSTANCE.clear();
        int packVer = 0;
        String packName = "";
        String currVer = Loader.instance().activeModContainer().getVersion();
        File defaultDatabaseFile = new File(BQ_Settings.defaultDir, "DefaultQuests.json");
        File defaultDatabaseDir = new File(BQ_Settings.defaultDir, "DefaultQuests");
        File defaultDatabaseSettingsFile = new File(defaultDatabaseDir, "QuestSettings.json");
        if (this.fileDatabase.exists()) {
            boolean legacySettings = !defaultDatabaseSettingsFile.exists();
            File settingsFile = legacySettings ? defaultDatabaseFile : defaultDatabaseSettingsFile;
            JsonObject settingsJson = JsonHelper.ReadFromFile(settingsFile);
            NBTTagCompound settingsTag = NBTConverter.JSONtoNBT_Object(settingsJson, new NBTTagCompound(), true);
            QuestSettings tmpSettings = new QuestSettings();
            tmpSettings.readFromNBT(legacySettings ? settingsTag.func_74775_l("questSettings") : settingsTag);
            packVer = tmpSettings.getProperty(NativeProps.PACK_VER);
            packName = tmpSettings.getProperty(NativeProps.PACK_NAME);
            JsonObject databaseJson = JsonHelper.ReadFromFile(this.fileDatabase);
            String buildVer = NBTConverter.JSONtoNBT_Object(settingsJson, new NBTTagCompound(), true).func_74779_i("build");
            if (!currVer.equalsIgnoreCase(buildVer)) {
                String fsVer = JsonHelper.makeFileNameSafe(buildVer);
                if (fsVer.isEmpty()) {
                    fsVer = "pre-251";
                }
                BetterQuesting.logger.warn("BetterQuesting has been updated to from \"" + fsVer + "\" to \"" + currVer + "\"! Creating backups...");
                JsonHelper.CopyPaste(this.fileDatabase, new File(BQ_Settings.curWorldDir + "/backup/" + fsVer, "QuestDatabase_backup_" + fsVer + ".json"));
                JsonHelper.CopyPaste(this.fileProgress, new File(BQ_Settings.curWorldDir + "/backup/" + fsVer, "QuestProgress_backup_" + fsVer + ".json"));
                JsonHelper.CopyPaste(this.fileParties, new File(BQ_Settings.curWorldDir + "/backup/" + fsVer, "QuestingParties_backup_" + fsVer + ".json"));
                JsonHelper.CopyPaste(this.fileNames, new File(BQ_Settings.curWorldDir + "/backup/" + fsVer, "NameCache_backup_" + fsVer + ".json"));
                JsonHelper.CopyPaste(this.fileLives, new File(BQ_Settings.curWorldDir + "/backup/" + fsVer, "LifeDatabase_backup_" + fsVer + ".json"));
            }
            QuestCommandDefaults.loadLegacy(null, null, this.fileDatabase, true);
        } else {
            if (defaultDatabaseDir.exists()) {
                QuestCommandDefaults.load(null, null, defaultDatabaseDir, true);
            } else {
                QuestCommandDefaults.loadLegacy(null, null, defaultDatabaseFile, true);
            }
            this.isDirty = true;
            QuestSettings.INSTANCE.setProperty(NativeProps.EDIT_MODE, false);
        }
        this.hasUpdate = packName.equals(QuestSettings.INSTANCE.getProperty(NativeProps.PACK_NAME)) && packVer > QuestSettings.INSTANCE.getProperty(NativeProps.PACK_VER);
    }

    private void loadProgress() {
        if (this.fileProgress.exists()) {
            JsonObject json = JsonHelper.ReadFromFile(this.fileProgress);
            NBTTagCompound nbt = NBTConverter.JSONtoNBT_Object(json, new NBTTagCompound(), true);
            QuestDatabase.INSTANCE.readProgressFromNBT(nbt.func_150295_c("questProgress", 10), false);
            this.markDirty();
            HashSet<UUID> usersFound = new HashSet<UUID>();
            for (IQuest quest : QuestDatabase.INSTANCE.values()) {
                if (!(quest instanceof QuestInstance)) continue;
                QuestInstance qi = (QuestInstance)quest;
                qi.getUsersWithCompletionData(usersFound);
            }
            this.dirtyPlayers.addAll(usersFound);
        }
        this.getPlayerProgressFiles().forEach(file -> {
            JsonObject json = JsonHelper.ReadFromFile(file);
            NBTTagCompound nbt = NBTConverter.JSONtoNBT_Object(json, new NBTTagCompound(), true);
            QuestDatabase.INSTANCE.readProgressFromNBT(nbt.func_150295_c("questProgress", 10), true);
        });
    }

    private void LoadParties() {
        JsonObject json = JsonHelper.ReadFromFile(this.fileParties);
        NBTTagCompound nbt = NBTConverter.JSONtoNBT_Object(json, new NBTTagCompound(), true);
        PartyManager.INSTANCE.readFromNBT(nbt.func_150295_c("parties", 10), false);
    }

    private void loadNames() {
        NameCache.INSTANCE.reset();
        JsonObject json = JsonHelper.ReadFromFile(this.fileNames);
        NBTTagCompound nbt = NBTConverter.JSONtoNBT_Object(json, new NBTTagCompound(), true);
        NameCache.INSTANCE.readFromNBT(nbt.func_150295_c("nameCache", 10), false);
    }

    private void loadLives() {
        LifeDatabase.INSTANCE.reset();
        JsonObject json = JsonHelper.ReadFromFile(this.fileLives);
        NBTTagCompound nbt = NBTConverter.JSONtoNBT_Object(json, new NBTTagCompound(), true);
        LifeDatabase.INSTANCE.readFromNBT(nbt.func_74775_l("lifeDatabase"), false);
    }

    private Future<Void> saveConfig() {
        NBTTagCompound json = new NBTTagCompound();
        json.func_74782_a("questSettings", (NBTBase)QuestSettings.INSTANCE.writeToNBT(new NBTTagCompound()));
        json.func_74782_a("questDatabase", (NBTBase)QuestDatabase.INSTANCE.writeToNBT(new NBTTagList(), (List<UUID>)null));
        json.func_74782_a("questLines", (NBTBase)QuestLineDatabase.INSTANCE.writeToNBT(new NBTTagList(), (List<UUID>)null));
        json.func_74778_a("format", "3.0.0");
        json.func_74778_a("build", Loader.instance().activeModContainer().getVersion());
        return JsonHelper.WriteToFile2(this.fileDatabase, out -> NBTConverter.NBTtoJSON_Compound(json, out, true));
    }

    private List<Future<Void>> saveProgress() {
        List<Future<Void>> futures = this.dirtyPlayers.stream().map(this::savePlayerProgress).collect(Collectors.toList());
        this.dirtyPlayers.clear();
        if (this.fileProgress != null && this.fileProgress.exists()) {
            String backupName = this.fileProgress.getName().replace(".json", ".backup.json");
            try {
                FileUtils.moveFile((File)this.fileProgress, (File)new File(this.fileProgress.getParentFile(), backupName));
                FileUtils.forceDelete((File)this.fileProgress);
            }
            catch (Exception e) {
                BetterQuesting.logger.warn("Could not move old progress data out of the way {}", new Object[]{backupName, e});
            }
        }
        return futures;
    }

    private Future<Void> saveParties() {
        NBTTagCompound json = new NBTTagCompound();
        json.func_74782_a("parties", (NBTBase)PartyManager.INSTANCE.writeToNBT(new NBTTagList(), (List<Integer>)null));
        return JsonHelper.WriteToFile2(this.fileParties, out -> NBTConverter.NBTtoJSON_Compound(json, out, true));
    }

    private Future<Void> saveNames() {
        NBTTagCompound json = new NBTTagCompound();
        json.func_74782_a("nameCache", (NBTBase)NameCache.INSTANCE.writeToNBT(new NBTTagList(), (List<UUID>)null));
        return JsonHelper.WriteToFile2(this.fileNames, out -> NBTConverter.NBTtoJSON_Compound(json, out, true));
    }

    private Future<Void> saveLives() {
        NBTTagCompound json = new NBTTagCompound();
        json.func_74782_a("lifeDatabase", (NBTBase)LifeDatabase.INSTANCE.writeToNBT(new NBTTagCompound(), (List<UUID>)null));
        return JsonHelper.WriteToFile2(this.fileLives, out -> NBTConverter.NBTtoJSON_Compound(json, out, true));
    }

    public Future<Void> savePlayerProgress(UUID player) {
        NBTTagCompound json = new NBTTagCompound();
        json.func_74782_a("questProgress", (NBTBase)QuestDatabase.INSTANCE.writeProgressToNBT(new NBTTagList(), Collections.singletonList(player)));
        return JsonHelper.WriteToFile2(new File(this.dirProgress, player.toString() + ".json"), out -> NBTConverter.NBTtoJSON_Compound(json, out, true));
    }

    private List<File> getPlayerProgressFiles() {
        File[] files = this.dirProgress.listFiles();
        if (files == null) {
            return new ArrayList<File>();
        }
        return Arrays.stream(files).filter(f -> f.getName().endsWith(".json")).collect(Collectors.toList());
    }
}

