/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.utils;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;

public class UuidConverter {
    public static UUID convertLegacyId(int legacyId) {
        Preconditions.checkArgument((legacyId >= 0 ? 1 : 0) != 0);
        return new UUID(0L, legacyId);
    }

    public static String encodeUuid(UUID uuid) {
        byte[] upper = Longs.toByteArray((long)uuid.getMostSignificantBits());
        byte[] lower = Longs.toByteArray((long)uuid.getLeastSignificantBits());
        return Base64.getUrlEncoder().encodeToString(Bytes.concat((byte[][])new byte[][]{upper, lower}));
    }

    public static UUID decodeUuid(String string) {
        byte[] bytes = Base64.getUrlDecoder().decode(string);
        byte[] upper = Arrays.copyOfRange(bytes, 0, 8);
        byte[] lower = Arrays.copyOfRange(bytes, 8, 16);
        return new UUID(Longs.fromByteArray((byte[])upper), Longs.fromByteArray((byte[])lower));
    }
}

