/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.rewards.loot;

import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.INBTSaveLoad;
import betterquesting.api2.storage.SimpleDatabase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class LootGroup
extends SimpleDatabase<LootEntry>
implements INBTSaveLoad<NBTTagCompound> {
    public String name = "Loot Group";
    public int weight = 1;

    public List<BigItemStack> getRandomReward(Random rand) {
        int total = this.getTotalWeight();
        float r = rand.nextFloat() * (float)total;
        int cnt = 0;
        for (DBEntry entry : this.getEntries()) {
            if (!((float)(cnt += ((LootEntry)entry.getValue()).weight) >= r)) continue;
            return ((LootEntry)entry.getValue()).items;
        }
        return Collections.emptyList();
    }

    public int getTotalWeight() {
        int i = 0;
        for (DBEntry entry : this.getEntries()) {
            i += ((LootEntry)entry.getValue()).weight;
        }
        return i;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.reset();
        this.name = tag.func_74779_i("name");
        this.weight = Math.max(tag.func_74762_e("weight"), 1);
        ArrayList<LootEntry> legacyEntry = new ArrayList<LootEntry>();
        NBTTagList jRew = tag.func_150295_c("rewards", 10);
        for (int i = 0; i < jRew.func_74745_c(); ++i) {
            NBTTagCompound nBTTagCompound = jRew.func_150305_b(i);
            int id = nBTTagCompound.func_150297_b("ID", 99) ? nBTTagCompound.func_74762_e("ID") : -1;
            LootEntry loot = new LootEntry();
            loot.readFromNBT(nBTTagCompound);
            if (id >= 0) {
                this.add(id, loot);
                continue;
            }
            legacyEntry.add(loot);
        }
        for (LootEntry lootEntry : legacyEntry) {
            this.add(this.nextID(), lootEntry);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("name", this.name);
        tag.func_74768_a("weight", this.weight);
        NBTTagList jRew = new NBTTagList();
        for (DBEntry entry : this.getEntries()) {
            if (entry == null) continue;
            NBTTagCompound jLoot = ((LootEntry)entry.getValue()).writeToNBT(new NBTTagCompound());
            jLoot.func_74768_a("ID", entry.getID());
            jRew.func_74742_a((NBTBase)jLoot);
        }
        tag.func_74782_a("rewards", (NBTBase)jRew);
        return tag;
    }

    public static class LootEntry
    implements INBTSaveLoad<NBTTagCompound> {
        public int weight = 1;
        public final List<BigItemStack> items = new ArrayList<BigItemStack>();

        @Override
        public void readFromNBT(NBTTagCompound json) {
            this.weight = json.func_74762_e("weight");
            this.weight = Math.max(1, this.weight);
            this.items.clear();
            NBTTagList jItm = json.func_150295_c("items", 10);
            for (int i = 0; i < jItm.func_74745_c(); ++i) {
                this.items.add(JsonHelper.JsonToItemStack(jItm.func_150305_b(i)));
            }
        }

        @Override
        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("weight", this.weight);
            NBTTagList jItm = new NBTTagList();
            for (BigItemStack stack : this.items) {
                jItm.func_74742_a((NBTBase)JsonHelper.ItemStackToJson(stack, new NBTTagCompound()));
            }
            tag.func_74782_a("items", (NBTBase)jItm);
            return tag;
        }
    }
}

