/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api2.utils.Tuple2;
import betterquesting.core.BetterQuesting;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeRegistry;
import betterquesting.storage.QuestSettings;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class NetSettingSync {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting:setting_sync");

    public static void registerHandler() {
        PacketTypeRegistry.INSTANCE.registerServerHandler(ID_NAME, NetSettingSync::onServer);
        if (BetterQuesting.proxy.isClient()) {
            PacketTypeRegistry.INSTANCE.registerClientHandler(ID_NAME, NetSettingSync::onClient);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void requestEdit() {
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74782_a("data", (NBTBase)QuestSettings.INSTANCE.writeToNBT(new NBTTagCompound()));
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    public static void sendSync(@Nullable EntityPlayerMP player) {
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74782_a("data", (NBTBase)QuestSettings.INSTANCE.writeToNBT(new NBTTagCompound()));
        if (player != null) {
            PacketSender.INSTANCE.sendToPlayers(new QuestingPacket(ID_NAME, payload), player);
        } else {
            PacketSender.INSTANCE.sendToAll(new QuestingPacket(ID_NAME, payload));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void onClient(NBTTagCompound message) {
        QuestSettings.INSTANCE.readFromNBT(message.func_74775_l("data"));
    }

    private static void onServer(Tuple2<NBTTagCompound, EntityPlayerMP> message) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (!server.func_71203_ab().func_152596_g(message.func_76340_b().func_146103_bH())) {
            BetterQuesting.logger.log(Level.WARN, "Player " + message.func_76340_b().func_70005_c_() + " (UUID:" + QuestingAPI.getQuestingUUID((EntityPlayer)message.func_76340_b()) + ") tried to edit settings without OP permissions!");
            NetSettingSync.sendSync(message.func_76340_b());
            return;
        }
        QuestSettings.INSTANCE.readFromNBT(message.func_76341_a().func_74775_l("data"));
        SaveLoadHandler.INSTANCE.markDirty();
        NetSettingSync.sendSync(null);
    }
}

