/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.controls;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumQuestState;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.textures.GuiTextureColored;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.resources.textures.OreDictTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.BookmarkHandler;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestInstance;
import betterquesting.storage.QuestSettings;
import com.google.common.collect.Maps;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class PanelButtonQuest
extends PanelButtonStorage<Map.Entry<UUID, IQuest>> {
    private static final IGuiTexture PIN_TEX = PresetIcon.ICON_BOOKMARK.getTexture();
    public final GuiRectangle rect;
    public final EntityPlayer player;
    public final IGuiTexture txFrame;
    private boolean isBookmarked = false;

    public PanelButtonQuest(GuiRectangle rect, int id, String txt, @Nullable Map.Entry<UUID, IQuest> value) {
        super(rect, id, txt, value);
        this.rect = rect;
        this.player = Minecraft.func_71410_x().field_71439_g;
        if (value == null) {
            value = Maps.immutableEntry((Object)UUID.randomUUID(), (Object)new QuestInstance());
        } else if (value.getValue() == null) {
            value.setValue(new QuestInstance());
        }
        EnumQuestState qState = value.getValue().getState(this.player);
        IGuiColor txIconCol = null;
        boolean main = ((IQuest)value.getValue()).getProperty(NativeProps.MAIN);
        boolean lock = false;
        switch (qState) {
            case LOCKED: {
                this.txFrame = main ? PresetTexture.QUEST_MAIN_0.getTexture() : PresetTexture.QUEST_NORM_0.getTexture();
                txIconCol = PresetColor.QUEST_ICON_LOCKED.getColor();
                lock = true;
                break;
            }
            case UNLOCKED: {
                this.txFrame = main ? PresetTexture.QUEST_MAIN_1.getTexture() : PresetTexture.QUEST_NORM_1.getTexture();
                txIconCol = PresetColor.QUEST_ICON_UNLOCKED.getColor();
                break;
            }
            case UNCLAIMED: {
                this.txFrame = main ? PresetTexture.QUEST_MAIN_2.getTexture() : PresetTexture.QUEST_NORM_2.getTexture();
                txIconCol = PresetColor.QUEST_ICON_PENDING.getColor();
                break;
            }
            case COMPLETED: {
                this.txFrame = main ? PresetTexture.QUEST_MAIN_3.getTexture() : PresetTexture.QUEST_NORM_3.getTexture();
                txIconCol = PresetColor.QUEST_ICON_COMPLETE.getColor();
                break;
            }
            case REPEATABLE: {
                this.txFrame = main ? PresetTexture.QUEST_MAIN_4.getTexture() : PresetTexture.QUEST_NORM_4.getTexture();
                txIconCol = PresetColor.QUEST_ICON_REPEATABLE.getColor();
                break;
            }
            default: {
                this.txFrame = null;
            }
        }
        GuiTextureColored btnTx = new GuiTextureColored(this.txFrame, txIconCol);
        this.setTextures(btnTx, btnTx, btnTx);
        this.setIcon(new OreDictTexture(1.0f, ((IQuest)value.getValue()).getProperty(NativeProps.ICON), false, true), 4);
        this.setActive(QuestingAPI.getAPI(ApiReference.SETTINGS).canUserEdit(this.player) || !lock || BQ_Settings.viewMode);
        this.setBookmarked(BookmarkHandler.isBookmarked((UUID)value.getKey()));
    }

    @Override
    public void drawPanel(int mx, int my, float partialTick) {
        super.drawPanel(mx, my, partialTick);
        if (this.isBookmarked) {
            IGuiRect bounds = this.getTransform();
            PIN_TEX.drawTexture(bounds.getX(), bounds.getY(), bounds.getWidth() / 4, bounds.getHeight() / 4, 1.0f, partialTick);
        }
    }

    public void setBookmarked(boolean state) {
        this.isBookmarked = state;
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        if (!this.getTransform().contains(mx, my)) {
            return null;
        }
        Map.Entry value = (Map.Entry)this.getStoredValue();
        return value == null ? Collections.emptyList() : this.getQuestTooltip((IQuest)value.getValue(), this.player, (UUID)value.getKey());
    }

    private List<String> getQuestTooltip(IQuest quest, EntityPlayer player, UUID qID) {
        List<String> tooltip = this.getStandardTooltip(quest, player, qID);
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x && QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue()) {
            tooltip.add("");
            tooltip.addAll(this.getAdvancedTooltip(quest, player, qID));
        }
        return tooltip;
    }

    private List<String> getStandardTooltip(IQuest quest, EntityPlayer player, UUID qID) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(QuestTranslation.translateQuestName(qID, quest));
        UUID playerID = QuestingAPI.getQuestingUUID(player);
        if (quest.isComplete(playerID)) {
            list.add(EnumChatFormatting.GREEN + QuestTranslation.translate("betterquesting.tooltip.complete", new Object[0]));
            if (quest.canClaimBasically(player)) {
                list.add(EnumChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.rewards_pending", new Object[0]));
            } else if (!quest.hasClaimed(playerID)) {
                list.add(EnumChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.repeatable", new Object[0]));
            } else if (quest.getProperty(NativeProps.REPEAT_TIME) > 0) {
                long time = this.getRepeatSeconds(quest, player);
                DecimalFormat df = new DecimalFormat("00");
                String timeTxt = "";
                if (time < 0L) {
                    timeTxt = timeTxt + "-";
                    time *= -1L;
                }
                if (time >= 3600L) {
                    timeTxt = timeTxt + time / 3600L + "h " + df.format(time % 3600L / 60L) + "m ";
                } else if (time >= 60L) {
                    timeTxt = timeTxt + time / 60L + "m ";
                }
                timeTxt = timeTxt + df.format(time % 60L) + "s";
                list.add(EnumChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.repeat", timeTxt));
                if (QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue()) {
                    list.add(EnumChatFormatting.RED + QuestTranslation.translate("betterquesting.tooltip.repeat_with_edit_mode", new Object[0]));
                }
            }
        } else if (!quest.isUnlocked(playerID)) {
            list.add(EnumChatFormatting.RED + "" + EnumChatFormatting.UNDERLINE + QuestTranslation.translate("betterquesting.tooltip.requires", new Object[0]) + " (" + quest.getProperty(NativeProps.LOGIC_QUEST).toString().toUpperCase() + ")");
            QuestDatabase.INSTANCE.filterKeys(quest.getRequirements()).entrySet().stream().filter(entry -> !((IQuest)entry.getValue()).isComplete(playerID)).forEach(entry -> list.add(EnumChatFormatting.RED + "- " + QuestTranslation.translateQuestName(entry)));
        } else {
            int n = 0;
            for (DBEntry task : quest.getTasks().getEntries()) {
                if (!((ITask)task.getValue()).isComplete(playerID)) continue;
                ++n;
            }
            list.add(EnumChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.tasks_complete", n, quest.getTasks().size()));
        }
        return list;
    }

    private List<String> getAdvancedTooltip(IQuest quest, EntityPlayer player, UUID qID) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(EnumChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.global_quest", quest.getProperty(NativeProps.GLOBAL)));
        if (quest.getProperty(NativeProps.GLOBAL).booleanValue()) {
            list.add(EnumChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.global_share", quest.getProperty(NativeProps.GLOBAL_SHARE)));
        }
        list.add(EnumChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.quest_logic", quest.getProperty(NativeProps.LOGIC_QUEST).toString().toUpperCase()));
        list.add(EnumChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.simultaneous", quest.getProperty(NativeProps.SIMULTANEOUS)));
        list.add(EnumChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.auto_claim", quest.getProperty(NativeProps.AUTO_CLAIM)));
        if (quest.getProperty(NativeProps.REPEAT_TIME) >= 0) {
            long time = quest.getProperty(NativeProps.REPEAT_TIME) / 20;
            DecimalFormat df = new DecimalFormat("00");
            String timeTxt = "";
            if (time >= 3600L) {
                timeTxt = timeTxt + time / 3600L + "h " + df.format(time % 3600L / 60L) + "m ";
            } else if (time >= 60L) {
                timeTxt = timeTxt + time / 60L + "m ";
            }
            timeTxt = timeTxt + df.format(time % 60L) + "s";
            list.add(EnumChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.repeat", timeTxt));
        } else {
            list.add(EnumChatFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.repeat", false));
        }
        return list;
    }

    private long getRepeatSeconds(IQuest quest, EntityPlayer player) {
        if (quest.getProperty(NativeProps.REPEAT_TIME) < 0) {
            return -1L;
        }
        NBTTagCompound ue = quest.getCompletionInfo(QuestingAPI.getQuestingUUID(player));
        if (ue == null) {
            return 0L;
        }
        return ((long)quest.getProperty(NativeProps.REPEAT_TIME).intValue() * 50L - (System.currentTimeMillis() - ue.func_74763_f("timestamp"))) / 1000L;
    }
}

