/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels.content;

import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.lines.IGuiLine;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class PanelLine
implements IGuiPanel {
    private final IGuiRect bounds;
    private final ShouldDrawPredicate shouldDraw;
    private final IGuiLine line;
    private final IGuiRect start;
    private final IGuiRect end;
    private final IGuiColor color;
    private final int width;
    private boolean enabled = true;

    public PanelLine(IGuiRect start, IGuiRect end, IGuiLine line, int width, IGuiColor color, int drawOrder) {
        this(start, end, line, width, color, drawOrder, null);
    }

    public PanelLine(IGuiRect start, IGuiRect end, IGuiLine line, int width, IGuiColor color, int drawOrder, ShouldDrawPredicate shouldDraw) {
        this.start = start;
        this.end = end;
        this.line = line;
        this.width = width;
        this.color = color;
        this.bounds = new GuiRectangle(0, 0, 0, 0, drawOrder);
        this.shouldDraw = shouldDraw;
        this.bounds.setParent(start);
    }

    @Override
    public IGuiRect getTransform() {
        return this.bounds;
    }

    @Override
    public void initPanel() {
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void drawPanel(int mx, int my, float partialTick) {
        if (this.shouldDraw == null || this.shouldDraw.shouldDraw(mx, my, partialTick)) {
            GL11.glPushMatrix();
            this.line.drawLine(this.start, this.end, this.width, this.color, partialTick);
            GL11.glPopMatrix();
        }
    }

    @Override
    public boolean onMouseClick(int mx, int my, int button) {
        return false;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int button) {
        return false;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        return false;
    }

    @Override
    public boolean onKeyTyped(char c, int keycode) {
        return false;
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        return null;
    }

    public static interface ShouldDrawPredicate {
        public boolean shouldDraw(int var1, int var2, float var3);
    }
}

