/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client;

import betterquesting.api.properties.NativeProps;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.utils.QuestTranslation;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class QuestNotification {
    private static final List<QuestNotice> notices = new ArrayList<QuestNotice>();

    public static void ScheduleNotice(String mainTxt, String subTxt, ItemStack icon, String sound) {
        if (BQ_Settings.questNotices) {
            notices.add(new QuestNotice(mainTxt, subTxt, icon, sound));
        }
    }

    public static void resetNotices() {
        notices.clear();
    }

    @SubscribeEvent
    public void onDrawScreen(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.HELMET || notices.isEmpty()) {
            return;
        }
        if (notices.size() >= 20 || !BQ_Settings.questNotices) {
            notices.clear();
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        int width = event.resolution.func_78326_a();
        int height = event.resolution.func_78328_b();
        QuestNotice notice = notices.get(0);
        if (!notice.init) {
            if (mc.func_147113_T() || mc.field_71462_r != null) {
                return;
            }
            notice.init = true;
            notice.startTime = Minecraft.func_71386_F();
            float volume = notice.sound.equals(NativeProps.SOUND_COMPLETE.getDefault()) ? 0.25f : 1.0f;
            mc.func_147118_V().func_147682_a((ISound)new QuestCompleteSound(new ResourceLocation(notice.sound), volume));
        }
        if (notice.getTime() >= 6.0f) {
            notices.remove(0);
            return;
        }
        float alpha = notice.getTime() <= 4.0f ? Math.min(1.0f, notice.getTime()) : Math.max(0.0f, 5.0f - notice.getTime());
        alpha = MathHelper.func_76131_a((float)alpha, (float)0.02f, (float)1.0f);
        int color = new Color(1.0f, 1.0f, 1.0f, alpha).getRGB();
        if (alpha < 0.2f) {
            return;
        }
        GL11.glPushMatrix();
        float scale = width > 600 ? 1.5f : 1.0f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        width = MathHelper.func_76123_f((float)((float)width / scale));
        height = MathHelper.func_76123_f((float)((float)height / scale));
        if (notice.icon != null) {
            RenderUtils.RenderItemStack(mc, notice.icon, width / 2 - 8, height / 4 - 20, "", color);
            GL11.glEnable((int)2929);
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        String tmp = EnumChatFormatting.UNDERLINE + "" + EnumChatFormatting.BOLD + QuestTranslation.translate(notice.mainTxt, new Object[0]);
        int txtW = RenderUtils.getStringWidth(tmp, mc.field_71466_p);
        mc.field_71466_p.func_85187_a(tmp, width / 2 - txtW / 2, height / 4, color, true);
        tmp = QuestTranslation.translate(notice.subTxt, new Object[0]);
        txtW = RenderUtils.getStringWidth(tmp, mc.field_71466_p);
        mc.field_71466_p.func_85187_a(tmp, width / 2 - txtW / 2, height / 4 + 12, color, true);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static class QuestNotice {
        public long startTime = Minecraft.func_71386_F();
        public boolean init = false;
        private final String mainTxt;
        private final String subTxt;
        private final ItemStack icon;
        private final String sound;

        public QuestNotice(String mainTxt, String subTxt, ItemStack icon, String sound) {
            this.mainTxt = mainTxt;
            this.subTxt = subTxt;
            this.icon = icon;
            this.sound = sound;
        }

        public float getTime() {
            return (float)(Minecraft.func_71386_F() - this.startTime) / 1000.0f;
        }
    }

    public static class QuestCompleteSound
    extends PositionedSound {
        public QuestCompleteSound(ResourceLocation resource, float volume) {
            super(resource);
            this.field_147662_b = volume;
            this.field_147663_c = 1.0f;
            this.field_147660_d = 0.0f;
            this.field_147661_e = 0.0f;
            this.field_147658_f = 0.0f;
            this.field_147659_g = false;
            this.field_147665_h = 0;
            this.field_147666_i = ISound.AttenuationType.NONE;
        }
    }
}

