/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.eventhandler.misc;

import biomesoplenty.api.content.BOPCFluids;
import biomesoplenty.api.content.BOPCItems;
import biomesoplenty.common.fluids.blocks.BlockBloodFluid;
import biomesoplenty.common.fluids.blocks.BlockHoneyFluid;
import biomesoplenty.common.fluids.blocks.BlockPoisonFluid;
import biomesoplenty.common.items.ItemBOPBucket;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class BucketEventHandler {
    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        TileEntity tile;
        ItemBOPBucket bopBucket = (ItemBOPBucket)BOPCItems.bopBucket;
        ItemStack bopBucketStack = new ItemStack((Item)bopBucket);
        World world = event.world;
        int x = event.target.field_72311_b;
        int y = event.target.field_72312_c;
        int z = event.target.field_72309_d;
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)world.func_147439_a(x, y, z));
        if (fluid == null && (tile = event.world.func_147438_o(x, y, z)) != null && tile instanceof IFluidHandler) {
            IFluidHandler tank = (IFluidHandler)tile;
            FluidStack fluidStack = tank.drain(ForgeDirection.UNKNOWN, 1000, false);
            if (fluidStack == null) {
                return;
            }
            if (fluidStack.amount < 1000) {
                return;
            }
            if (fluidStack.getFluid() == BOPCFluids.blood || fluidStack.getFluid() == BOPCFluids.honey || fluidStack.getFluid() == BOPCFluids.poison) {
                tank.drain(ForgeDirection.UNKNOWN, 1000, true);
                ItemStack filled = new ItemStack(BOPCItems.bopBucket);
                bopBucket.fill(filled, fluidStack, true);
                event.result = filled;
                event.setResult(Event.Result.ALLOW);
                return;
            }
        }
        if (fluid != null && (fluid == BOPCFluids.poison && world.func_72805_g(x, y, z) == 0 || fluid == BOPCFluids.blood && world.func_72805_g(x, y, z) == 0 || fluid == BOPCFluids.honey && world.func_72805_g(x, y, z) == 7)) {
            bopBucket.fill(bopBucketStack, new FluidStack(fluid, 1000), true);
            world.func_147468_f(x, y, z);
            event.result = bopBucketStack;
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Post event) {
        if (event.map.func_130086_a() == 0) {
            BOPCFluids.blood.setIcons(BlockBloodFluid.bloodStillIcon, BlockBloodFluid.bloodFlowingIcon);
            BOPCFluids.honey.setIcons(BlockHoneyFluid.honeyStillIcon, BlockHoneyFluid.honeyFlowingIcon);
            BOPCFluids.poison.setIcons(BlockPoisonFluid.liquidPoisonStillIcon, BlockPoisonFluid.liquidPoisonFlowingIcon);
        }
    }
}

