/*
 * Decompiled with CFR 0.152.
 */
package com.arc.bloodarsenal.common.items.armor;

import com.arc.bloodarsenal.client.renderer.model.ModelVampireCostume;
import com.arc.bloodarsenal.common.BloodArsenal;
import com.arc.bloodarsenal.common.items.ModItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class VampireCostume
extends ItemArmor {
    @SideOnly(value=Side.CLIENT)
    private IIcon chestIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon leggingsIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon bootsIcon;
    private boolean tryComplexRendering = true;
    ModelBiped model1 = null;
    ModelBiped model2 = null;
    ModelBiped model = null;

    public VampireCostume(int armorType) {
        super(BloodArsenal.vampireArmor, 0, armorType);
        this.func_77656_e(0);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (this.tryComplexRendering) {
            int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
            if (this.model1 == null) {
                this.model1 = new ModelVampireCostume(1.0f, false, true, false, true);
            }
            if (this.model2 == null) {
                this.model2 = new ModelVampireCostume(0.5f, false, false, true, false);
            }
            this.model = type == 1 || type == 3 ? this.model1 : this.model2;
            if (this.model != null) {
                this.model.field_78116_c.field_78806_j = type == 1;
                this.model.field_78114_d.field_78806_j = type == 1;
                this.model.field_78115_e.field_78806_j = type == 1;
                this.model.field_78124_i.field_78806_j = type == 2 || type == 3;
                this.model.field_78123_h.field_78806_j = type == 2 || type == 3;
                this.model.field_78117_n = entityLiving.func_70093_af();
                this.model.field_78093_q = entityLiving.func_70115_ae();
                this.model.field_78091_s = entityLiving.func_70631_g_();
                this.model.field_78118_o = false;
                int n = this.model.field_78120_m = entityLiving.func_70694_bm() != null ? 1 : 0;
                if (entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                    EnumAction enumaction = ((EntityPlayer)entityLiving).func_71011_bu().func_77975_n();
                    if (enumaction == EnumAction.block) {
                        this.model.field_78120_m = 3;
                    } else if (enumaction == EnumAction.bow) {
                        this.model.field_78118_o = true;
                    }
                }
            }
            return this.model;
        }
        return super.getArmorModel(entityLiving, itemStack, armorSlot);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:SheathedItem");
        this.chestIcon = iconRegister.func_94245_a("BloodArsenal:vampire_cape");
        this.leggingsIcon = iconRegister.func_94245_a("BloodArsenal:vampire_greaves");
        this.bootsIcon = iconRegister.func_94245_a("BloodArsenal:vampire_boots");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        if (((Object)((Object)this)).equals(ModItems.vampire_cape)) {
            return this.chestIcon;
        }
        if (((Object)((Object)this)).equals(ModItems.vampire_greaves)) {
            return this.leggingsIcon;
        }
        if (((Object)((Object)this)).equals(ModItems.vampire_boots)) {
            return this.bootsIcon;
        }
        return this.field_77791_bV;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (this.tryComplexRendering) {
            return "BloodArsenal:models/armor/VampireCostume.png";
        }
        if (entity instanceof EntityLivingBase && this.getIsInvisible(stack)) {
            if (this == ModItems.vampire_cape || this == ModItems.vampire_boots) {
                return "BloodArsenal:models/armor/VampireCostume_invisible.png";
            }
            if (this == ModItems.vampire_greaves) {
                return "BloodArsenal:models/armor/VampireCostume_invisible2.png";
            }
        }
        if (this == ModItems.vampire_cape || this == ModItems.vampire_boots) {
            return "AlchemicalWizardry:models/armor/boundArmour_layer_1.png";
        }
        if (this == ModItems.vampire_greaves) {
            return "AlchemicalWizardry:models/armor/boundArmour_layer_2.png";
        }
        return null;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        return super.func_77659_a(par1ItemStack, par2World, par3EntityPlayer);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack armor) {
        if (this.hasArmorSetItem(player, 1) && this.hasArmorSetItem(player, 2) && this.hasArmorSetItem(player, 3)) {
            if (player.func_70660_b(Potion.field_76420_g) != null) {
                player.func_82170_o(Potion.field_76420_g.field_76415_H);
            }
            player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 2, 1));
        }
        this.setIsInvisible(armor, player.func_82165_m(Potion.field_76441_p.field_76415_H));
    }

    public boolean hasArmorSetItem(EntityPlayer player, int i) {
        ItemStack stack = player.field_71071_by.field_70460_b[3 - i];
        if (stack == null) {
            return false;
        }
        switch (i) {
            case 1: {
                return stack.func_77973_b() == ModItems.vampire_cape;
            }
            case 2: {
                return stack.func_77973_b() == ModItems.vampire_greaves;
            }
            case 3: {
                return stack.func_77973_b() == ModItems.vampire_boots;
            }
        }
        return false;
    }

    public boolean getIsInvisible(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag != null) {
            return tag.func_74767_n("invisible");
        }
        return false;
    }

    public void setIsInvisible(ItemStack itemStack, boolean invisible) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            itemStack.func_77982_d(new NBTTagCompound());
            tag = itemStack.func_77978_p();
        }
        tag.func_74757_a("invisible", invisible);
    }
}

