/*
 * Decompiled with CFR 0.152.
 */
package com.arc.bloodarsenal.common.rituals;

import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.LifeEssenceNetwork;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.FishingHooks;
import net.minecraftforge.common.util.ForgeDirection;

public class RitualEffectFishing
extends RitualEffect {
    public void performEffect(IMasterRitualStone ritualStone) {
        int z;
        int y;
        WorldServer worldSave = MinecraftServer.func_71276_C().field_71305_c[0];
        String owner = ritualStone.getOwner();
        LifeEssenceNetwork data = (LifeEssenceNetwork)worldSave.func_72943_a(LifeEssenceNetwork.class, owner);
        if (data == null) {
            data = new LifeEssenceNetwork(owner);
            worldSave.func_72823_a(owner, (WorldSavedData)data);
        }
        int currentEssence = data.currentEssence;
        World world = ritualStone.getWorld();
        int terraeDrain = 20;
        int orbisTerraeDrain = 20;
        int potentiaDrain = 20;
        if (world.func_72820_D() % 10L != 5L) {
            return;
        }
        int x = ritualStone.getXCoord();
        TileEntity tile = world.func_147438_o(x, (y = ritualStone.getYCoord()) + 1, z = ritualStone.getZCoord());
        if (!(tile instanceof IInventory)) {
            return;
        }
        IInventory tileEntity = (IInventory)tile;
        if (tileEntity.func_70302_i_() <= 0) {
            return;
        }
        boolean hasRoom = false;
        for (int i = 0; i < tileEntity.func_70302_i_(); ++i) {
            if (tileEntity.func_70301_a(i) != null) continue;
            hasRoom = true;
            break;
        }
        if (!hasRoom) {
            return;
        }
        if (currentEssence < this.getCostPerRefresh()) {
            SoulNetworkHandler.causeNauseaToPlayer((String)owner);
        } else {
            int i;
            boolean hasTerrae = this.canDrainReagent(ritualStone, ReagentRegistry.terraeReagent, 20, true);
            boolean hasOrbisTerrae = this.canDrainReagent(ritualStone, ReagentRegistry.orbisTerraeReagent, 20, true);
            boolean hasPotentia = this.canDrainReagent(ritualStone, ReagentRegistry.potentiaReagent, 20, true);
            int j = i = hasTerrae ? -5 : -1;
            while (hasTerrae ? i <= 5 : i <= 1) {
                while (j <= 1) {
                    for (int k = 1; k <= 5; ++k) {
                        ItemStack fishStack;
                        float chance;
                        Block block = world.func_147439_a(x + i, y - k, z + j);
                        Random rand = new Random();
                        float f = chance = hasOrbisTerrae ? 0.8f : (float)rand.nextInt(2);
                        if (!block.func_149667_c(Blocks.field_150355_j) && !block.func_149667_c((Block)Blocks.field_150358_i) || rand.nextInt(9) < (hasPotentia ? 6 : 8) || (fishStack = FishingHooks.getRandomFishable((Random)rand, (float)chance, (int)(hasOrbisTerrae ? rand.nextInt(90) : -1), (int)(hasPotentia ? 2 : -1))) == null) continue;
                        SpellHelper.insertStackIntoInventory((ItemStack)fishStack, (IInventory)tileEntity, (ForgeDirection)ForgeDirection.DOWN);
                        SoulNetworkHandler.syphonFromNetwork((String)owner, (int)500);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public int getCostPerRefresh() {
        return 1000;
    }

    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> fishingRitual = new ArrayList<RitualComponent>();
        fishingRitual.add(new RitualComponent(1, 0, 0, 1));
        fishingRitual.add(new RitualComponent(-1, 0, 0, 1));
        fishingRitual.add(new RitualComponent(0, 0, 1, 1));
        fishingRitual.add(new RitualComponent(0, 0, -1, 1));
        fishingRitual.add(new RitualComponent(-1, 0, 1, 3));
        fishingRitual.add(new RitualComponent(1, 0, 1, 3));
        fishingRitual.add(new RitualComponent(-1, 0, -1, 3));
        fishingRitual.add(new RitualComponent(1, 0, -1, 3));
        fishingRitual.add(new RitualComponent(1, 1, 0, 4));
        fishingRitual.add(new RitualComponent(-1, 1, 0, 4));
        fishingRitual.add(new RitualComponent(0, 1, 1, 4));
        fishingRitual.add(new RitualComponent(0, 1, -1, 4));
        fishingRitual.add(new RitualComponent(2, 0, 2, 1));
        fishingRitual.add(new RitualComponent(2, 0, -2, 1));
        fishingRitual.add(new RitualComponent(-2, 0, 2, 1));
        fishingRitual.add(new RitualComponent(-2, 0, -2, 1));
        fishingRitual.add(new RitualComponent(2, 0, 0, 0));
        fishingRitual.add(new RitualComponent(-2, 0, 0, 0));
        fishingRitual.add(new RitualComponent(0, 0, 2, 0));
        fishingRitual.add(new RitualComponent(0, 0, -2, 0));
        return fishingRitual;
    }
}

