/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.harvest;

import WayofTime.alchemicalWizardry.api.harvest.IHarvestHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class AgriCraftCropHarvestHandler
implements IHarvestHandler {
    public Block harvestBlock = AgriCraftCropHarvestHandler.getBlockForString("AgriCraft:crops");
    public Method isMature;
    public Method harvest;

    public AgriCraftCropHarvestHandler() {
        if (this.harvestBlock != null) {
            try {
                Class<?> clazz = Class.forName("com.InfinityRaider.AgriCraft.blocks.BlockCrop");
                if (clazz != null) {
                    this.isMature = clazz.getMethod("isMature", World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    this.harvest = clazz.getMethod("harvest", World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isHarvesterValid() {
        return this.harvestBlock != null && this.isMature != null && this.harvest != null;
    }

    public static Block getBlockForString(String str) {
        String[] parts = str.split(":");
        String modId = parts[0];
        String name = parts[1];
        return GameRegistry.findBlock((String)modId, (String)name);
    }

    public boolean canHandleBlock(Block block) {
        return block == this.harvestBlock;
    }

    @Override
    public boolean harvestAndPlant(World world, int xCoord, int yCoord, int zCoord, Block block, int meta) {
        if (!this.canHandleBlock(block)) {
            return false;
        }
        try {
            return (Boolean)this.isMature.invoke((Object)block, world, xCoord, yCoord, zCoord) != false && (Boolean)this.harvest.invoke((Object)block, world, xCoord, yCoord, zCoord) != false;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return false;
    }
}

