/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.common.omega.OmegaParadigm;
import WayofTime.alchemicalWizardry.common.omega.OmegaRegistry;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TEMimicBlock
extends TileEntity {
    private ItemStack[] inv = new ItemStack[1];
    public Reagent reagent;
    private int ticksRemaining = 0;

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -999, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList tagList = par1NBTTagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.ticksRemaining = par1NBTTagCompound.func_74762_e("ticksRemaining");
        this.reagent = ReagentRegistry.getReagentForKey(par1NBTTagCompound.func_74779_i("reagent"));
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            this.inv[i].func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        par1NBTTagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        par1NBTTagCompound.func_74768_a("ticksRemaining", this.ticksRemaining);
        par1NBTTagCompound.func_74778_a("reagent", ReagentRegistry.getKeyForReagent(this.reagent));
    }

    public void func_145845_h() {
        super.func_145845_h();
        --this.ticksRemaining;
        if (this.ticksRemaining <= 0) {
            this.returnContainedBlock();
        }
    }

    public static boolean createMimicBlockAtLocation(World world, int x, int y, int z, int duration, Block block, int meta, Reagent reagent) {
        if (block == null) {
            return false;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity == null && world.func_147437_c(x, y, z)) {
            ItemStack item = new ItemStack(block, 1, meta);
            world.func_147449_b(x, y, z, ModBlocks.blockMimic);
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof TEMimicBlock) {
                ((TEMimicBlock)tile).setContainedItem(item);
                ((TEMimicBlock)tile).setDuration(duration);
                ((TEMimicBlock)tile).reagent = reagent;
                world.func_147471_g(x, y, z);
                return true;
            }
        } else if (tileEntity instanceof TEMimicBlock && ((TEMimicBlock)tileEntity).getBlock() == block && ((TEMimicBlock)tileEntity).getMetaOfMimic() == meta) {
            ((TEMimicBlock)tileEntity).ticksRemaining = Math.max(duration, ((TEMimicBlock)tileEntity).ticksRemaining);
        }
        return false;
    }

    public static boolean createMimicBlockAtLocation(World world, int x, int y, int z, int duration, Block block, int meta) {
        return TEMimicBlock.createMimicBlockAtLocation(world, x, y, z, duration, block, meta);
    }

    public void setDuration(int dur) {
        this.ticksRemaining = dur;
    }

    public void resetDuration(int dur) {
        if (this.ticksRemaining < dur) {
            this.ticksRemaining = dur;
        }
    }

    public void setContainedItem(ItemStack item) {
        this.inv[0] = item;
    }

    public void returnContainedBlock() {
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Block getBlock() {
        ItemStack item = this.inv[0];
        if (item != null && item.func_77973_b() instanceof ItemBlock) {
            return ((ItemBlock)item.func_77973_b()).field_150939_a;
        }
        return null;
    }

    public int getMetaOfMimic() {
        ItemStack item = this.inv[0];
        if (item != null) {
            return item.func_77960_j();
        }
        return 0;
    }

    public boolean getBlockEffectWhileInside(Entity entity, int x, int y, int z) {
        OmegaParadigm paradigm;
        if (this.reagent != null && (paradigm = OmegaRegistry.getParadigmForReagent(this.reagent)) != null) {
            return paradigm.getBlockEffectWhileInside(entity, x, y, z);
        }
        return false;
    }
}

