/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.lexicon.multiblock;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import org.apache.logging.log4j.Level;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.api.lexicon.multiblock.compat.MultiblockCompatRegistry;
import vazkii.botania.api.lexicon.multiblock.component.MultiblockComponent;
import vazkii.botania.common.Botania;

public class Multiblock {
    public List<MultiblockComponent> components = new ArrayList<MultiblockComponent>();
    public List<ItemStack> materials = new ArrayList<ItemStack>();
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;
    public int offX;
    public int offY;
    public int offZ;
    public HashMap<List<Integer>, MultiblockComponent> locationCache = new HashMap();

    public void addComponent(MultiblockComponent component) {
        ChunkCoordinates pos = component.relPos;
        if (this.getComponentForLocation(pos.field_71574_a, pos.field_71572_b, pos.field_71573_c) != null) {
            MultiblockComponent comp = this.getComponentForLocation(pos.field_71574_a, pos.field_71572_b, pos.field_71573_c);
            throw new IllegalArgumentException("Location in multiblock {x=" + pos.field_71574_a + " y=" + pos.field_71572_b + " z=" + pos.field_71573_c + "} already occupied by block " + comp.getBlock().func_149732_F());
        }
        this.components.add(component);
        this.changeAxisForNewComponent(pos.field_71574_a, pos.field_71572_b, pos.field_71573_c);
        this.calculateCostForNewComponent(component);
        this.addComponentToLocationCache(component);
    }

    public void addComponent(int x, int y, int z, Block block, int meta) {
        this.addComponent(new MultiblockComponent(new ChunkCoordinates(x, y, z), block, meta));
    }

    private void changeAxisForNewComponent(int x, int y, int z) {
        if (x < this.minX) {
            this.minX = x;
        } else if (x > this.maxX) {
            this.maxX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        } else if (y > this.maxY) {
            this.maxY = y;
        }
        if (z < this.minZ) {
            this.minZ = z;
        } else if (z > this.maxZ) {
            this.maxZ = z;
        }
    }

    private void calculateCostForNewComponent(MultiblockComponent comp) {
        ItemStack[] materials = comp.getMaterials();
        if (materials != null) {
            for (ItemStack stack : materials) {
                this.addStack(stack);
            }
        }
    }

    private void addStack(ItemStack stack) {
        if (stack == null) {
            return;
        }
        for (ItemStack oStack : this.materials) {
            if (!oStack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)oStack, (ItemStack)stack)) continue;
            oStack.field_77994_a += stack.field_77994_a;
            return;
        }
        this.materials.add(stack);
    }

    public void setRenderOffset(int x, int y, int z) {
        this.offX = x;
        this.offY = y;
        this.offZ = z;
    }

    public List<MultiblockComponent> getComponents() {
        return this.components;
    }

    public void rotate(double angle) {
        for (MultiblockComponent comp : this.getComponents()) {
            comp.rotate(angle);
        }
        this.updateLocationCache();
    }

    public Multiblock copy() {
        Multiblock mb = new Multiblock();
        for (MultiblockComponent comp : this.getComponents()) {
            mb.addComponent(comp.copy());
        }
        return mb;
    }

    public Multiblock[] createRotations() {
        Multiblock[] blocks = new Multiblock[4];
        blocks[0] = this;
        blocks[1] = blocks[0].copy();
        blocks[1].rotate(1.5707963267948966);
        blocks[2] = blocks[1].copy();
        blocks[2].rotate(1.5707963267948966);
        blocks[3] = blocks[2].copy();
        blocks[3].rotate(1.5707963267948966);
        return blocks;
    }

    public <T extends TileEntity> MultiblockSet makeSetRegisterStructure(Class<T> controllerTileClass, Block controllerBlock, MultiblockComponent ... extra) {
        this.registerStructure(controllerTileClass, controllerBlock, extra);
        return this.makeSet();
    }

    public <T extends TileEntity> void registerStructure(Class<T> controllerTileClass, Block controllerBlock, MultiblockComponent ... extra) {
        if (Botania.structureLibLoaded) {
            try {
                MultiblockCompatRegistry.registerMultiblock(this, controllerTileClass, controllerBlock, extra);
            }
            catch (Exception e) {
                e.printStackTrace();
                FMLLog.log((Level)Level.ERROR, (String)"Failed to load a Botania Multiblock into StructureLib.", (Object[])new Object[0]);
            }
        }
    }

    public MultiblockSet makeSet() {
        return new MultiblockSet(this);
    }

    public int getXSize() {
        return Math.abs(this.minX) + Math.abs(this.maxX) + 1;
    }

    public int getYSize() {
        return Math.abs(this.minY) + Math.abs(this.maxY) + 1;
    }

    public int getZSize() {
        return Math.abs(this.minZ) + Math.abs(this.maxZ) + 1;
    }

    public void updateLocationCache() {
        this.locationCache.clear();
        for (MultiblockComponent comp : this.components) {
            this.addComponentToLocationCache(comp);
        }
    }

    private void addComponentToLocationCache(MultiblockComponent comp) {
        ChunkCoordinates pos = comp.getRelativePosition();
        this.locationCache.put(Arrays.asList(pos.field_71574_a, pos.field_71572_b, pos.field_71573_c), comp);
    }

    public MultiblockComponent getComponentForLocation(int x, int y, int z) {
        return this.locationCache.get(Arrays.asList(x, y, z));
    }
}

