/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.awt.Color;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaTooltipDisplay;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemMod;

public class ItemManaMirror
extends ItemMod
implements IManaItem,
ICoordBoundItem,
IManaTooltipDisplay {
    IIcon[] icons;
    private static final String TAG_MANA = "mana";
    private static final String TAG_MANA_BACKLOG = "manaBacklog";
    private static final String TAG_POS_X = "posX";
    private static final String TAG_POS_Y = "posY";
    private static final String TAG_POS_Z = "posZ";
    private static final String TAG_DIM = "dim";
    private static final DummyPool fallbackPool = new DummyPool();

    public ItemManaMirror() {
        this.func_77625_d(1);
        this.func_77656_e(1000);
        this.func_77655_b("manaMirror");
        this.setNoRepair();
    }

    public int func_82790_a(ItemStack stack, int renderPass) {
        float mana = this.getMana(stack);
        return renderPass == 1 ? Color.HSBtoRGB(0.528f, mana / 1000000.0f, 1.0f) : 0xFFFFFF;
    }

    public int getDamage(ItemStack stack) {
        float mana = this.getMana(stack);
        return 1000 - (int)(mana / 1000000.0f * 1000.0f);
    }

    public int getDisplayDamage(ItemStack stack) {
        return this.getDamage(stack);
    }

    @Override
    public void func_94581_a(IIconRegister register) {
        this.icons = new IIcon[2];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = IconHelper.forItem(register, (Item)this, i);
        }
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.icons[Math.min(1, pass)];
    }

    public boolean func_77662_d() {
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int invSlot, boolean isHeld) {
        if (world.field_72995_K) {
            return;
        }
        IManaPool pool = this.getManaPool(stack);
        if (!(pool instanceof DummyPool)) {
            if (pool == null) {
                this.setMana(stack, 0);
            } else {
                pool.recieveMana(this.getManaBacklog(stack));
                this.setManaBacklog(stack, 0);
                this.setMana(stack, pool.getCurrentMana());
            }
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float subX, float subY, float subZ) {
        TileEntity tile;
        if (player.func_70093_af() && !world.field_72995_K && (tile = world.func_147438_o(x, y, z)) instanceof IManaPool) {
            this.bindPool(stack, tile);
            world.func_72956_a((Entity)player, "botania:ding", 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean func_77623_v() {
        return true;
    }

    @Override
    public int getMana(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA, 0);
    }

    public void setMana(ItemStack stack, int mana) {
        ItemNBTHelper.setInt(stack, TAG_MANA, Math.max(0, mana));
    }

    public int getManaBacklog(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA_BACKLOG, 0);
    }

    public void setManaBacklog(ItemStack stack, int backlog) {
        ItemNBTHelper.setInt(stack, TAG_MANA_BACKLOG, backlog);
    }

    @Override
    public int getMaxMana(ItemStack stack) {
        return 1000000;
    }

    @Override
    public void addMana(ItemStack stack, int mana) {
        this.setMana(stack, this.getMana(stack) + mana);
        this.setManaBacklog(stack, this.getManaBacklog(stack) + mana);
    }

    public void bindPool(ItemStack stack, TileEntity pool) {
        ItemNBTHelper.setInt(stack, TAG_POS_X, pool == null ? 0 : pool.field_145851_c);
        ItemNBTHelper.setInt(stack, TAG_POS_Y, pool == null ? -1 : pool.field_145848_d);
        ItemNBTHelper.setInt(stack, TAG_POS_Z, pool == null ? 0 : pool.field_145849_e);
        ItemNBTHelper.setInt(stack, TAG_DIM, pool == null ? 0 : pool.func_145831_w().field_73011_w.field_76574_g);
    }

    public ChunkCoordinates getPoolCoords(ItemStack stack) {
        int x = ItemNBTHelper.getInt(stack, TAG_POS_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_POS_Y, -1);
        int z = ItemNBTHelper.getInt(stack, TAG_POS_Z, 0);
        return new ChunkCoordinates(x, y, z);
    }

    public int getDimension(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_DIM, 0);
    }

    public IManaPool getManaPool(ItemStack stack) {
        TileEntity tile;
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server == null) {
            return fallbackPool;
        }
        ChunkCoordinates coords = this.getPoolCoords(stack);
        if (coords.field_71572_b == -1) {
            return null;
        }
        int dim = this.getDimension(stack);
        WorldServer world = null;
        for (WorldServer w : server.field_71305_c) {
            if (w.field_73011_w.field_76574_g != dim) continue;
            world = w;
            break;
        }
        if (world != null && (tile = world.func_147438_o(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c)) instanceof IManaPool) {
            return (IManaPool)tile;
        }
        return null;
    }

    @Override
    public boolean canReceiveManaFromPool(ItemStack stack, TileEntity pool) {
        return false;
    }

    @Override
    public boolean canReceiveManaFromItem(ItemStack stack, ItemStack otherStack) {
        return false;
    }

    @Override
    public boolean canExportManaToPool(ItemStack stack, TileEntity pool) {
        return false;
    }

    @Override
    public boolean canExportManaToItem(ItemStack stack, ItemStack otherStack) {
        return true;
    }

    @Override
    public boolean isNoExport(ItemStack stack) {
        return false;
    }

    @Override
    public ChunkCoordinates getBinding(ItemStack stack) {
        IManaPool pool = this.getManaPool(stack);
        return pool == null || pool instanceof DummyPool ? null : this.getPoolCoords(stack);
    }

    @Override
    public float getManaFractionForDisplay(ItemStack stack) {
        return (float)this.getMana(stack) / (float)this.getMaxMana(stack);
    }

    private static class DummyPool
    implements IManaPool {
        private DummyPool() {
        }

        @Override
        public boolean isFull() {
            return false;
        }

        @Override
        public void recieveMana(int mana) {
        }

        @Override
        public boolean canRecieveManaFromBursts() {
            return false;
        }

        @Override
        public int getCurrentMana() {
            return 0;
        }

        @Override
        public boolean isOutputtingPower() {
            return false;
        }
    }
}

