/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileGenerating;
import vazkii.botania.common.core.helper.ExperienceHelper;
import vazkii.botania.common.lexicon.LexiconData;

public class SubTileArcaneRose
extends SubTileGenerating {
    private static final int MANA_PER_XP = 50;
    private static final int RANGE = 1;

    @Override
    public void onUpdate() {
        super.onUpdate();
        World world = this.supertile.func_145831_w();
        if (this.mana >= this.getMaxMana() || world.field_72995_K) {
            return;
        }
        AxisAlignedBB effectBounds = AxisAlignedBB.func_72330_a((double)(this.supertile.field_145851_c - 1), (double)this.supertile.field_145848_d, (double)(this.supertile.field_145849_e - 1), (double)(this.supertile.field_145851_c + 1 + 1), (double)(this.supertile.field_145848_d + 1), (double)(this.supertile.field_145849_e + 1 + 1));
        List players = world.func_72872_a(EntityPlayer.class, effectBounds);
        for (Object player : players) {
            if (ExperienceHelper.getPlayerXP((EntityPlayer)player) <= 0 || !((EntityPlayer)player).field_70122_E) continue;
            ExperienceHelper.drainPlayerXP((EntityPlayer)player, 1);
            this.addMana(50);
            return;
        }
        List orbs = world.func_72872_a(EntityXPOrb.class, effectBounds);
        for (EntityXPOrb orb : orbs) {
            if (orb.field_70128_L) continue;
            this.addMana(orb.func_70526_d() * 50);
            orb.func_70106_y();
            float pitch = (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.35f + 0.9f;
            world.func_72956_a((Entity)orb, "random.orb", 0.1f, pitch);
            return;
        }
        List items = world.func_72872_a(EntityItem.class, effectBounds);
        for (EntityItem entity : items) {
            int xp;
            ItemStack oldStack = entity.func_92059_d();
            if (entity.field_70128_L || oldStack == null || oldStack.func_77973_b() != Items.field_151134_bR && !oldStack.func_77948_v() || (xp = SubTileArcaneRose.getEnchantmentXpValue(oldStack)) <= 0) continue;
            ItemStack newStack = SubTileArcaneRose.disenchantAndSplit(oldStack);
            if (oldStack.field_77994_a <= 0) {
                entity.func_70106_y();
            }
            EntityItem newEntity = new EntityItem(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, newStack);
            newEntity.field_70159_w = entity.field_70159_w;
            newEntity.field_70181_x = entity.field_70181_x;
            newEntity.field_70179_y = entity.field_70179_y;
            newEntity.field_70292_b = entity.field_70292_b;
            newEntity.field_145804_b = entity.field_145804_b;
            world.func_72838_d((Entity)newEntity);
            while (xp > 0) {
                int i = EntityXPOrb.func_70527_a((int)xp);
                xp -= i;
                world.func_72838_d((Entity)new EntityXPOrb(world, newEntity.field_70165_t, newEntity.field_70163_u, newEntity.field_70161_v, i));
            }
            return;
        }
    }

    private static int getEnchantmentXpValue(ItemStack stack) {
        NBTTagCompound tag;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("InfiTool")) {
            return 0;
        }
        int ret = 0;
        Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchantment = Enchantment.field_77331_b[(Integer)entry.getKey()];
            Integer integer = (Integer)entry.getValue();
            ret += enchantment.func_77321_a(integer.intValue());
        }
        return ret;
    }

    private static ItemStack disenchantAndSplit(ItemStack stack) {
        ItemStack newStack = stack.func_77979_a(1);
        if (newStack.func_77942_o()) {
            NBTTagCompound tag = newStack.func_77978_p();
            tag.func_82580_o("ench");
            tag.func_82580_o("RepairCost");
            if (tag.func_82582_d()) {
                newStack.func_77982_d(null);
            }
        }
        if (stack.func_77973_b() == Items.field_151134_bR) {
            newStack = new ItemStack(Items.field_151122_aG);
            if (stack.func_82837_s()) {
                newStack.func_151001_c(stack.func_82833_r());
            }
        }
        return newStack;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toChunkCoordinates(), 1);
    }

    @Override
    public int getColor() {
        return 0xFF8EF8;
    }

    @Override
    public int getMaxMana() {
        return 6000;
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.arcaneRose;
    }
}

