/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.botanichorizons.addons.item;

import java.util.List;
import java.util.Random;
import net.fuzzycraft.botanichorizons.addons.item.ItemSuperchargedWrench;
import net.fuzzycraft.botanichorizons.util.BlockBreakHelper;
import net.fuzzycraft.botanichorizons.util.BlockPos;
import net.fuzzycraft.botanichorizons.util.structurelib.HoloExtractor;
import net.fuzzycraft.botanichorizons.util.structurelib.HoloScanner;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class ItemDisassemblyWrench
extends ItemSuperchargedWrench {
    public static final String ITEM_ID = "terrasteelDisassemblyWrench";
    public static final int TOOL_MINING_LEVEL = 4;
    public static final int[] DISASSEMBLY_PARALLELS = new int[]{1, 1, 5, 25, 125, 625};
    public static final int DISASSEMBLY_MANA = 150;
    public static int resumePos = 0;
    private static final Random dropRandom = new Random();

    public ItemDisassemblyWrench(Item.ToolMaterial toolMaterial) {
        super(toolMaterial, 4, ITEM_ID);
    }

    @Override
    public void func_77624_a(ItemStack heldItem, EntityPlayer player, List<String> tooltips, boolean par4) {
        super.func_77624_a(heldItem, player, tooltips, par4);
        tooltips.add(I18n.func_135052_a((String)"botanichorizons.tooltip.disassembly.rightClick", (Object[])new Object[0]));
    }

    public boolean onItemUseFirst(ItemStack heldItem, EntityPlayer player, World world, int blockX, int blockY, int blockZ, int side, float hitX, float hitY, float hitZ) {
        TileEntity blockTileEntity = world.func_147438_o(blockX, blockY, blockZ);
        if (blockTileEntity == null) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("botanichorizons.chat.disassembly.missingConstruct", new Object[0]));
            return true;
        }
        return this.onItemUseTileEntity(blockTileEntity, heldItem, player, world, side);
    }

    private <T extends TileEntity> boolean onItemUseTileEntity(T tileEntity, ItemStack heldItem, EntityPlayer player, World world, int side) {
        int fail_count = 0;
        if (!world.field_72995_K) {
            int startPos;
            HoloScanner scanner = HoloExtractor.scanTileEntity(tileEntity, side);
            if (scanner == null) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("botanichorizons.chat.disassembly.missingConstruct", new Object[0]));
                return true;
            }
            int break_capacity = DISASSEMBLY_PARALLELS[this.getLevel(heldItem)];
            int slot = startPos = resumePos % scanner.multiblockLocations.size();
            int break_capacity_remaining = break_capacity;
            while (break_capacity_remaining > 0) {
                slot = (slot + 1) % scanner.multiblockLocations.size();
                BlockPos pos = scanner.multiblockLocations.get(slot);
                if (slot == startPos) break;
                Block block = world.func_147439_a(pos.x, pos.y, pos.z);
                int blockMeta = world.func_72805_g(pos.x, pos.y, pos.z);
                if (block == Blocks.field_150350_a) continue;
                if (BlockBreakHelper.tryBreakWrenchable(world, player, pos.x, pos.y, pos.z, block, blockMeta, player.field_70165_t, player.field_70163_u, player.field_70161_v)) {
                    --break_capacity_remaining;
                    continue;
                }
                if (BlockBreakHelper.tryBreakHeldTool(world, player, pos.x, pos.y, pos.z, block, blockMeta, player.field_70165_t, player.field_70163_u, player.field_70161_v, dropRandom)) {
                    --break_capacity_remaining;
                    continue;
                }
                ++fail_count;
            }
            resumePos = slot;
            int broken_blocks = break_capacity - break_capacity_remaining;
            this.damageOrConsumeMana(heldItem, (EntityLivingBase)player, broken_blocks, 150);
            if (broken_blocks == 0 && fail_count == 0) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("botanichorizons.chat.disassembly.complete", new Object[0]));
            } else if (broken_blocks == 0) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("botanichorizons.chat.disassembly.obstructed", new Object[0]));
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("botanichorizons.chat.disassembly.amount", new Object[]{"" + broken_blocks}));
            }
            return true;
        }
        if (HoloExtractor.isProbablyConstructable(tileEntity)) {
            return false;
        }
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("botanichorizons.chat.disassembly.missingConstruct", new Object[0]));
        return true;
    }
}

