/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.botanichorizons.patches;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.Materials;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;
import net.fuzzycraft.botanichorizons.patches.CraftingPatches;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.crafting.ModCraftingRecipes;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.LibOreDict;

public class GregtechPatches {
    public static void applyPatches() {
        int i;
        int i2;
        for (i2 = 0; i2 < 16; ++i2) {
            ItemStack flower = new ItemStack(ModBlocks.flower, 1, i2);
            ItemStack petal = new ItemStack(ModItems.petal, 1, i2);
            ItemStack powder = new ItemStack(ModItems.dye, 1, i2);
            GT_ModHandler.addShapelessCraftingRecipe((ItemStack)powder, (long)GT_ModHandler.RecipeBits.NOT_REMOVABLE, (Object[])new Object[]{ToolDictNames.craftingToolMortar, petal});
            GT_ModHandler.addPulverisationRecipe((ItemStack)petal, (ItemStack)powder);
            GT_ModHandler.addShapelessCraftingRecipe((ItemStack)powder, (long)GT_ModHandler.RecipeBits.NOT_REMOVABLE, (Object[])new Object[]{ToolDictNames.craftingToolMortar, flower});
            GT_ModHandler.addPulverisationRecipe((ItemStack)flower, (ItemStack)powder);
        }
        for (i2 = 0; i2 < 16; ++i2) {
            GT_ModHandler.addCompressionRecipe((ItemStack)new ItemStack(ModItems.petal, 9, i2), (ItemStack)new ItemStack(ModBlocks.petalBlock, 1, i2));
            GT_ModHandler.addExtractionRecipe((ItemStack)new ItemStack(ModBlocks.petalBlock, 1, i2), (ItemStack)new ItemStack(ModItems.petal, 9, i2));
        }
        for (i2 = 0; i2 < 16; ++i2) {
            GT_ModHandler.addExtractionRecipe((ItemStack)new ItemStack(ModBlocks.flower, 1, i2), (ItemStack)new ItemStack(ModItems.petal, 2, i2));
            for (ItemStack doubleFlowerPart : OreDictionary.getOres((String)LibOreDict.DOUBLE_FLOWER[i2])) {
                GT_ModHandler.addExtractionRecipe((ItemStack)doubleFlowerPart, (ItemStack)new ItemStack(ModItems.petal, 4, i2));
            }
        }
        ArrayList mutandis = OreDictionary.getOres((String)"itemMutandis");
        ArrayList dustEV = OreDictionary.getOres((String)"dustDraconium");
        for (ItemStack option : mutandis) {
            GregtechPatches.addMixerRecipe(new ItemStack(ModItems.fertilizer, 2, 0), 16, 80, option, new ItemStack(Items.field_151100_aR, 1, 15));
        }
        for (ItemStack option : dustEV) {
            GregtechPatches.addMixerRecipe(new ItemStack(ModItems.fertilizer, 2, 0), 16, 80, option, new ItemStack(Items.field_151100_aR, 1, 15));
        }
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.dirtPathSlab, 2), new ItemStack(ModBlocks.dirtPath, 1), 1, 16, 80);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.livingrockSlab, 2), new ItemStack(ModBlocks.livingrock, 1), 1, 16, 80);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.prismarineSlab, 2), new ItemStack(ModBlocks.prismarine, 1), 1, 16, 80);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.reedSlab, 2), new ItemStack(ModBlocks.reedBlock, 1), 1, 16, 80);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.shimmerrockSlab, 2), new ItemStack(ModBlocks.shimmerrock, 1), 1, 16, 80);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.shimmerwoodPlankSlab, 2), new ItemStack(ModBlocks.shimmerwoodPlanks, 1), 1, 16, 80);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.thatchSlab, 2), new ItemStack(ModBlocks.thatch, 1), 1, 16, 80);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.livingrockSlab, 2), new ItemStack(ModBlocks.livingrock, 1, 0), 1, 16, 80);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.livingrockBrickSlab, 2), new ItemStack(ModBlocks.livingrock, 1, 1), 1, 16, 80);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.prismarineSlab, 2), new ItemStack(ModBlocks.prismarine, 1, 0), 1, 16, 80);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.prismarineBrickSlab, 2), new ItemStack(ModBlocks.prismarine, 1, 1), 1, 16, 80);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.darkPrismarineSlab, 2), new ItemStack(ModBlocks.prismarine, 1, 2), 1, 16, 80);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.endStoneSlab, 2), new ItemStack(ModBlocks.endStoneBrick, 1, 0), 1, 16, 80);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.enderBrickSlab, 2), new ItemStack(ModBlocks.endStoneBrick, 1, 2), 1, 16, 80);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.netherBrickSlab, 2), new ItemStack(ModBlocks.customBrick, 1, 0), 1, 16, 80);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.soulBrickSlab, 2), new ItemStack(ModBlocks.customBrick, 1, 1), 1, 16, 80);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.snowBrickSlab, 2), new ItemStack(ModBlocks.customBrick, 1, 2), 1, 16, 80);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.tileSlab, 2), new ItemStack(ModBlocks.customBrick, 1, 3), 1, 16, 80);
        for (i = 0; i < 4; ++i) {
            GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.stoneSlabs[i + 0], 2), new ItemStack(ModFluffBlocks.stone, 1, i + 0), 1, 16, 80);
            GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.stoneSlabs[i + 4], 2), new ItemStack(ModFluffBlocks.stone, 1, i + 8), 1, 16, 80);
        }
        for (i = 0; i < 8; ++i) {
            GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.biomeStoneSlabs[i], 2), new ItemStack(ModFluffBlocks.biomeStoneA, 1, i), 1, 16, 80);
            GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.biomeStoneSlabs[i + 8], 2), new ItemStack(ModFluffBlocks.biomeStoneA, 1, i + 8), 1, 16, 80);
            GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.biomeStoneSlabs[i + 16], 2), new ItemStack(ModFluffBlocks.biomeStoneB, 1, i), 1, 16, 80);
        }
        for (i = 0; i < ModFluffBlocks.pavementStairs.length; ++i) {
            GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.pavementSlabs[i], 2), new ItemStack(ModFluffBlocks.pavement, 1, i), 1, 16, 80);
        }
        ModCraftingRecipes.recipeLivingwoodDecor1 = GregtechPatches.addSlabRecipe(new ItemStack(ModBlocks.livingwood, 4, 1), new ItemStack(ModBlocks.livingwood, 1, 0), 2, 16, 200);
        GregtechPatches.addSlabRecipe(new ItemStack(ModBlocks.dreamwood, 4, 1), new ItemStack(ModBlocks.dreamwood, 1, 0), 2, 16, 200);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.livingwoodSlab, 2), new ItemStack(ModBlocks.livingwood, 1, 0), 1, 16, 80);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.livingwoodPlankSlab, 2), new ItemStack(ModBlocks.livingwood, 1, 1), 1, 16, 80);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.dreamwoodSlab, 2), new ItemStack(ModBlocks.dreamwood, 1, 0), 1, 16, 80);
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.dreamwoodPlankSlab, 2), new ItemStack(ModBlocks.dreamwood, 1, 1), 1, 16, 80);
        ModCraftingRecipes.recipeLivingwoodTwig = GregtechPatches.addSlabRecipe(new ItemStack(ModItems.manaResource, 2, 3), new ItemStack(ModBlocks.livingwood, 1, 1), 2, 16, 200);
        ModCraftingRecipes.recipeDreamwoodTwig = GregtechPatches.addSlabRecipe(new ItemStack(ModItems.manaResource, 2, 13), new ItemStack(ModBlocks.dreamwood, 1, 1), 2, 16, 200);
        GregtechPatches.addStairs(ModFluffBlocks.livingrockStairs, new ItemStack(ModBlocks.livingrock, 1, 0));
        GregtechPatches.addStairs(ModFluffBlocks.livingrockBrickStairs, new ItemStack(ModBlocks.livingrock, 1, 1));
        GregtechPatches.addStairs(ModFluffBlocks.livingwoodStairs, new ItemStack(ModBlocks.livingwood, 1, 0));
        GregtechPatches.addStairs(ModFluffBlocks.livingwoodPlankStairs, new ItemStack(ModBlocks.livingwood, 1, 1));
        GregtechPatches.addStairs(ModFluffBlocks.dreamwoodStairs, new ItemStack(ModBlocks.dreamwood, 1, 0));
        GregtechPatches.addStairs(ModFluffBlocks.dreamwoodPlankStairs, new ItemStack(ModBlocks.dreamwood, 1, 1));
        GregtechPatches.addSlabRecipe(new ItemStack(ModFluffBlocks.dreamwoodPlankSlab, 2), new ItemStack(ModBlocks.dreamwood, 1, 1), 1, 16, 80);
        ModCraftingRecipes.recipeLivingrockDecor3 = GregtechPatches.addHammerRecipe(new ItemStack(ModBlocks.livingrock, 1, 3), new ItemStack(ModBlocks.livingrock, 1, 1));
        ModCraftingRecipes.recipeDarkQuartz = GregtechPatches.addQuartzRecipes(0, new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE), ModFluffBlocks.darkQuartz, ModFluffBlocks.darkQuartzStairs, ModFluffBlocks.darkQuartzSlab);
        GregtechPatches.addQuartzRecipes(1, null, ModFluffBlocks.manaQuartz, ModFluffBlocks.manaQuartzStairs, ModFluffBlocks.manaQuartzSlab);
        ModCraftingRecipes.recipeBlazeQuartz = GregtechPatches.addQuartzRecipes(2, new ItemStack(Items.field_151065_br), ModFluffBlocks.blazeQuartz, ModFluffBlocks.blazeQuartzStairs, ModFluffBlocks.blazeQuartzSlab);
        ModCraftingRecipes.recipesLavenderQuartz = Collections.singletonList(GregtechPatches.addQuartzRecipes(3, "flowerLavender", ModFluffBlocks.lavenderQuartz, ModFluffBlocks.lavenderQuartzStairs, ModFluffBlocks.lavenderQuartzSlab));
        ModCraftingRecipes.recipeRedQuartz = GregtechPatches.addQuartzRecipes(4, "dustRedstone", ModFluffBlocks.redQuartz, ModFluffBlocks.redQuartzStairs, ModFluffBlocks.redQuartzSlab);
        GregtechPatches.addQuartzRecipes(5, null, ModFluffBlocks.elfQuartz, ModFluffBlocks.elfQuartzStairs, ModFluffBlocks.elfQuartzSlab);
        ModCraftingRecipes.recipeSunnyQuartz = GregtechPatches.addQuartzRecipes(6, new ItemStack((Block)Blocks.field_150398_cm, 1, 0), ModFluffBlocks.sunnyQuartz, ModFluffBlocks.sunnyQuartzStairs, ModFluffBlocks.sunnyQuartzSlab);
        GT_ModHandler.addCompressionRecipe((ItemStack)new ItemStack(ModItems.manaResource, 9, 0), (ItemStack)new ItemStack(ModBlocks.storage, 1, 0));
        GT_ModHandler.addExtractionRecipe((ItemStack)new ItemStack(ModBlocks.storage, 1, 0), (ItemStack)new ItemStack(ModItems.manaResource, 9, 0));
        GT_ModHandler.addCompressionRecipe((ItemStack)new ItemStack(ModItems.manaResource, 9, 4), (ItemStack)new ItemStack(ModBlocks.storage, 1, 1));
        GT_ModHandler.addExtractionRecipe((ItemStack)new ItemStack(ModBlocks.storage, 1, 1), (ItemStack)new ItemStack(ModItems.manaResource, 9, 4));
        GT_ModHandler.addCompressionRecipe((ItemStack)new ItemStack(ModItems.manaResource, 9, 7), (ItemStack)new ItemStack(ModBlocks.storage, 1, 2));
        GT_ModHandler.addExtractionRecipe((ItemStack)new ItemStack(ModBlocks.storage, 1, 2), (ItemStack)new ItemStack(ModItems.manaResource, 9, 7));
        GT_ModHandler.addCompressionRecipe((ItemStack)new ItemStack(ModItems.manaResource, 9, 9), (ItemStack)new ItemStack(ModBlocks.storage, 1, 4));
        GT_ModHandler.addExtractionRecipe((ItemStack)new ItemStack(ModBlocks.storage, 1, 4), (ItemStack)new ItemStack(ModItems.manaResource, 9, 9));
        GT_ModHandler.addCompressionRecipe((ItemStack)new ItemStack(ModItems.manaResource, 9, 2), (ItemStack)new ItemStack(ModBlocks.storage, 1, 3));
        GT_ModHandler.addExtractionRecipe((ItemStack)new ItemStack(ModBlocks.storage, 1, 3), (ItemStack)new ItemStack(ModItems.manaResource, 9, 2));
        GT_ModHandler.addCompressionRecipe((ItemStack)new ItemStack(ModItems.manaResource, 9, 10), (ItemStack)new ItemStack(ModBlocks.prismarine));
        GT_ModHandler.addExtractionRecipe((ItemStack)new ItemStack(ModBlocks.prismarine), (ItemStack)new ItemStack(ModItems.manaResource, 9, 10));
        GT_ModHandler.addExtractionRecipe((ItemStack)new ItemStack(ModBlocks.reedBlock), (ItemStack)new ItemStack(Items.field_151120_aE, 8));
        GT_Recipe.GT_Recipe_Map.sAssemblerRecipes.addRecipe(true, new ItemStack[]{new ItemStack(Items.field_151120_aE, 8), GT_Utility.getIntegratedCircuit((int)16)}, new ItemStack[]{new ItemStack(ModBlocks.reedBlock)}, null, null, null, 80, 24, 0);
        GT_Recipe.GT_Recipe_Map.sAssemblerRecipes.addRecipe(true, new ItemStack[]{new ItemStack(ModItems.manaResource, 3, 3), new ItemStack(ModItems.manaResource, 3, 16), GT_Utility.getIntegratedCircuit((int)1)}, new ItemStack[]{new ItemStack(ModItems.livingwoodBow)}, null, null, null, 80, 24, 0);
        GT_Recipe.GT_Recipe_Map.sAssemblerRecipes.addRecipe(true, new ItemStack[]{new ItemStack(ModItems.manaResource, 3, 13), new ItemStack(ModItems.manaResource, 3, 16), new ItemStack(ModItems.manaResource, 2, 9)}, new ItemStack[]{new ItemStack(ModItems.crystalBow)}, null, null, null, 80, 24, 0);
        for (i = 0; i < 32; ++i) {
            Item choice = i < 16 ? ModItems.petal : ModItems.dye;
            ItemStack fabric = new ItemStack(ModItems.manaResource, 2, 22);
            ItemStack output = new ItemStack(ModItems.cosmetic, 1, i);
            CraftingPatches.addOreDictRecipe(output, "SPS", "PSP", "SPS", Character.valueOf('P'), new ItemStack(choice, 1, i % 16), Character.valueOf('S'), "clothManaweave");
            GT_Recipe.GT_Recipe_Map.sAssemblerRecipes.addRecipe(true, new ItemStack[]{fabric, new ItemStack(choice, 2, i % 16), GT_Utility.getIntegratedCircuit((int)4)}, new ItemStack[]{output}, null, null, null, 120, 80, 0);
            GT_ModHandler.addExtractionRecipe((ItemStack)new ItemStack(ModItems.cosmetic, 1, i), (ItemStack)fabric);
        }
        ModCraftingRecipes.recipesCosmeticItems = BotaniaAPI.getLatestAddedRecipes((int)32);
        GregtechPatches.addGlassPane(ModFluffBlocks.managlassPane, ModBlocks.manaGlass);
        GregtechPatches.addGlassPane(ModFluffBlocks.alfglassPane, ModBlocks.elfGlass);
        GregtechPatches.addGlassPane(ModFluffBlocks.bifrostPane, ModBlocks.bifrostPerm);
    }

    private static void addMixerRecipe(ItemStack output, int volt, int ticks, ItemStack ... input) {
        GT_Recipe.GT_Recipe_Map.sMixerRecipes.addRecipe(true, input, new ItemStack[]{output}, null, null, null, null, ticks, volt, 0);
    }

    @Nullable
    private static IRecipe addSlabRecipe(ItemStack output, ItemStack input, int circuit, int volt, int ticks) {
        ItemStack[] inputs;
        if (circuit == 0) {
            inputs = new ItemStack[]{input};
        } else {
            ItemStack circuitStack = GT_Utility.getIntegratedCircuit((int)circuit);
            inputs = new ItemStack[]{input, circuitStack};
        }
        GT_Recipe.GT_Recipe_Map.sCutterRecipes.addRecipe(true, inputs, new ItemStack[]{output}, null, null, new FluidStack[]{Materials.Water.getFluid(4L)}, null, ticks, volt, 0);
        GT_Recipe.GT_Recipe_Map.sCutterRecipes.addRecipe(true, inputs, new ItemStack[]{output}, null, null, new FluidStack[]{GT_ModHandler.getDistilledWater((long)3L)}, null, ticks, volt, 0);
        GT_Recipe.GT_Recipe_Map.sCutterRecipes.addRecipe(true, inputs, new ItemStack[]{output}, null, null, new FluidStack[]{Materials.Lubricant.getFluid(1L)}, null, ticks / 2, volt, 0);
        if (volt < 32 && output.field_77994_a % 2 == 0) {
            ItemStack half_output = new ItemStack(output.func_77973_b(), output.field_77994_a / 2, output.func_77960_j());
            String r1 = circuit <= 1 ? "sR" : "s ";
            String r2 = circuit <= 1 ? "  " : "R ";
            GT_ModHandler.addCraftingRecipe((ItemStack)half_output, (Object[])new Object[]{r1, r2, Character.valueOf('R'), input});
            return new ShapedOreRecipe(half_output, new Object[]{r1, r2, Character.valueOf('s'), ToolDictNames.craftingToolSaw.name(), Character.valueOf('R'), input});
        }
        return null;
    }

    public static IRecipe addHammerRecipe(ItemStack output, ItemStack input) {
        GT_Recipe.GT_Recipe_Map.sHammerRecipes.addRecipe(true, new ItemStack[]{input}, new ItemStack[]{output}, null, null, null, null, 32, 4, 0);
        GT_ModHandler.addCraftingRecipe((ItemStack)output, (Object[])new Object[]{"h", "R", Character.valueOf('R'), input});
        return new ShapedOreRecipe(output, new Object[]{"h", "R", Character.valueOf('R'), input, Character.valueOf('h'), ToolDictNames.craftingToolHardHammer.name()});
    }

    public static IRecipe addQuartzRecipes(int quartzMeta, @Nullable Object ingredient, Block block, Block stairs, Block slab) {
        int i;
        GT_ModHandler.addCompressionRecipe((ItemStack)new ItemStack(ModItems.quartz, 4, quartzMeta), (ItemStack)new ItemStack(block));
        for (i = 0; i < 3; ++i) {
            GT_ModHandler.addExtractionRecipe((ItemStack)new ItemStack(block, 1, i), (ItemStack)new ItemStack(ModItems.quartz, 4, quartzMeta));
        }
        GregtechPatches.addSlabRecipe(new ItemStack(slab, 2, 0), new ItemStack(block, 1, 0), 1, 16, 80);
        GameRegistry.addRecipe((ItemStack)new ItemStack(block, 4, 1), (Object[])new Object[]{"QQ", "QQ", Character.valueOf('Q'), block});
        GameRegistry.addRecipe((ItemStack)new ItemStack(block, 1, 2), (Object[])new Object[]{"Q", "Q", Character.valueOf('Q'), slab});
        GregtechPatches.addStairs(stairs, block);
        for (i = 1; i < 3; ++i) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(block, 1, 0), new Object[]{"Qf", Character.valueOf('Q'), new ItemStack(block, 1, i), Character.valueOf('f'), ToolDictNames.craftingToolFile.name()}));
        }
        if (ingredient != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModItems.quartz, 8, quartzMeta), new Object[]{"QQQ", "QCQ", "QQQ", Character.valueOf('Q'), "gemQuartz", Character.valueOf('C'), ingredient}));
            return BotaniaAPI.getLatestAddedRecipe();
        }
        return null;
    }

    public static void addGlassPane(Block paneBlock, Block inputBlock) {
        GT_Recipe.GT_Recipe_Map.sCutterRecipes.addRecipe(true, new ItemStack[]{new ItemStack(inputBlock, 3)}, new ItemStack[]{new ItemStack(paneBlock, 8)}, null, null, new FluidStack[]{Materials.Water.getFluid(4L)}, null, 100, 7, 0);
        GT_Recipe.GT_Recipe_Map.sCutterRecipes.addRecipe(true, new ItemStack[]{new ItemStack(inputBlock, 3)}, new ItemStack[]{new ItemStack(paneBlock, 8)}, null, null, new FluidStack[]{GT_ModHandler.getDistilledWater((long)3L)}, null, 100, 7, 0);
        GT_Recipe.GT_Recipe_Map.sCutterRecipes.addRecipe(true, new ItemStack[]{new ItemStack(inputBlock, 3)}, new ItemStack[]{new ItemStack(paneBlock, 8)}, null, null, new FluidStack[]{Materials.Lubricant.getFluid(1L)}, null, 50, 7, 0);
        GT_ModHandler.addCraftingRecipe((ItemStack)new ItemStack(paneBlock, 2), (Object[])new Object[]{"s", "G", Character.valueOf('G'), new ItemStack(inputBlock, 1), Character.valueOf('s'), ToolDictNames.craftingToolSaw.name()});
    }

    public static void addStairs(Block stairsBlock, Object baseBlock) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(stairsBlock, 4), new Object[]{"  Q", " QQ", "QQQ", Character.valueOf('Q'), baseBlock}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(stairsBlock, 4), new Object[]{"Q  ", "QQ ", "QQQ", Character.valueOf('Q'), baseBlock}));
    }
}

