/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.flowerpot;

import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.flowerpot.FlowerPotHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;

public class FlowerPotProperties {
    public static Block toBlock(ItemStack itemStack) {
        Block block = FlowerPotHandler.itemPlant.get(itemStack.func_77973_b());
        if (block != null) {
            return block;
        }
        return BlockProperties.toBlock(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public static int getPlantColor(TEBase TE) {
        ItemStack itemStack = TE.getAttribute((byte)22);
        Block block = FlowerPotProperties.toBlock(itemStack);
        TE.setMetadata(itemStack.func_77960_j());
        int color1 = block.func_149635_D();
        int color2 = block.func_149720_d((IBlockAccess)TE.func_145831_w(), TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
        TE.restoreMetadata();
        return color1 < color2 ? color1 : color2;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isPlantColorable(TEBase TE) {
        return FlowerPotProperties.getPlantColor(TE) != 0xFFFFFF;
    }

    public static boolean isSoil(ItemStack itemStack) {
        Block block;
        if (itemStack.func_77973_b() instanceof ItemBlock && !(block = BlockProperties.toBlock(itemStack)).hasTileEntity(itemStack.func_77960_j())) {
            Material material = block.func_149688_o();
            return material.equals(Material.field_151577_b) || material.equals(Material.field_151578_c) || material.equals(Material.field_151595_p);
        }
        return false;
    }

    public static boolean isPlant(ItemStack itemStack) {
        Block block = BlockProperties.toBlock(itemStack);
        if (!block.equals(Blocks.field_150350_a)) {
            if (!block.hasTileEntity(itemStack.func_77960_j())) {
                return block instanceof IPlantable || block instanceof IShearable;
            }
            return false;
        }
        return FlowerPotHandler.itemPlant.containsKey(itemStack.func_77973_b());
    }
}

