/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockHinged;
import com.carpentersblocks.data.Hinge;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import com.carpentersblocks.util.registry.ItemRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCarpentersDoor
extends BlockHinged {
    public static final String[] type = new String[]{"glassTop", "glassTall", "panel", "screenTall", "french", "hidden"};

    public BlockCarpentersDoor(Material material) {
        super(material);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        IconRegistry.icon_door_screen_tall = iconRegister.func_94245_a("CarpentersBlocks:door/door_screen_tall");
        IconRegistry.icon_door_glass_tall_top = iconRegister.func_94245_a("CarpentersBlocks:door/door_glass_tall_top");
        IconRegistry.icon_door_glass_tall_bottom = iconRegister.func_94245_a("CarpentersBlocks:door/door_glass_tall_bottom");
        IconRegistry.icon_door_glass_top = iconRegister.func_94245_a("CarpentersBlocks:door/door_glass_top");
        IconRegistry.icon_door_french_glass_top = iconRegister.func_94245_a("CarpentersBlocks:door/door_french_glass_top");
        IconRegistry.icon_door_french_glass_bottom = iconRegister.func_94245_a("CarpentersBlocks:door/door_french_glass_bottom");
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        if (!entityPlayer.func_70093_af()) {
            int temp = Hinge.getType(TE);
            if (++temp >= type.length) {
                temp = 0;
            }
            this.setHingeType(TE, temp);
            super.onHammerRightClick(TE, entityPlayer);
            return true;
        }
        return super.onHammerRightClick(TE, entityPlayer);
    }

    public Item func_149650_a(int metadata, Random random, int par3) {
        return ItemRegistry.itemCarpentersDoor;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return ItemRegistry.itemCarpentersDoor;
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersDoorRenderID;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        ForgeDirection[] axises = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
        return axises;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TEBase) {
            TEBase cbTile = (TEBase)tile;
            int direction = Hinge.getFacing(cbTile);
            block0 : switch (axis) {
                case UP: {
                    switch (direction) {
                        case 0: {
                            Hinge.setFacing(cbTile, 1);
                            break block0;
                        }
                        case 1: {
                            Hinge.setFacing(cbTile, 2);
                            break block0;
                        }
                        case 2: {
                            Hinge.setFacing(cbTile, 3);
                            break block0;
                        }
                        case 3: {
                            Hinge.setFacing(cbTile, 0);
                            break block0;
                        }
                    }
                    return false;
                }
                case DOWN: {
                    switch (direction) {
                        case 0: {
                            Hinge.setFacing(cbTile, 3);
                            break block0;
                        }
                        case 1: {
                            Hinge.setFacing(cbTile, 0);
                            break block0;
                        }
                        case 2: {
                            Hinge.setFacing(cbTile, 1);
                            break block0;
                        }
                        case 3: {
                            Hinge.setFacing(cbTile, 2);
                            break block0;
                        }
                    }
                    return false;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

