/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.asm;

import codechicken.lib.asm.ASMHelper;
import codechicken.lib.asm.ObfMapping;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.tree.ClassNode;

public class ClassHeirachyManager
implements IClassTransformer {
    private static final Map<String, ClassInfo> superclasses = new ConcurrentHashMap<String, ClassInfo>(1000);

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (!superclasses.containsKey(transformedName)) {
            ClassHeirachyManager.declareASM(transformedName, bytes);
        }
        return bytes;
    }

    private static ClassInfo declareASM(String name, byte[] bytes) {
        ClassNode node = ASMHelper.createClassNode(bytes, 1);
        ClassInfo classInfo = new ClassInfo(node);
        superclasses.put(name, classInfo);
        return classInfo;
    }

    private static ClassInfo declareReflection(String name) throws ClassNotFoundException {
        Class<?> aclass = Class.forName(name);
        ClassInfo classInfo = new ClassInfo(aclass);
        superclasses.put(name, classInfo);
        return classInfo;
    }

    private static ClassInfo declareClass(String name) {
        try {
            byte[] bytes = Launch.classLoader.getClassBytes(ClassHeirachyManager.unKey(name));
            if (bytes != null) {
                return ClassHeirachyManager.declareASM(name, bytes);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return ClassHeirachyManager.declareReflection(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static String toKey(String name) {
        if (ObfMapping.obfuscated) {
            return FMLDeobfuscatingRemapper.INSTANCE.map(name.replace('.', '/')).replace('/', '.');
        }
        return name.replace('/', '.');
    }

    private static String unKey(String name) {
        if (ObfMapping.obfuscated) {
            return FMLDeobfuscatingRemapper.INSTANCE.unmap(name.replace('.', '/')).replace('/', '.');
        }
        return name.replace('/', '.');
    }

    public static boolean classExtends(String name, String superclass) {
        if ((name = ClassHeirachyManager.toKey(name)).equals(superclass = ClassHeirachyManager.toKey(superclass))) {
            return true;
        }
        ClassInfo classInfo = superclasses.get(name);
        if (classInfo == null) {
            classInfo = ClassHeirachyManager.declareClass(name);
        }
        if (classInfo == null) {
            return false;
        }
        return classInfo.hasSuper(superclass);
    }

    public static String getSuperClass(String name, boolean runtime) {
        ClassInfo classInfo = superclasses.get(name = ClassHeirachyManager.toKey(name));
        if (classInfo == null) {
            classInfo = ClassHeirachyManager.declareClass(name);
        }
        if (classInfo == null || classInfo.superclass == null) {
            return "java.lang.Object";
        }
        String s = classInfo.superclass;
        if (!runtime) {
            return FMLDeobfuscatingRemapper.INSTANCE.unmap(s);
        }
        return s;
    }

    static {
        superclasses.put("java.lang.Object", ClassInfo.OBJECT);
    }

    private static class ClassInfo {
        public static final ClassInfo OBJECT = new ClassInfo();
        public final String superclass;
        public final String[] interfaces;
        public ClassInfo parent;

        private ClassInfo() {
            this.superclass = null;
            this.interfaces = null;
        }

        public ClassInfo(ClassNode node) {
            if ("java/lang/Object".equals(node.superName)) {
                this.superclass = "java.lang.Object";
                this.parent = OBJECT;
            } else {
                this.superclass = ClassHeirachyManager.toKey(node.superName);
            }
            if (node.interfaces.isEmpty()) {
                this.interfaces = null;
            } else {
                this.interfaces = new String[node.interfaces.size()];
                for (int i = 0; i < node.interfaces.size(); ++i) {
                    this.interfaces[i] = ClassHeirachyManager.toKey((String)node.interfaces.get(i));
                }
            }
        }

        public ClassInfo(Class<?> aclass) {
            if (aclass.isInterface()) {
                this.superclass = "java.lang.Object";
                this.parent = OBJECT;
            } else {
                Class<?> superclass = aclass.getSuperclass();
                if (superclass == null || "java.lang.Object".equals(superclass.getName())) {
                    this.superclass = "java.lang.Object";
                    this.parent = OBJECT;
                } else {
                    this.superclass = ClassHeirachyManager.toKey(superclass.getName());
                }
            }
            Class<?>[] interfaces = aclass.getInterfaces();
            if (interfaces.length == 0) {
                this.interfaces = null;
            } else {
                this.interfaces = new String[interfaces.length];
                for (int i = 0; i < interfaces.length; ++i) {
                    this.interfaces[i] = ClassHeirachyManager.toKey(interfaces[i].getName());
                }
            }
        }

        public boolean hasSuper(String superclass) {
            if (this.superclass == null) {
                return false;
            }
            if (this.superclass.equals(superclass)) {
                return true;
            }
            ClassInfo parentInfo = this.parent;
            if (parentInfo == null) {
                parentInfo = (ClassInfo)superclasses.get(this.superclass);
            }
            if (parentInfo == null) {
                parentInfo = ClassHeirachyManager.declareClass(this.superclass);
            }
            if (parentInfo == null) {
                return false;
            }
            this.parent = parentInfo;
            return parentInfo.hasSuper(superclass);
        }
    }
}

