/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tile;

import java.util.Arrays;
import net.minecraft.world.World;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.audio.AudioPacket;
import pl.asie.computronics.api.audio.AudioPacketDFPWM;
import pl.asie.computronics.api.audio.IAudioSource;
import pl.asie.computronics.api.tape.ITapeStorage;
import pl.asie.computronics.audio.AudioUtils;

public class TapeDriveState {
    private State state = State.STOPPED;
    private int codecId;
    private long lastCodecTime;
    public int packetSize = 1024;
    public int soundVolume = 127;
    private ITapeStorage storage;

    public ITapeStorage getStorage() {
        return this.storage;
    }

    public void setStorage(ITapeStorage storage) {
        this.storage = storage;
    }

    public void setState(State state) {
        this.state = state;
    }

    public boolean setSpeed(float speed) {
        if (speed < 0.25f || speed > 2.0f) {
            return false;
        }
        this.packetSize = Math.round(1024.0f * speed);
        return true;
    }

    public int getId() {
        return this.codecId;
    }

    public byte getVolume() {
        return (byte)this.soundVolume;
    }

    public void setVolume(float volume) {
        if (volume < 0.0f) {
            volume = 0.0f;
        }
        if (volume > 1.0f) {
            volume = 1.0f;
        }
        this.soundVolume = (int)Math.floor(volume * 127.0f);
    }

    public void switchState(World worldObj, State newState) {
        if (worldObj.field_72995_K && newState == this.state) {
            return;
        }
        if (!worldObj.field_72995_K) {
            if (this.storage == null) {
                newState = State.STOPPED;
            }
            if (this.state == State.PLAYING) {
                AudioUtils.removePlayer(Computronics.instance.managerId, this.codecId);
            }
            if (newState == State.PLAYING) {
                this.codecId = Computronics.instance.audio.newPlayer();
                Computronics.instance.audio.getPlayer(this.codecId);
                this.lastCodecTime = System.nanoTime();
            }
        }
        this.state = newState;
    }

    public State getState() {
        return this.state;
    }

    private AudioPacket createMusicPacket(IAudioSource source, World worldObj) {
        byte[] pktData = new byte[this.packetSize];
        int amount = this.storage.read(pktData, false);
        if (amount < this.packetSize) {
            this.switchState(worldObj, State.STOPPED);
        }
        if (amount > 0) {
            return new AudioPacketDFPWM(source, this.getVolume(), this.packetSize * 8 * 4, amount == this.packetSize ? pktData : Arrays.copyOf(pktData, amount));
        }
        return null;
    }

    public AudioPacket update(IAudioSource source, World worldObj) {
        if (!worldObj.field_72995_K) {
            switch (this.state) {
                case PLAYING: {
                    long time;
                    if (this.storage.getPosition() >= this.storage.getSize() || this.storage.getPosition() < 0) {
                        this.storage.setPosition(this.storage.getPosition());
                    }
                    if ((time = System.nanoTime()) - 250000000L <= this.lastCodecTime) break;
                    this.lastCodecTime += 250000000L;
                    return this.createMusicPacket(source, worldObj);
                }
                case REWINDING: {
                    int seeked = this.storage.seek(-2048);
                    if (seeked <= -2048) break;
                    this.switchState(worldObj, State.STOPPED);
                    break;
                }
                case FORWARDING: {
                    int seeked = this.storage.seek(2048);
                    if (seeked >= 2048) break;
                    this.switchState(worldObj, State.STOPPED);
                    break;
                }
            }
        }
        return null;
    }

    public static enum State {
        STOPPED,
        PLAYING,
        REWINDING,
        FORWARDING;

        public static final State[] VALUES;

        static {
            VALUES = State.values();
        }
    }
}

