/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.forestry;

import forestry.api.apiculture.FlowerManager;
import forestry.api.genetics.IFlower;
import forestry.api.genetics.IFlowerAcceptableRule;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import pl.asie.computronics.util.StringUtil;

public class FlowerProviderSea
implements IFlowerProvider,
IFlowerAcceptableRule {
    private static List<String> waterTypes = Arrays.asList("water");
    private static final List<String> saltwaterTypes = Arrays.asList("saltwater", "saltWater", "Saltwater", "SaltWater");
    private static boolean hasCheckedSaltwater = false;

    private static void checkSaltwater() {
        if (hasCheckedSaltwater) {
            return;
        }
        for (String saltwaterType : saltwaterTypes) {
            if (!FluidRegistry.isFluidRegistered((String)saltwaterType)) continue;
            waterTypes = saltwaterTypes;
            break;
        }
        hasCheckedSaltwater = true;
    }

    public boolean isAcceptableFlower(String flowerType, World world, int x, int y, int z) {
        Fluid fluid;
        Block block = world.func_147439_a(x, y, z);
        if (block != null && (fluid = FluidRegistry.lookupFluidForBlock((Block)block)) != null && FluidRegistry.isFluidRegistered((Fluid)fluid)) {
            if (!hasCheckedSaltwater) {
                FlowerProviderSea.checkSaltwater();
            }
            if (waterTypes.contains(fluid.getName())) {
                if (block instanceof IFluidBlock) {
                    return ((IFluidBlock)block).canDrain(world, x, y, z);
                }
                return world.func_72805_g(x, y, z) == 0;
            }
        }
        return false;
    }

    public boolean isAcceptedPollinatable(World world, IPollinatable iPollinatable) {
        return false;
    }

    public String getFlowerType() {
        return "computronics.flowers.sea";
    }

    public String getDescription() {
        return StringUtil.localize(this.getFlowerType());
    }

    public ItemStack[] affectProducts(World world, IIndividual individual, int x, int y, int z, ItemStack[] products) {
        return products;
    }

    @Deprecated
    public Set<IFlower> getFlowers() {
        return FlowerManager.flowerRegistry.getAcceptableFlowers(this.getFlowerType());
    }

    @Deprecated
    public boolean growFlower(World world, IIndividual iIndividual, int i, int i1, int i2) {
        return false;
    }
}

