/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.block;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import li.cil.oc.api.network.Environment;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.block.BlockMachineSidedIcon;
import pl.asie.computronics.item.block.IBlockWithSpecialText;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.tile.TileChatBox;
import pl.asie.computronics.util.StringUtil;
import pl.asie.lib.block.BlockBase;
import pl.asie.lib.block.TileEntityBase;

public class BlockChatBox
extends BlockMachineSidedIcon
implements IBlockWithSpecialText {
    private IIcon mSide;

    public BlockChatBox() {
        super("chatbox");
        this.func_149647_a(Computronics.tab);
        this.setIconName("computronics:chatbox");
        this.func_149663_c("computronics.chatBox");
        this.setRotation(BlockBase.Rotation.FOUR);
    }

    public int func_149741_i(int meta) {
        return meta >= 8 ? 0xFF60FF : 0xFFFFFF;
    }

    @Override
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta >= 8) {
            return this.func_149741_i(meta);
        }
        return super.func_149720_d(world, x, y, z);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileChatBox();
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List blockList) {
        blockList.add(new ItemStack(item, 1, 0));
        if (Config.CHATBOX_CREATIVE) {
            blockList.add(new ItemStack(item, 1, 8));
        }
    }

    public int func_149692_a(int metadata) {
        return metadata & 0xFFFFFFF8;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getAbsoluteSideIcon(int sideNumber, int metadata) {
        return this.mSide;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister r) {
        super.func_149651_a(r);
        this.mSide = r.func_94245_a("computronics:chatbox_side");
    }

    public boolean emitsRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return Config.REDSTONE_REFRESH;
    }

    public boolean func_149740_M() {
        return Config.REDSTONE_REFRESH;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityBase) {
            return ((TileEntityBase)tile).requestCurrentRedstoneValue(side);
        }
        return super.func_149736_g(world, x, y, z, side);
    }

    @Override
    public boolean hasSubTypes() {
        return true;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean wat) {
        if (stack.func_77960_j() >= 8) {
            list.add(EnumChatFormatting.GRAY + StringUtil.localize("tooltip.computronics.chatBox.creative"));
        }
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        return stack.func_77960_j() >= 8 ? "tile.computronics.chatBox.creative" : this.func_149739_a();
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Class<? extends Environment> getTileEntityClass(int meta) {
        return TileChatBox.class;
    }
}

