/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.gregtech.gregtech5;

import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicBatteryBuffer;
import gregtech.api.util.GTModHandler;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.integration.ManagedEnvironmentOCTile;

public class DriverBatteryBuffer
extends DriverSidedTileEntity {
    public Class<?> getTileEntityClass() {
        return BaseMetaTileEntity.class;
    }

    public boolean worksWith(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        return tileEntity != null && tileEntity instanceof BaseMetaTileEntity && ((BaseMetaTileEntity)tileEntity).getMetaTileEntity() instanceof MTEBasicBatteryBuffer;
    }

    public ManagedEnvironment createEnvironment(World world, int x, int y, int z, ForgeDirection side) {
        return new ManagedEnvironmentBatteryBuffer((BaseMetaTileEntity)world.func_147438_o(x, y, z), "gt_batterybuffer");
    }

    public static class ManagedEnvironmentBatteryBuffer
    extends ManagedEnvironmentOCTile<BaseMetaTileEntity> {
        public ManagedEnvironmentBatteryBuffer(BaseMetaTileEntity tile, String name) {
            super(tile, name);
        }

        @Override
        public int priority() {
            return 2;
        }

        @Callback(doc="function(slot:number):number; Returns the amount of stored EU in the battery in the specified slot")
        public Object[] getBatteryCharge(Context c, Arguments a) {
            int slot = a.checkInteger(0);
            if (slot <= 0 || slot > ((MTEBasicBatteryBuffer)((BaseMetaTileEntity)this.tile).getMetaTileEntity()).mInventory.length) {
                return new Object[]{null, "slot does not exist"};
            }
            if (((MTEBasicBatteryBuffer)((BaseMetaTileEntity)this.tile).getMetaTileEntity()).mInventory[slot - 1] == null) {
                return new Object[]{null, "slot is empty"};
            }
            ItemStack stack = ((MTEBasicBatteryBuffer)((BaseMetaTileEntity)this.tile).getMetaTileEntity()).mInventory[slot - 1];
            if (GTModHandler.isElectricItem((ItemStack)stack)) {
                return new Object[]{ElectricItem.manager.getCharge(stack)};
            }
            return new Object[]{null, "item in slot is not electric"};
        }

        @Callback(doc="function(slot:number):number; Returns the max amount of stored EU in the battery in the specified slot")
        public Object[] getMaxBatteryCharge(Context c, Arguments a) {
            int slot = a.checkInteger(0);
            if (slot <= 0 || slot > ((MTEBasicBatteryBuffer)((BaseMetaTileEntity)this.tile).getMetaTileEntity()).mInventory.length) {
                return new Object[]{null, "slot does not exist"};
            }
            if (((MTEBasicBatteryBuffer)((BaseMetaTileEntity)this.tile).getMetaTileEntity()).mInventory[slot - 1] == null) {
                return new Object[]{null, "slot is empty"};
            }
            ItemStack stack = ((MTEBasicBatteryBuffer)((BaseMetaTileEntity)this.tile).getMetaTileEntity()).mInventory[slot - 1];
            if (GTModHandler.isElectricItem((ItemStack)stack)) {
                return new Object[]{((IElectricItem)stack.func_77973_b()).getMaxCharge(stack)};
            }
            return new Object[]{null, "item in slot is not electric"};
        }
    }
}

