/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.container.inventory;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.cookingforblockheads.api.kitchen.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.food.FoodIngredient;
import net.blay09.mods.cookingforblockheads.registry.food.FoodRecipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class InventoryCraftBook
extends InventoryCrafting {
    private final int[] sourceInventories = new int[9];
    private final int[] sourceInventorySlots = new int[9];
    private final List<IKitchenItemProvider> sourceProviders = new ArrayList<IKitchenItemProvider>();
    private IRecipe currentRecipe;
    private List<IInventory> inventories;
    private List<IKitchenItemProvider> itemProviders;

    public InventoryCraftBook(Container container) {
        super(container, 3, 3);
    }

    public IRecipe prepareRecipe(EntityPlayer player, FoodRecipe recipe) {
        int i;
        List<FoodIngredient> ingredients = recipe.getCraftMatrix();
        int[][] usedStackSize = new int[this.inventories.size()][];
        for (i = 0; i < usedStackSize.length; ++i) {
            usedStackSize[i] = new int[this.inventories.get(i).func_70302_i_()];
        }
        for (i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, null);
            this.sourceInventories[i] = -1;
            this.sourceInventorySlots[i] = -1;
        }
        block2: for (i = 0; i < ingredients.size(); ++i) {
            if (ingredients.get(i) != null) {
                this.sourceProviders.clear();
                for (IKitchenItemProvider itemProvider : this.itemProviders) {
                    itemProvider.clearCraftingBuffer();
                    for (ItemStack providedStack : itemProvider.getProvidedItemStacks()) {
                        ItemStack itemStack;
                        if (!ingredients.get(i).isValidItem(providedStack) || !itemProvider.addToCraftingBuffer(itemStack = providedStack.func_77946_l())) continue;
                        this.sourceProviders.add(itemProvider);
                        this.func_70299_a(i, itemStack);
                        continue block2;
                    }
                }
                for (int j = 0; j < this.inventories.size(); ++j) {
                    for (int k = 0; k < this.inventories.get(j).func_70302_i_(); ++k) {
                        ItemStack itemStack = this.inventories.get(j).func_70301_a(k);
                        if (itemStack == null || !ingredients.get(i).isValidItem(itemStack) || itemStack.field_77994_a - usedStackSize[j][k] <= 0) continue;
                        int[] nArray = usedStackSize[j];
                        int n = k;
                        nArray[n] = nArray[n] + 1;
                        this.func_70299_a(i, itemStack);
                        this.sourceInventories[i] = j;
                        this.sourceInventorySlots[i] = k;
                        continue block2;
                    }
                }
            }
            this.currentRecipe = null;
            return null;
        }
        this.currentRecipe = CookingRegistry.findMatchingFoodRecipe(this, player.field_70170_p);
        return this.currentRecipe;
    }

    public ItemStack craft(EntityPlayer player, FoodRecipe recipe) {
        this.prepareRecipe(player, recipe);
        if (this.currentRecipe == null) {
            return null;
        }
        if (this.currentRecipe.func_77569_a((InventoryCrafting)this, player.field_70170_p)) {
            ItemStack craftingResult = this.currentRecipe.func_77572_b((InventoryCrafting)this);
            if (craftingResult != null) {
                FMLCommonHandler.instance().firePlayerCraftingEvent(player, craftingResult, (IInventory)this);
                craftingResult.func_77980_a(player.field_70170_p, player, 1);
                if (craftingResult.func_77973_b() == Items.field_151025_P) {
                    player.func_71064_a((StatBase)AchievementList.field_76014_m, 1);
                } else if (craftingResult.func_77973_b() == Items.field_151105_aU) {
                    player.func_71064_a((StatBase)AchievementList.field_76011_n, 1);
                }
                for (int i = 0; i < this.func_70302_i_(); ++i) {
                    ItemStack itemStack = this.func_70301_a(i);
                    if (itemStack == null) continue;
                    this.func_70298_a(i, 1);
                    if (itemStack.func_77973_b().hasContainerItem(itemStack) && this.sourceInventories[i] != -1) {
                        ItemStack containerItem = itemStack.func_77973_b().getContainerItem(itemStack);
                        if (containerItem != null && containerItem.func_77984_f() && itemStack.func_77960_j() > itemStack.func_77958_k()) {
                            MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, containerItem));
                            continue;
                        }
                        if (!itemStack.func_77973_b().func_77630_h(itemStack) || !player.field_71071_by.func_70441_a(containerItem)) {
                            if (this.func_70301_a(i) == null) {
                                this.func_70299_a(i, containerItem);
                            } else {
                                player.func_71019_a(containerItem, false);
                            }
                        }
                    }
                    if (this.sourceInventories[i] == -1 || this.sourceInventorySlots[i] == -1 || this.func_70301_a(i) != null) continue;
                    this.inventories.get(this.sourceInventories[i]).func_70299_a(this.sourceInventorySlots[i], null);
                }
                for (IKitchenItemProvider itemProvider : this.sourceProviders) {
                    itemProvider.craftingComplete();
                }
            }
            return craftingResult;
        }
        return null;
    }

    public boolean canMouseItemHold(EntityPlayer player, FoodRecipe recipe) {
        ItemStack mouseItem = player.field_71071_by.func_70445_o();
        if (mouseItem == null) {
            return true;
        }
        IRecipe craftingRecipe = CookingRegistry.findMatchingFoodRecipe(this, player.field_70170_p);
        if (craftingRecipe == null) {
            return false;
        }
        ItemStack craftingResult = craftingRecipe.func_77572_b((InventoryCrafting)this);
        if (!craftingResult.func_77969_a(mouseItem)) {
            return false;
        }
        return mouseItem.field_77994_a + craftingResult.field_77994_a <= mouseItem.func_77976_d();
    }

    public boolean matches(World worldObj) {
        return this.currentRecipe != null && this.currentRecipe.func_77569_a((InventoryCrafting)this, worldObj);
    }

    public void setInventories(List<IInventory> inventories) {
        this.inventories = inventories;
    }

    public void setItemProviders(List<IKitchenItemProvider> itemProviders) {
        this.itemProviders = itemProviders;
    }
}

