/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import java.util.Random;
import net.blay09.mods.cookingforblockheads.api.kitchen.IKitchenStorageProvider;
import net.blay09.mods.cookingforblockheads.container.ContainerWithInventory;
import net.blay09.mods.cookingforblockheads.container.inventory.InventoryLarge;
import net.blay09.mods.cookingforblockheads.container.inventory.InventoryNormal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class BaseKitchenTileWithInventory
extends TileEntity
implements IInventory,
IKitchenStorageProvider {
    protected static final Random random = new Random();
    private final String inventoryName;
    protected InventoryNormal internalInventory;
    protected IInventory sharedInventory;
    protected int color;
    protected boolean isFlipped;
    protected float prevDoorAngle;
    protected float doorAngle;
    protected int numPlayersUsing;
    protected int tickCounter;
    private EntityItem renderItem;

    public BaseKitchenTileWithInventory(String inventoryName) {
        this.inventoryName = inventoryName;
        this.internalInventory = new InventoryNormal(this.inventoryName);
        this.sharedInventory = this.internalInventory;
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        this.renderItem = new EntityItem(world, 0.0, 0.0, 0.0);
        this.renderItem.field_70290_d = 0.0f;
    }

    public boolean func_145842_c(int id, int value) {
        if (id == 1) {
            this.numPlayersUsing = value;
            return true;
        }
        if (id == 2) {
            this.color = value;
            return true;
        }
        return super.func_145842_c(id, value);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.internalInventory = new InventoryNormal(this.inventoryName);
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemCompound = tagList.func_150305_b(i);
            this.internalInventory.func_70299_a(itemCompound.func_74771_c("Slot"), ItemStack.func_77949_a((NBTTagCompound)itemCompound));
        }
        this.color = tagCompound.func_74771_c("Color");
        this.isFlipped = tagCompound.func_74767_n("IsFlipped");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.internalInventory.func_70302_i_(); ++i) {
            ItemStack itemStack = this.internalInventory.func_70301_a(i);
            if (itemStack == null) continue;
            NBTTagCompound itemCompound = new NBTTagCompound();
            itemCompound.func_74774_a("Slot", (byte)i);
            itemStack.func_77955_b(itemCompound);
            tagList.func_74742_a((NBTBase)itemCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        tagCompound.func_74774_a("Color", (byte)this.color);
        tagCompound.func_74757_a("IsFlipped", this.isFlipped);
    }

    protected void fixBrokenContainerClosedCall() {
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.tickCounter + this.field_145851_c + this.field_145848_d + this.field_145849_e) % 200 == 0) {
            this.numPlayersUsing = 0;
            float range = 5.0f;
            for (EntityPlayer entityPlayer : this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - range), (double)((float)this.field_145848_d - range), (double)((float)this.field_145849_e - range), (double)((float)this.field_145851_c + 1.0f + range), (double)((float)this.field_145848_d + 1.0f + range), (double)((float)this.field_145849_e + 1.0f + range)))) {
                IInventory inventory;
                if (!(entityPlayer.field_71070_bA instanceof ContainerWithInventory) || (inventory = ((ContainerWithInventory)entityPlayer.field_71070_bA).getContainerInventory()) != this && (!(inventory instanceof InventoryLarge) || !((InventoryLarge)inventory).containsInventory(this))) continue;
                ++this.numPlayersUsing;
            }
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        ++this.tickCounter;
        this.fixBrokenContainerClosedCall();
        this.prevDoorAngle = this.doorAngle;
        if (this.numPlayersUsing > 0) {
            float doorSpeed = 0.2f;
            this.doorAngle = Math.min(1.0f, this.doorAngle + 0.2f);
        } else {
            float doorSpeed = 0.1f;
            this.doorAngle = Math.max(0.0f, this.doorAngle - 0.1f);
        }
    }

    public void func_70295_k_() {
        ++this.numPlayersUsing;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numPlayersUsing);
    }

    public void func_70305_f() {
        --this.numPlayersUsing;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numPlayersUsing);
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    public int func_70302_i_() {
        return this.sharedInventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.sharedInventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int amount) {
        return this.sharedInventory.func_70298_a(i, amount);
    }

    public ItemStack func_70304_b(int i) {
        return this.sharedInventory.func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.sharedInventory.func_70299_a(i, itemStack);
    }

    public String func_145825_b() {
        return this.sharedInventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.sharedInventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.sharedInventory.func_70297_j_();
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.func_145830_o()) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public EntityItem getRenderItem() {
        return this.renderItem;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound tagCompound = pkt.func_148857_g();
        this.func_145839_a(tagCompound);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tagCompound);
    }

    public void breakBlock() {
        for (int i = 0; i < this.internalInventory.func_70302_i_(); ++i) {
            ItemStack itemStack = this.internalInventory.func_70301_a(i);
            if (itemStack == null) continue;
            float offsetX = random.nextFloat() * 0.8f + 0.1f;
            float offsetY = random.nextFloat() * 0.8f + 0.1f;
            float offsetZ = random.nextFloat() * 0.8f + 0.1f;
            while (itemStack.field_77994_a > 0) {
                int stackSize = random.nextInt(21) + 10;
                if (stackSize > itemStack.field_77994_a) {
                    stackSize = itemStack.field_77994_a;
                }
                itemStack.field_77994_a -= stackSize;
                EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + offsetX), (double)((float)this.field_145848_d + offsetY), (double)((float)this.field_145849_e + offsetZ), new ItemStack(itemStack.func_77973_b(), stackSize, itemStack.func_77960_j()));
                float f3 = 0.05f;
                entityItem.field_70159_w = (float)random.nextGaussian() * f3;
                entityItem.field_70181_x = (float)random.nextGaussian() * f3 + 0.2f;
                entityItem.field_70179_y = (float)random.nextGaussian() * f3;
                if (itemStack.func_77942_o()) {
                    entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
                }
                this.field_145850_b.func_72838_d((Entity)entityItem);
            }
        }
    }

    public void setColor(int color) {
        this.color = color;
        this.func_70296_d();
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 2, color);
    }

    public int getColor() {
        return this.color;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return true;
    }

    public float getDoorAngle() {
        return this.doorAngle;
    }

    public float getPrevDoorAngle() {
        return this.prevDoorAngle;
    }

    @Override
    public IInventory getInventory() {
        return this;
    }

    public boolean isFlipped() {
        return this.isFlipped;
    }

    public void setFlipped(boolean isFlipped) {
        this.isFlipped = isFlipped;
    }

    public InventoryNormal getInternalInventory() {
        return this.internalInventory;
    }
}

