/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.optimization.transformercache.lite;

import makamys.coretweaks.optimization.transformercache.lite.TransformerCache;
import makamys.coretweaks.optimization.transformerproxy.ITransformerWrapper;
import makamys.coretweaks.optimization.transformerproxy.TransformerProxy;
import net.minecraft.launchwrapper.IClassTransformer;

public class CachedTransformerWrapper
implements ITransformerWrapper {
    public int runs = 0;
    public int misses = 0;
    private String transformerName;

    public CachedTransformerWrapper(IClassTransformer original) {
        this.transformerName = original.getClass().getCanonicalName();
    }

    @Override
    public byte[] wrapTransform(String name, String transformedName, byte[] basicClass, TransformerProxy proxy) {
        ++this.runs;
        byte[] result = TransformerCache.instance.getCached(this.transformerName, name, transformedName, basicClass);
        if (result == null) {
            ++this.misses;
            TransformerCache.instance.prePutCached(this.transformerName, name, transformedName, basicClass);
            result = proxy.invokeNextHandler(name, transformedName, basicClass);
            TransformerCache.instance.putCached(this.transformerName, name, transformedName, result);
        }
        return TransformerCache.fromNullableByteArray(result);
    }
}

