/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.serializers;

import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.Kryo;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.KryoException;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.io.Input;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.io.Output;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.serializers.ImmutableSerializer;

public class EnumNameSerializer
extends ImmutableSerializer<Enum> {
    private final Class<? extends Enum> enumType;

    public EnumNameSerializer(Class<? extends Enum> enumType) {
        this.enumType = enumType;
    }

    @Override
    public void write(Kryo kryo, Output output, Enum object) {
        output.writeString(object.name());
    }

    @Override
    public Enum read(Kryo kryo, Input input, Class type) {
        String name = input.readString();
        try {
            return Enum.valueOf(this.enumType, name);
        }
        catch (IllegalArgumentException ex) {
            throw new KryoException("Enum value not found with name: " + name, ex);
        }
    }
}

