/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.config.Module;
import fabric.com.gitlab.cdagaming.craftpresence.config.category.Accessibility;
import fabric.com.gitlab.cdagaming.craftpresence.config.category.Advanced;
import fabric.com.gitlab.cdagaming.craftpresence.config.category.Biome;
import fabric.com.gitlab.cdagaming.craftpresence.config.category.Dimension;
import fabric.com.gitlab.cdagaming.craftpresence.config.category.Display;
import fabric.com.gitlab.cdagaming.craftpresence.config.category.General;
import fabric.com.gitlab.cdagaming.craftpresence.config.category.Server;
import fabric.com.gitlab.cdagaming.craftpresence.config.category.Status;
import fabric.com.gitlab.cdagaming.craftpresence.config.element.Button;
import fabric.com.gitlab.cdagaming.craftpresence.config.element.ModuleData;
import fabric.com.gitlab.cdagaming.craftpresence.config.element.PresenceData;
import fabric.com.gitlab.cdagaming.craftpresence.config.migration.HypherConverter;
import fabric.com.gitlab.cdagaming.craftpresence.config.migration.Legacy2Modern;
import fabric.com.gitlab.cdagaming.craftpresence.impl.KeyConverter;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Pair;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Tuple;
import fabric.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.KeyUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.TranslationUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Config
extends Module
implements Serializable {
    public static final int VERSION = 2;
    private static final long serialVersionUID = -4853238501768086595L;
    private static int MC_VERSION;
    private static List<String> keyCodeTriggers;
    private static List<String> languageTriggers;
    private static final Config INSTANCE;
    private static Config DEFAULT;
    public transient boolean hasChanged = false;
    public transient boolean hasClientPropertiesChanged = false;
    public transient boolean flushClientProperties = false;
    public transient boolean isNewFile = false;
    public String _README = "https://gitlab.com/CDAGaming/CraftPresence/-/wikis/home";
    public int _schemaVersion = 0;
    public int _lastMCVersionId = 0;
    public General generalSettings = new General();
    public Biome biomeSettings = new Biome();
    public Dimension dimensionSettings = new Dimension();
    public Server serverSettings = new Server();
    public Status statusMessages = new Status();
    public Advanced advancedSettings = new Advanced();
    public Accessibility accessibilitySettings = new Accessibility();
    public Display displaySettings = new Display();

    public static Config getInstance() {
        return Config.copy(INSTANCE, Config.class);
    }

    public static String getConfigPath() {
        return ModUtils.configDir + File.separator + "craftpresence" + ".json";
    }

    public static File getConfigFile() {
        return new File(Config.getConfigPath());
    }

    public static Config loadOrCreate(boolean forceCreate) {
        JsonElement rawJson;
        Config config;
        block8: {
            config = null;
            rawJson = null;
            Config.setupCriticalData();
            try {
                boolean shouldBeNew;
                config = FileUtils.getJsonData(Config.getConfigFile(), Config.class, new FileUtils.Modifiers[]{FileUtils.Modifiers.DISABLE_ESCAPES, FileUtils.Modifiers.PRETTY_PRINT});
                rawJson = FileUtils.getJsonData(Config.getConfigFile(), JsonElement.class, new FileUtils.Modifiers[0]);
                boolean bl = shouldBeNew = forceCreate || config._schemaVersion <= 0 || config._lastMCVersionId <= 0;
                if (shouldBeNew) {
                    config = new Config();
                    config.isNewFile = shouldBeNew;
                    config.hasClientPropertiesChanged = config.flushClientProperties = shouldBeNew;
                    config.hasChanged = config.flushClientProperties;
                    config._schemaVersion = 2;
                    config._lastMCVersionId = MC_VERSION;
                }
            }
            catch (Exception ex) {
                if (ex.getClass() == FileNotFoundException.class || ex.getClass() == NoSuchFileException.class) break block8;
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.save", new Object[0]), new Object[0]);
                if (CommandUtils.isVerboseMode()) {
                    ex.printStackTrace();
                }
                if (Config.getConfigFile().renameTo(new File(Config.getConfigPath() + ".bak"))) break block8;
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.backup", new Object[0]), new Object[0]);
            }
        }
        if (config == null) {
            config = new Config();
            config.isNewFile = true;
            config._schemaVersion = 2;
            config._lastMCVersionId = MC_VERSION;
        }
        boolean wasNewFile = config.isNewFile;
        config.handleSync(rawJson);
        if (!forceCreate) {
            config.save();
        }
        if (wasNewFile) {
            ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.config.new", new Object[0]), new Object[0]);
        } else {
            ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.config.save", new Object[0]), new Object[0]);
        }
        return config;
    }

    public static Config loadOrCreate() {
        return Config.loadOrCreate(false);
    }

    public static void setupCriticalData() {
        MC_VERSION = Integer.parseInt("5");
        keyCodeTriggers = Lists.newArrayList((Object[])new String[]{"keycode", "keybinding"});
        languageTriggers = Lists.newArrayList((Object[])new String[]{"language", "lang", "langId", "languageId"});
    }

    public static Object getProperty(Config instance, String ... path) {
        if (instance == null) {
            return null;
        }
        return instance.getProperty(path);
    }

    public static Object getProperty(Module instance, String name) {
        if (instance == null) {
            return null;
        }
        return instance.getProperty(name);
    }

    public static boolean isValidProperty(Config instance, String ... path) {
        Object property = Config.getProperty(instance, path);
        return property != null && !StringUtils.isNullOrEmpty(property.toString());
    }

    public static boolean isValidProperty(Config instance, String name) {
        return Config.isValidProperty(instance, name.split("\\."));
    }

    public static boolean isValidProperty(Module instance, String name) {
        Object property = Config.getProperty(instance, name);
        return property != null && !StringUtils.isNullOrEmpty(property.toString());
    }

    @Override
    public Config getDefaults() {
        if (DEFAULT == null) {
            DEFAULT = new Config();
        }
        return Config.copy(DEFAULT, Config.class);
    }

    public void applyData() {
        if (this.hasChanged) {
            if (this.hasClientPropertiesChanged) {
                CommandUtils.rebootRPC(this.flushClientProperties);
                this.hasClientPropertiesChanged = false;
            }
            CommandUtils.reloadData(true);
            this.flushClientProperties = false;
            this.hasChanged = false;
        }
        this.isNewFile = false;
    }

    public JsonElement handleMigrations(JsonElement rawJson, int oldVer, int newVer) {
        block10: {
            if (this.isNewFile) {
                File legacyFile = new File(ModUtils.configDir + File.separator + "craftpresence" + ".properties");
                if (legacyFile.exists()) {
                    new Legacy2Modern(legacyFile, "UTF-8").apply(this, rawJson, new Object[0]);
                } else {
                    ImmutableMap hypherionFiles = ImmutableMap.builder().put((Object)0, (Object)(ModUtils.configDir + File.separator)).put((Object)31, (Object)(CraftPresence.SYSTEM.USER_DIR + File.separator + "simple-rpc" + File.separator)).put((Object)32, (Object)(ModUtils.configDir + File.separator + "simple-rpc" + File.separator)).build();
                    for (Map.Entry<Integer, String> entry : hypherionFiles.entrySet()) {
                        File hypherionFile = new File((String)entry.getValue() + "simple-rpc.toml");
                        if (!hypherionFile.exists()) continue;
                        new HypherConverter(entry).apply(this, rawJson, new Object[0]);
                        break;
                    }
                }
            }
            if (!this.isNewFile) {
                int currentVer = oldVer;
                if (currentVer < newVer) {
                    if (CommandUtils.isVerboseMode()) {
                        ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.config.outdated", currentVer, newVer), new Object[0]);
                    }
                    if (StringUtils.isWithinValue(currentVer, 1.0, 2.0, true, true)) {
                        boolean showTime = rawJson.getAsJsonObject().getAsJsonObject("generalSettings").getAsJsonPrimitive("showTime").getAsBoolean();
                        this.displaySettings.presenceData.startTimestamp = showTime ? "{data.general.time}" : "";
                        currentVer = 2;
                    }
                    this.save();
                }
                try {
                    rawJson = FileUtils.getJsonData(Config.getConfigFile(), JsonElement.class, new FileUtils.Modifiers[0]);
                }
                catch (Exception ex) {
                    ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.save", new Object[0]), new Object[0]);
                    if (!CommandUtils.isVerboseMode()) break block10;
                    ex.printStackTrace();
                }
            }
        }
        return rawJson;
    }

    public JsonElement handleVerification(JsonElement rawJson, KeyConverter.ConversionMode keyCodeMigrationId, TranslationUtils.ConversionMode languageMigrationId, String ... path) {
        String pathPrefix = StringUtils.join(".", Arrays.asList(path));
        if (!StringUtils.isNullOrEmpty(pathPrefix)) {
            pathPrefix = pathPrefix + ".";
        }
        if (rawJson != null) {
            Object parentValue = this.getProperty(path);
            for (Map.Entry entry : rawJson.getAsJsonObject().entrySet()) {
                String rawName = pathPrefix + (String)entry.getKey();
                ArrayList configPath = Lists.newArrayList((Object[])path);
                configPath.add((String)entry.getKey());
                String[] pathData = configPath.toArray(new String[0]);
                JsonElement rawValue = (JsonElement)entry.getValue();
                Object defaultValue = this.getDefaults().getProperty(pathData);
                Object currentValue = this.getProperty(pathData);
                boolean shouldReset = false;
                boolean shouldContinue = true;
                if (defaultValue == null) {
                    if (currentValue == null || !(parentValue instanceof PresenceData) && !(parentValue instanceof ModuleData) && !(parentValue instanceof Button)) {
                        ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.prop.invalid", rawName), new Object[0]);
                        shouldContinue = false;
                    } else {
                        defaultValue = currentValue;
                    }
                }
                if (!shouldContinue) continue;
                if (Module.class.isAssignableFrom(defaultValue.getClass())) {
                    ArrayList paths = Lists.newArrayList((Object[])path);
                    paths.add((String)entry.getKey());
                    this.handleVerification((JsonElement)entry.getValue(), keyCodeMigrationId, languageMigrationId, paths.toArray(new String[0]));
                    continue;
                }
                if (rawName.contains("presence")) continue;
                if (!StringUtils.isNullOrEmpty(defaultValue.toString()) && StringUtils.isNullOrEmpty(currentValue.toString())) {
                    shouldReset = true;
                } else {
                    Class<?> expectedClass = currentValue.getClass();
                    if (!(expectedClass != Boolean.TYPE && expectedClass != Boolean.class || StringUtils.isValidBoolean(rawValue.getAsString()))) {
                        shouldReset = true;
                    } else if (expectedClass == Integer.TYPE || expectedClass == Integer.class) {
                        Pair<Boolean, Integer> boolData = StringUtils.getValidInteger(rawValue.getAsString());
                        if (boolData.getFirst().booleanValue()) {
                            for (String string : keyCodeTriggers) {
                                int migratedKeyCode;
                                if (!rawName.toLowerCase().contains(string.toLowerCase())) continue;
                                if (!KeyUtils.isValidKeyCode(boolData.getSecond())) {
                                    shouldReset = true;
                                    break;
                                }
                                if (keyCodeMigrationId == KeyConverter.ConversionMode.Unknown || (migratedKeyCode = KeyConverter.convertKey(boolData.getSecond(), keyCodeMigrationId)) == boolData.getSecond()) break;
                                ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.migration.apply", "KEYCODE", keyCodeMigrationId.name(), rawName, boolData.getSecond(), migratedKeyCode), new Object[0]);
                                this.setProperty(migratedKeyCode, pathData);
                                break;
                            }
                        } else {
                            shouldReset = true;
                        }
                    } else if (currentValue instanceof Map) {
                        HashMap newData = new HashMap((Map)currentValue);
                        HashMap defaultData = new HashMap((Map)defaultValue);
                        if (!newData.containsKey("default")) {
                            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.missing.default", rawName), new Object[0]);
                            newData.putAll(defaultData);
                            this.setProperty(newData, pathData);
                        } else if (((JsonElement)entry.getValue()).isJsonObject()) {
                            for (Object dataEntry : newData.keySet()) {
                                ArrayList paths = Lists.newArrayList((Object[])path);
                                paths.add((String)entry.getKey());
                                paths.add(dataEntry.toString());
                                JsonElement dataValue = ((JsonElement)entry.getValue()).getAsJsonObject().get(dataEntry.toString());
                                if (!dataValue.isJsonObject()) continue;
                                this.handleVerification(dataValue, keyCodeMigrationId, languageMigrationId, paths.toArray(new String[0]));
                            }
                        }
                    } else if (rawValue.isJsonPrimitive()) {
                        String rawStringValue = rawValue.getAsString();
                        for (String string : languageTriggers) {
                            String migratedLanguageId;
                            if (!rawName.toLowerCase().contains(string.toLowerCase())) continue;
                            if (languageMigrationId == TranslationUtils.ConversionMode.Unknown || (migratedLanguageId = TranslationUtils.convertId(rawStringValue, languageMigrationId)).equals(rawStringValue)) break;
                            ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.migration.apply", "LANGUAGE", languageMigrationId.name(), rawName, rawStringValue, migratedLanguageId), new Object[0]);
                            this.setProperty((Object)migratedLanguageId, pathData);
                            break;
                        }
                    }
                }
                if (!shouldReset) continue;
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.prop.empty", rawName), new Object[0]);
                this.resetProperty(pathData);
            }
        }
        return rawJson;
    }

    public JsonElement handleSync(JsonElement rawJson) {
        if (this.isNewFile || this._schemaVersion != 2) {
            int oldVer = this._schemaVersion;
            rawJson = this.handleMigrations(rawJson, oldVer, 2);
            this._schemaVersion = 2;
        }
        int oldMCVer = this._lastMCVersionId;
        if (this._lastMCVersionId != MC_VERSION) {
            this._lastMCVersionId = MC_VERSION;
        }
        KeyConverter.ConversionMode keyCodeMigrationId = oldMCVer < 341 && MC_VERSION >= 341 ? KeyConverter.ConversionMode.Lwjgl3 : (oldMCVer >= 341 && MC_VERSION < 341 ? KeyConverter.ConversionMode.Lwjgl2 : (oldMCVer >= 0 && MC_VERSION >= 0 ? KeyConverter.ConversionMode.None : KeyConverter.ConversionMode.Unknown));
        TranslationUtils.ConversionMode languageMigrationId = oldMCVer < 301 && MC_VERSION >= 301 ? TranslationUtils.ConversionMode.PackFormat3 : (oldMCVer >= 301 && MC_VERSION < 301 ? TranslationUtils.ConversionMode.PackFormat2 : (oldMCVer >= 0 && MC_VERSION >= 0 ? TranslationUtils.ConversionMode.None : TranslationUtils.ConversionMode.Unknown));
        ModUtils.LOG.debugInfo(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.migration.add", new Object[]{keyCodeTriggers.toString(), keyCodeMigrationId, keyCodeMigrationId.equals((Object)KeyConverter.ConversionMode.None) ? "Verification" : "Setting Change"}), new Object[0]);
        ModUtils.LOG.debugInfo(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.migration.add", new Object[]{languageTriggers.toString(), languageMigrationId, languageMigrationId.equals((Object)TranslationUtils.ConversionMode.None) ? "Verification" : "Setting Change"}), new Object[0]);
        return !this.isNewFile ? this.handleVerification(rawJson, keyCodeMigrationId, languageMigrationId, new String[0]) : rawJson;
    }

    public void save() {
        this.applyData();
        FileUtils.writeJsonData(this, Config.getConfigFile(), "UTF-8", FileUtils.Modifiers.DISABLE_ESCAPES, FileUtils.Modifiers.PRETTY_PRINT);
    }

    public Pair<Object, Tuple<Class<?>, Object, String>> lookupProperty(String ... path) {
        Class classObj = Config.class;
        Object instance = this;
        Object result = null;
        String name = null;
        for (int i = 0; i < path.length; ++i) {
            if (StringUtils.isNullOrEmpty(path[i])) continue;
            name = path[i];
            result = instance instanceof Map ? (Object)new HashMap((Map)instance).get(name) : StringUtils.getField(classObj, instance, name);
            if (result == null) break;
            if (i >= path.length - 1) continue;
            classObj = result.getClass();
            instance = result;
        }
        return new Pair<Object, Tuple<Class<Config>, Config, String>>(result, new Tuple<Class<Config>, Config, String>(classObj, (Config)instance, name));
    }

    public Object getProperty(String ... path) {
        return this.lookupProperty(path).getFirst();
    }

    @Override
    public Object getProperty(String name) {
        return this.getProperty(name.split("\\."));
    }

    public void setProperty(Object value, String ... path) {
        Pair<Object, Tuple<Class<?>, Object, String>> propertyData = this.lookupProperty(path);
        if (propertyData.getFirst() != null) {
            Tuple<Class<?>, Object, String> fieldData = propertyData.getSecond();
            if (fieldData.getSecond() instanceof Map) {
                String[] parentPath = Arrays.copyOf(path, path.length - 1);
                Tuple<Class<?>, Object, String> parentData = this.lookupProperty(parentPath).getSecond();
                HashMap<String, Object> data = new HashMap<String, Object>((Map)fieldData.getSecond());
                data.put(fieldData.getThird(), value);
                StringUtils.updateField(parentData.getFirst(), parentData.getSecond(), new Pair(parentData.getThird(), data));
            } else {
                StringUtils.updateField(fieldData.getFirst(), fieldData.getSecond(), new Pair<String, Object>(fieldData.getThird(), value));
            }
        }
    }

    @Override
    public void setProperty(String name, Object value) {
        this.setProperty(value, name.split("\\."));
    }

    public void resetProperty(String ... path) {
        this.setProperty(this.getDefaults().getProperty(path), path);
    }

    @Override
    public void resetProperty(String name) {
        this.resetProperty(name.split("\\."));
    }

    @Override
    public String toString() {
        return FileUtils.toJsonData(this, new FileUtils.Modifiers[0]);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Config)) {
            return false;
        }
        Config p = (Config)obj;
        return this.toString().equals(p.toString());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    static {
        INSTANCE = Config.loadOrCreate();
    }
}

