/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.config.gui;

import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.config.Config;
import fabric.com.gitlab.cdagaming.craftpresence.config.category.Biome;
import fabric.com.gitlab.cdagaming.craftpresence.config.element.ModuleData;
import fabric.com.gitlab.cdagaming.craftpresence.config.element.PresenceData;
import fabric.com.gitlab.cdagaming.craftpresence.config.gui.PresenceSettingsGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import net.minecraft.class_388;

public class BiomeSettingsGui
extends ExtendedScreen {
    private final Biome CONFIG;
    private ExtendedButtonControl proceedButton;
    private ExtendedButtonControl biomeMessagesButton;
    private ExtendedTextControl defaultMessage;

    BiomeSettingsGui(class_388 parentScreen) {
        super(parentScreen);
        this.CONFIG = CraftPresence.CONFIG.biomeSettings;
    }

    @Override
    public void initializeUi() {
        ModuleData defaultData = this.CONFIG.biomeData.get("default");
        String defaultBiomeMessage = Config.getProperty(defaultData, "textOverride") != null ? defaultData.getTextOverride() : "";
        this.defaultMessage = this.addControl(new ExtendedTextControl(this.getFontRenderer(), this.getScreenWidth() / 2 + 3, CraftPresence.GUIS.getButtonY(1), 180, 20));
        this.defaultMessage.setControlMessage(defaultBiomeMessage);
        this.biomeMessagesButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, CraftPresence.GUIS.getButtonY(2), 180, 20, "gui.config.name.biome_messages.biome_messages", () -> CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.biome", new Object[0]), CraftPresence.BIOMES.BIOME_NAMES, null, null, true, true, ScrollableListControl.RenderType.None, (attributeName, currentValue) -> {
            ModuleData defaultBiomeData = this.CONFIG.biomeData.get("default");
            ModuleData currentBiomeData = this.CONFIG.biomeData.get(attributeName);
            String defaultMessage = Config.getProperty(defaultBiomeData, "textOverride") != null ? defaultBiomeData.getTextOverride() : "";
            String currentMessage = Config.getProperty(currentBiomeData, "textOverride") != null ? currentBiomeData.getTextOverride() : "";
            CraftPresence.CONFIG.hasChanged = true;
            ModuleData newData = new ModuleData();
            if (StringUtils.isNullOrEmpty(currentMessage) || currentMessage.equals(defaultMessage)) {
                newData.setTextOverride(defaultMessage);
            }
            newData.setIconOverride((String)currentValue);
            this.CONFIG.biomeData.put((String)attributeName, newData);
        }, (currentValue, parentScreen) -> CraftPresence.GUIS.openScreen(new DynamicEditorGui((class_388)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.CONFIG.biomeData.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.CONFIG.biomeData.get("default");
            screenInstance.currentData = this.CONFIG.biomeData.get(attributeName);
            screenInstance.isPreliminaryData = screenInstance.currentData == null;
            screenInstance.mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.biome.edit_specific_biome", attributeName);
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
        }, (screenInstance, attributeName, inputText) -> {
            screenInstance.currentData.setTextOverride((String)inputText);
            CraftPresence.CONFIG.hasChanged = true;
            this.CONFIG.biomeData.put((String)attributeName, screenInstance.currentData);
            if (!CraftPresence.BIOMES.BIOME_NAMES.contains(attributeName)) {
                CraftPresence.BIOMES.BIOME_NAMES.add((String)attributeName);
            }
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.CONFIG.biomeData.remove(attributeName);
            if (!screenInstance.isPreliminaryData) {
                CraftPresence.BIOMES.BIOME_NAMES.remove(attributeName);
            }
        }, (attributeName, screenInstance, isPresenceButton) -> {
            if (isPresenceButton.booleanValue()) {
                PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                CraftPresence.GUIS.openScreen(new PresenceSettingsGui((class_388)screenInstance, currentPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
            } else {
                String defaultIcon = Config.getProperty(screenInstance.defaultData, "iconOverride") != null ? screenInstance.defaultData.getIconOverride() : this.CONFIG.fallbackBiomeIcon;
                String specificIcon = Config.getProperty(screenInstance.currentData, "iconOverride") != null ? screenInstance.currentData.getIconOverride() : defaultIcon;
                CraftPresence.GUIS.openScreen(new SelectorGui((class_388)screenInstance, ModUtils.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), specificIcon, (String)attributeName, true, false, ScrollableListControl.RenderType.DiscordAsset, (innerAttributeName, innerCurrentValue) -> screenInstance.currentData.setIconOverride((String)innerCurrentValue), null));
            }
        }, (attributeName, screenInstance) -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_messages", CraftPresence.CLIENT.generateArgumentMessage("biome."))), (ExtendedScreen)((Object)((Object)((Object)screenInstance))), true))))), () -> {
            if (!this.biomeMessagesButton.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.general.detect_biome_data", new Object[0]))), this, true);
            } else {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_messages", CraftPresence.CLIENT.generateArgumentMessage("biome."))), this, true);
            }
        }, new String[0]));
        this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, CraftPresence.GUIS.getButtonY(3), 180, 20, "gui.config.name.biome_messages.biome_icon", () -> CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), this.CONFIG.fallbackBiomeIcon, null, true, false, ScrollableListControl.RenderType.DiscordAsset, (attributeName, currentValue) -> {
            CraftPresence.CONFIG.hasChanged = true;
            CraftPresence.CONFIG.hasClientPropertiesChanged = true;
            this.CONFIG.fallbackBiomeIcon = currentValue;
        }, null)), () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_icon", new Object[0])), this, true), new String[0]));
        this.proceedButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 30, 180, 20, "gui.config.message.button.back", () -> {
            if (!this.defaultMessage.getControlMessage().equals(defaultBiomeMessage)) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                ModuleData defaultBiomeData = this.CONFIG.biomeData.getOrDefault("default", new ModuleData());
                defaultBiomeData.setTextOverride(this.defaultMessage.getControlMessage());
                this.CONFIG.biomeData.put("default", defaultBiomeData);
            }
            CraftPresence.GUIS.openScreen(this.parentScreen);
        }, () -> {
            if (!this.proceedButton.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])), this, true);
            }
        }, new String[0]));
        super.initializeUi();
    }

    @Override
    public void preRender() {
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = ModUtils.TRANSLATOR.translate("gui.config.title.biome_messages", new Object[0]);
        String defaultMessageText = ModUtils.TRANSLATOR.translate("gui.config.message.default.biome", new Object[0]);
        this.renderString(mainTitle, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(mainTitle) / 2.0f, 10.0f, 0xFFFFFF);
        this.renderString(subTitle, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(subTitle) / 2.0f, 20.0f, 0xFFFFFF);
        this.renderString(defaultMessageText, (float)this.getScreenWidth() / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(1, 5), 0xFFFFFF);
        this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty(this.defaultMessage.getControlMessage()));
        this.biomeMessagesButton.setControlEnabled(CraftPresence.BIOMES.enabled);
    }

    @Override
    public void postRender() {
        String defaultMessageText = ModUtils.TRANSLATOR.translate("gui.config.message.default.biome", new Object[0]);
        if (CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(1, 5), this.getStringWidth(defaultMessageText), this.getFontHeight())) {
            CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_messages", CraftPresence.CLIENT.generateArgumentMessage("biome."))), this, true);
        }
    }
}

