/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import external.com.jagrosh.discordipc.entities.DiscordBuild;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.config.Config;
import fabric.com.gitlab.cdagaming.craftpresence.config.element.ModuleData;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Module;
import fabric.com.gitlab.cdagaming.craftpresence.integrations.curse.CurseUtils;
import fabric.com.gitlab.cdagaming.craftpresence.integrations.mcupdater.MCUpdaterUtils;
import fabric.com.gitlab.cdagaming.craftpresence.integrations.multimc.MultiMCUtils;
import fabric.com.gitlab.cdagaming.craftpresence.integrations.technic.TechnicUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import java.util.Map;
import java.util.TreeMap;

@SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL"})
public class CommandUtils {
    private static final TreeMap<String, Module> modules = new TreeMap<String, Module>(){
        private static final long serialVersionUID = 510350212503123679L;
        {
            this.put("_biome", CraftPresence.BIOMES);
            this.put("_dimension", CraftPresence.DIMENSIONS);
            this.put("_item", CraftPresence.TILE_ENTITIES);
            this.put("_entity", CraftPresence.ENTITIES);
            this.put("_server", CraftPresence.SERVER);
            this.put("_screen", CraftPresence.GUIS);
        }
    };
    public static boolean isInMainMenu = false;
    public static boolean isLoadingGame = false;

    public static boolean isDebugMode() {
        return ModUtils.IS_DEV_FLAG || CommandUtils.isVerboseMode() || CraftPresence.CONFIG != null && CraftPresence.CONFIG.advancedSettings.debugMode;
    }

    public static boolean isVerboseMode() {
        return ModUtils.IS_VERBOSE_FLAG || CraftPresence.CONFIG != null && CraftPresence.CONFIG.advancedSettings.verboseMode;
    }

    public static void syncModuleArguments() {
        for (Map.Entry<String, Module> module : modules.entrySet()) {
            String name = module.getKey();
            name = (name.startsWith("_") ? "" : "_") + name;
            CraftPresence.CLIENT.syncArgument(name + ".instance", module.getValue());
        }
    }

    public static void clearModuleData() {
        for (Module module : modules.values()) {
            module.clearClientData();
        }
    }

    public static void addModule(String moduleId, Module instance) {
        modules.put(moduleId, instance);
    }

    public static void reloadData(boolean forceUpdateRPC) {
        ModUtils.TRANSLATOR.onTick();
        if (forceUpdateRPC) {
            ModUtils.TRANSLATOR.syncTranslations();
        }
        CraftPresence.SYSTEM.onTick();
        CraftPresence.instance.method_6635(CraftPresence.KEYBINDINGS::onTick);
        CraftPresence.SYSTEM.TICK_LOCK.lock();
        try {
            for (Module module : modules.values()) {
                if (!module.canBeLoaded()) continue;
                module.onTick();
                if (!forceUpdateRPC || !module.isInUse()) continue;
                module.updatePresence();
            }
            CraftPresence.CLIENT.onTick();
        }
        finally {
            CraftPresence.SYSTEM.TICK_LOCK.unlock();
            CraftPresence.SYSTEM.postTick();
        }
    }

    public static void rebootRPC(boolean flushOverride) {
        DiscordBuild preferredBuild;
        String clientId = CraftPresence.CONFIG.generalSettings.clientId;
        flushOverride = flushOverride || !CraftPresence.CLIENT.CLIENT_ID.equals(clientId);
        CraftPresence.CLIENT.shutDown();
        if (flushOverride) {
            DiscordAssetUtils.emptyData();
            CraftPresence.CLIENT.CLIENT_ID = clientId;
        }
        if (!CraftPresence.CLIENT.PREFERRED_CLIENT.equals((Object)(preferredBuild = DiscordBuild.from(CraftPresence.CONFIG.generalSettings.preferredClientLevel)))) {
            CraftPresence.CLIENT.PREFERRED_CLIENT = preferredBuild;
        }
        DiscordAssetUtils.loadAssets(clientId, true);
        CraftPresence.CLIENT.init(CraftPresence.CONFIG.generalSettings.resetTimeOnInit);
    }

    public static void rebootRPC() {
        CommandUtils.rebootRPC(false);
    }

    public static void init() {
        if (CraftPresence.CONFIG.generalSettings.detectCurseManifest && !CraftPresence.packFound) {
            CurseUtils.loadManifest();
        }
        if (CraftPresence.CONFIG.generalSettings.detectMultiMCManifest && !CraftPresence.packFound) {
            MultiMCUtils.loadInstance();
        }
        if (CraftPresence.CONFIG.generalSettings.detectMCUpdaterInstance && !CraftPresence.packFound) {
            MCUpdaterUtils.loadInstance();
        }
        if (CraftPresence.CONFIG.generalSettings.detectTechnicPack && !CraftPresence.packFound) {
            TechnicUtils.loadPack();
        }
        DiscordAssetUtils.loadAssets(CraftPresence.CONFIG.generalSettings.clientId, true);
        CraftPresence.KEYBINDINGS.register();
    }

    public static void syncMenuData(ModuleData currentData) {
        String currentMessage = Config.isValidProperty(currentData, "textOverride") ? currentData.getTextOverride() : "";
        String currentIcon = Config.isValidProperty(currentData, "iconOverride") ? currentData.getIconOverride() : CraftPresence.CONFIG.generalSettings.defaultIcon;
        String formattedIcon = CraftPresence.CLIENT.imageOf("menu.icon", true, currentIcon);
        CraftPresence.CLIENT.clearPartyData(true, false);
        CraftPresence.CLIENT.syncOverride(currentData, "menu.message", "menu.icon");
        CraftPresence.CLIENT.syncArgument("menu.message", currentMessage);
        CraftPresence.CLIENT.syncArgument("menu.icon", formattedIcon);
    }

    public static void setLoadingPresence() {
        CommandUtils.syncMenuData(CraftPresence.CONFIG.statusMessages.loadingData);
        isLoadingGame = true;
    }

    public static void setMainMenuPresence() {
        if (isLoadingGame) {
            CommandUtils.clearMenuPresence();
            isLoadingGame = false;
        }
        CommandUtils.syncMenuData(CraftPresence.CONFIG.statusMessages.mainMenuData);
        isInMainMenu = true;
    }

    public static void clearInitialPresence() {
        isInMainMenu = false;
        isLoadingGame = false;
        CommandUtils.clearMenuPresence();
    }

    public static void clearMenuPresence() {
        CraftPresence.CLIENT.clearOverride("menu.message", "menu.icon");
        CraftPresence.CLIENT.removeArguments("menu");
    }
}

