/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import external.io.github.classgraph.ClassGraph;
import external.io.github.classgraph.ClassInfo;
import external.io.github.classgraph.ClassInfoList;
import external.io.github.classgraph.ScanResult;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Pair;
import fabric.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.MappingUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.UrlUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FileUtils {
    private static final GsonBuilder GSON_BUILDER = new GsonBuilder();
    private static final ClassInfoList CLASS_LIST = new ClassInfoList();
    private static final Map<String, Class<?>> CLASS_MAP = Maps.newHashMap();

    public static <T> T getJsonData(File data, Class<T> classObj, Modifiers ... args) throws Exception {
        return (T)FileUtils.getJsonData(FileUtils.fileToString(data, "UTF-8"), classObj, args);
    }

    public static <T> T getJsonData(String data, Class<T> classObj, Modifiers ... args) {
        GsonBuilder builder = FileUtils.applyModifiers(GSON_BUILDER, args);
        return (T)builder.create().fromJson(data, classObj);
    }

    public static <T> T getJsonData(File data, Type typeObj, Modifiers ... args) throws Exception {
        return FileUtils.getJsonData(FileUtils.fileToString(data, "UTF-8"), typeObj, args);
    }

    public static <T> T getJsonData(String data, Type typeObj, Modifiers ... args) {
        GsonBuilder builder = FileUtils.applyModifiers(GSON_BUILDER, args);
        return (T)builder.create().fromJson(data, typeObj);
    }

    public static <T> T getJsonData(T data, Class<T> classObj, Modifiers ... args) {
        return (T)FileUtils.getJsonData(data.toString(), classObj, args);
    }

    public static String toJsonData(Object obj, Modifiers ... args) {
        GsonBuilder builder = FileUtils.applyModifiers(GSON_BUILDER, args);
        return builder.create().toJson(obj);
    }

    public static void writeJsonData(Object json, File file, String encoding, Modifiers ... args) {
        block7: {
            OutputStream outputStream;
            Writer writer;
            block6: {
                GsonBuilder builder = FileUtils.applyModifiers(GSON_BUILDER, args);
                writer = null;
                outputStream = null;
                try {
                    outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);
                    writer = new OutputStreamWriter(outputStream, Charset.forName(encoding));
                    builder.create().toJson(json, (Appendable)writer);
                }
                catch (Exception ex) {
                    if (!CommandUtils.isVerboseMode()) break block6;
                    ex.printStackTrace();
                }
            }
            try {
                if (writer != null) {
                    writer.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception ex) {
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.data.close", new Object[0]), new Object[0]);
                if (!CommandUtils.isVerboseMode()) break block7;
                ex.printStackTrace();
            }
        }
    }

    public static JsonObject parseJson(String json) {
        if (!StringUtils.isNullOrEmpty(json)) {
            JsonParser dataParser = new JsonParser();
            return dataParser.parse(json).getAsJsonObject();
        }
        return new JsonObject();
    }

    public static void downloadFile(String urlString, File file) {
        block3: {
            try {
                boolean fileDeleted;
                ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.download.init", file.getName(), file.getAbsolutePath(), urlString), new Object[0]);
                URL url = new URL(urlString);
                if (file.exists() && !(fileDeleted = file.delete())) {
                    ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.delete.file", file.getName()), new Object[0]);
                }
                InputStream stream = UrlUtils.getURLStream(url);
                org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)stream, (File)file);
                ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.download.loaded", file.getName(), file.getAbsolutePath(), urlString), new Object[0]);
            }
            catch (Exception ex) {
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.download", file.getName(), urlString, file.getAbsolutePath()), new Object[0]);
                if (!CommandUtils.isVerboseMode()) break block3;
                ex.printStackTrace();
            }
        }
    }

    public static void loadFileAsDLL(File file) {
        block3: {
            try {
                boolean isPermsSet;
                ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.dll.init", file.getName()), new Object[0]);
                boolean bl = isPermsSet = file.setReadable(true) && file.setWritable(true);
                if (isPermsSet) {
                    System.load(file.getAbsolutePath());
                }
                ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.dll.loaded", file.getName()), new Object[0]);
            }
            catch (Exception ex) {
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.dll", file.getName()), new Object[0]);
                if (!CommandUtils.isVerboseMode()) break block3;
                ex.printStackTrace();
            }
        }
    }

    public static String fileToString(File file, String encoding) throws Exception {
        return org.apache.commons.io.FileUtils.readFileToString((File)file, (Charset)Charset.forName(encoding));
    }

    public static String getFileExtension(File file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf);
    }

    public static int getModCount() {
        int modCount = CommandUtils.isDebugMode() ? 1 : 0;
        File[] mods = new File(ModUtils.modsDir).listFiles();
        if (mods != null) {
            for (File modFile : mods) {
                if (!FileUtils.getFileExtension(modFile).equals(".jar")) continue;
                ++modCount;
            }
        }
        return modCount;
    }

    public static List<Class<?>> getClassNamesMatchingSuperType(List<Class<?>> searchList, boolean includeExtraClasses, String ... sourcePackages) {
        ArrayList matchingClasses = Lists.newArrayList();
        ArrayList sourceData = Lists.newArrayList((Object[])sourcePackages);
        if (!sourceData.isEmpty() && includeExtraClasses) {
            sourceData.addAll(FileUtils.getModClassNames());
        }
        Pair<Boolean, List<Object>> subClassData = new Pair<Boolean, ArrayList>(false, Lists.newArrayList());
        block0: for (Class<?> loadedInstance : FileUtils.getClasses(sourceData)) {
            for (Class<?> searchClass : searchList) {
                subClassData = FileUtils.isSubclassOf(loadedInstance, searchClass, subClassData.getSecond());
                if (subClassData.getFirst().booleanValue()) {
                    if (!matchingClasses.contains(loadedInstance)) {
                        matchingClasses.add(loadedInstance);
                    }
                    for (Class clazz : subClassData.getSecond()) {
                        if (matchingClasses.contains(clazz)) continue;
                        matchingClasses.add(clazz);
                    }
                    continue block0;
                }
                subClassData = new Pair<Boolean, ArrayList>(false, Lists.newArrayList());
            }
        }
        return matchingClasses;
    }

    protected static Pair<Boolean, List<Class<?>>> isSubclassOf(Class<?> originalClass, Class<?> superClass, List<Class<?>> scannedClasses) {
        String superClassName;
        if (originalClass == null || superClass == null) {
            return new Pair(false, scannedClasses);
        }
        if (originalClass.equals(superClass)) {
            return new Pair(true, scannedClasses);
        }
        String className = MappingUtils.getCanonicalName(originalClass);
        if (className.equals(superClassName = MappingUtils.getCanonicalName(superClass))) {
            return new Pair(true, scannedClasses);
        }
        scannedClasses.add(originalClass);
        Pair<Boolean, List<Class<?>>> subClassInfo = FileUtils.isSubclassOf(originalClass.getSuperclass(), superClass, scannedClasses);
        if (!subClassInfo.getFirst().booleanValue() && originalClass.getInterfaces() != null) {
            for (Class<?> inter : originalClass.getInterfaces()) {
                if (!FileUtils.isSubclassOf(inter, superClass, scannedClasses).getFirst().booleanValue()) continue;
                return new Pair(true, scannedClasses);
            }
        }
        return new Pair(subClassInfo.getFirst(), scannedClasses);
    }

    public static List<Class<?>> getClassNamesMatchingSuperType(Class<?> searchTarget, boolean includeExtraClasses, String ... sourcePackages) {
        return FileUtils.getClassNamesMatchingSuperType(Lists.newArrayList((Object[])new Class[]{searchTarget}), includeExtraClasses, sourcePackages);
    }

    public static Class<?> findValidClass(ClassLoader loader, boolean init, String ... paths) {
        ArrayList classList = Lists.newArrayList((Object[])paths);
        for (String path : paths) {
            StringUtils.addEntriesNotPresent(classList, MappingUtils.getUnmappedClassesMatching(path, true));
        }
        for (String path : classList) {
            try {
                if (loader == null) {
                    return Class.forName(path);
                }
                return Class.forName(path, init, loader);
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    public static Class<?> findValidClass(ClassLoader loader, String ... paths) {
        return FileUtils.findValidClass(loader, false, paths);
    }

    public static Class<?> findValidClass(boolean useClassLoader, String ... paths) {
        return FileUtils.findValidClass(useClassLoader ? MappingUtils.CLASS_LOADER : null, paths);
    }

    public static Class<?> findValidClass(String ... paths) {
        return FileUtils.findValidClass(true, paths);
    }

    public static ClassInfoList getClassList() {
        if (CLASS_LIST.isEmpty()) {
            ClassGraph graphInfo = new ClassGraph().enableClassInfo().rejectPackages("net.java", "com.sun", "com.jcraft", "com.intellij", "jdk", "akka", "ibxm", "scala", "*.mixin.*", "*.mixins.*", "*.jetty.*").disableModuleScanning();
            if (MappingUtils.JAVA_SPEC < 16.0f) {
                graphInfo.overrideClassLoaders(MappingUtils.CLASS_LOADER);
            }
            try (ScanResult scanResult = graphInfo.scan();){
                for (ClassInfo result : scanResult.getAllClasses()) {
                    String resultName = MappingUtils.getMappedPath(result.getName());
                    if (CLASS_LIST.contains(result) || resultName.toLowerCase().contains("mixin")) continue;
                    CLASS_LIST.add(result);
                    try {
                        CLASS_MAP.put(resultName, result.loadClass(true));
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return CLASS_LIST;
    }

    public static List<Class<?>> getClasses(List<String> paths) {
        ArrayList results = Lists.newArrayList();
        HashMap unmappedNames = Maps.newHashMap();
        for (String path : paths) {
            unmappedNames.put(path, MappingUtils.getUnmappedClassesMatching(path));
        }
        for (ClassInfo classInfo : FileUtils.getClassList()) {
            if (classInfo == null) continue;
            String classPath = MappingUtils.getMappedPath(classInfo.getName());
            boolean hasMatch = paths.isEmpty();
            for (String path : paths) {
                Set unmapped = (Set)unmappedNames.get(path);
                if (!classPath.startsWith(path) && !unmapped.contains(classPath)) continue;
                hasMatch = true;
                break;
            }
            if (!hasMatch) continue;
            try {
                results.add(CLASS_MAP.get(classPath));
            }
            catch (Throwable throwable) {}
        }
        return results;
    }

    public static List<String> getModClassNames() {
        ArrayList classNames = Lists.newArrayList();
        File[] mods = new File(ModUtils.modsDir).listFiles();
        if (mods != null) {
            for (File modFile : mods) {
                if (!FileUtils.getFileExtension(modFile).equals(".jar")) continue;
                try {
                    JarFile jarFile = new JarFile(modFile.getAbsolutePath());
                    Enumeration<JarEntry> allEntries = jarFile.entries();
                    while (allEntries.hasMoreElements()) {
                        JarEntry entry = allEntries.nextElement();
                        String file = entry.getName();
                        if (!file.endsWith(".class")) continue;
                        String className = file.replace('/', '.').substring(0, file.length() - 6);
                        classNames.add(className);
                    }
                    jarFile.close();
                }
                catch (Throwable ex) {
                    if (!CommandUtils.isVerboseMode()) continue;
                    ex.printStackTrace();
                }
            }
            return classNames;
        }
        return Lists.newArrayList();
    }

    public static InputStream getResourceAsStream(Class<?> fallbackClass, String pathToSearch) {
        InputStream in = null;
        boolean useFallback = false;
        try {
            in = MappingUtils.CLASS_LOADER.getResourceAsStream(pathToSearch);
        }
        catch (Exception ex) {
            useFallback = true;
        }
        if (useFallback || in == null) {
            in = fallbackClass.getResourceAsStream(pathToSearch);
        }
        return in;
    }

    public static GsonBuilder applyModifiers(GsonBuilder instance, Modifiers ... args) {
        block4: for (Modifiers param : args) {
            switch (param) {
                case DISABLE_ESCAPES: {
                    instance.disableHtmlEscaping();
                    continue block4;
                }
                case PRETTY_PRINT: {
                    instance.setPrettyPrinting();
                    continue block4;
                }
            }
        }
        return instance;
    }

    public static enum Modifiers {
        DISABLE_ESCAPES,
        PRETTY_PRINT;

    }
}

