/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.impl.LockObject;
import fabric.com.gitlab.cdagaming.craftpresence.impl.discord.DiscordStatus;
import fabric.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import java.util.ArrayList;
import java.util.Random;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public class SystemUtils {
    public static final Random RANDOM = new Random();
    public static final int MINIMUM_REFRESH_RATE = 2;
    public final LockObject TICK_LOCK;
    public int TIMER;
    public String OS_NAME;
    public String OS_ARCH;
    public String USER_DIR;
    public boolean IS_LINUX;
    public boolean IS_MAC;
    public boolean IS_WINDOWS;
    public boolean IS_64_BIT;
    public boolean HAS_LOADED;
    public boolean HAS_GAME_LOADED;
    public boolean IS_GAME_CLOSING;
    public long CURRENT_TIMESTAMP;
    private boolean isTiming;
    private boolean refreshedCallbacks;
    private long BEGINNING_TIMESTAMP;
    private long ELAPSED_TIME;

    public SystemUtils() {
        block2: {
            this.TICK_LOCK = new LockObject();
            this.TIMER = 0;
            this.IS_LINUX = false;
            this.IS_MAC = false;
            this.IS_WINDOWS = false;
            this.IS_64_BIT = false;
            this.HAS_LOADED = false;
            this.HAS_GAME_LOADED = false;
            this.IS_GAME_CLOSING = false;
            this.isTiming = false;
            this.refreshedCallbacks = false;
            try {
                this.OS_NAME = System.getProperty("os.name");
                this.OS_ARCH = System.getProperty("os.arch");
                this.USER_DIR = System.getProperty("user.dir");
                this.IS_LINUX = this.OS_NAME.startsWith("Linux") || this.OS_NAME.startsWith("LINUX");
                this.IS_MAC = this.OS_NAME.startsWith("Mac");
                this.IS_WINDOWS = this.OS_NAME.startsWith("Windows");
                this.CURRENT_TIMESTAMP = System.currentTimeMillis();
                this.ELAPSED_TIME = 0L;
                ArrayList x64 = Lists.newArrayList((Object[])new String[]{"amd64", "x86_64"});
                this.IS_64_BIT = x64.contains(this.OS_ARCH);
                this.TICK_LOCK.unlock();
            }
            catch (Exception ex) {
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.system", new Object[0]), new Object[0]);
                if (!CommandUtils.isVerboseMode()) break block2;
                ex.printStackTrace();
            }
        }
    }

    void onTick() {
        this.ELAPSED_TIME = (System.currentTimeMillis() - this.CURRENT_TIMESTAMP) / 1000L;
        if (this.TIMER > 0) {
            if (!this.isTiming) {
                this.startTimer();
            } else {
                this.checkTimer();
            }
        }
        if (this.ELAPSED_TIME % (long)this.getRefreshRate() == 0L) {
            if (!this.refreshedCallbacks) {
                if (!this.HAS_LOADED && CraftPresence.CLIENT.STATUS == DiscordStatus.Ready) {
                    this.HAS_LOADED = true;
                }
                if (this.HAS_LOADED && !this.HAS_GAME_LOADED && CraftPresence.instance.field_3816 != null) {
                    this.HAS_GAME_LOADED = true;
                }
                this.refreshedCallbacks = true;
            }
        } else {
            this.refreshedCallbacks = false;
        }
    }

    void postTick() {
        if (this.refreshedCallbacks) {
            try {
                this.TICK_LOCK.waitForUnlock(CraftPresence.CLIENT::updatePresence);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private int getRefreshRate() {
        int result = CraftPresence.CONFIG.advancedSettings.refreshRate;
        if (result < 2) {
            result = 2;
        }
        return result;
    }

    private void startTimer() {
        this.BEGINNING_TIMESTAMP = System.currentTimeMillis() + (long)this.TIMER * 1000L;
        this.isTiming = true;
    }

    private void checkTimer() {
        if (this.TIMER > 0) {
            long remainingTime = (this.BEGINNING_TIMESTAMP - System.currentTimeMillis()) / 1000L;
            this.TIMER = (int)remainingTime;
        } else if (this.isTiming) {
            this.isTiming = false;
        }
    }
}

