/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.discord;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import external.com.jagrosh.discordipc.IPCClient;
import external.com.jagrosh.discordipc.entities.DiscordBuild;
import external.com.jagrosh.discordipc.entities.RichPresence;
import external.com.jagrosh.discordipc.entities.User;
import external.com.jagrosh.discordipc.entities.pipe.PipeStatus;
import external.org.meteordev.starscript.Script;
import external.org.meteordev.starscript.Section;
import external.org.meteordev.starscript.Starscript;
import external.org.meteordev.starscript.compiler.Compiler;
import external.org.meteordev.starscript.compiler.Expr;
import external.org.meteordev.starscript.compiler.Parser;
import external.org.meteordev.starscript.utils.Error;
import external.org.meteordev.starscript.utils.SFunction;
import external.org.meteordev.starscript.utils.VariableReplacementTransformer;
import external.org.meteordev.starscript.value.Value;
import external.org.meteordev.starscript.value.ValueMap;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.config.Config;
import fabric.com.gitlab.cdagaming.craftpresence.config.element.Button;
import fabric.com.gitlab.cdagaming.craftpresence.config.element.ModuleData;
import fabric.com.gitlab.cdagaming.craftpresence.config.element.PresenceData;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Pair;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Tuple;
import fabric.com.gitlab.cdagaming.craftpresence.impl.discord.DiscordStatus;
import fabric.com.gitlab.cdagaming.craftpresence.impl.discord.PartyPrivacy;
import fabric.com.gitlab.cdagaming.craftpresence.integrations.curse.CurseUtils;
import fabric.com.gitlab.cdagaming.craftpresence.integrations.discord.FunctionsLib;
import fabric.com.gitlab.cdagaming.craftpresence.integrations.mcupdater.MCUpdaterUtils;
import fabric.com.gitlab.cdagaming.craftpresence.integrations.multimc.MultiMCUtils;
import fabric.com.gitlab.cdagaming.craftpresence.integrations.technic.TechnicUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.discord.ModIPCListener;
import fabric.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAsset;
import fabric.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraft.class_864;
import org.apache.commons.lang3.exception.ExceptionUtils;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"})
public class DiscordUtils {
    private final Map<String, ModuleData> overrideData = Maps.newHashMap();
    private final TreeMap<String, Supplier<Value>> placeholderData = Maps.newTreeMap();
    private final Map<String, String> cachedImageData = Maps.newHashMap();
    public User CURRENT_USER;
    public User REQUESTER_USER;
    public DiscordStatus STATUS = DiscordStatus.Disconnected;
    public String GAME_STATE;
    public String DETAILS;
    public DiscordAsset SMALL_IMAGE_ASSET;
    public String SMALL_IMAGE_KEY;
    public String SMALL_IMAGE_RAW;
    public String SMALL_IMAGE_TEXT;
    public DiscordAsset LARGE_IMAGE_ASSET;
    public String LARGE_IMAGE_KEY;
    public String LARGE_IMAGE_RAW;
    public String LARGE_IMAGE_TEXT;
    public String CLIENT_ID;
    public DiscordBuild PREFERRED_CLIENT = DiscordBuild.ANY;
    public boolean AUTO_REGISTER;
    public long START_TIMESTAMP;
    public String PARTY_ID;
    public int PARTY_SIZE;
    public int PARTY_MAX;
    public PartyPrivacy PARTY_PRIVACY = PartyPrivacy.Public;
    public String JOIN_SECRET;
    public long END_TIMESTAMP;
    public String MATCH_SECRET;
    public String SPECTATE_SECRET;
    public JsonArray BUTTONS = new JsonArray();
    public byte INSTANCE;
    public Starscript scriptEngine = new Starscript();
    public IPCClient ipcInstance;
    public boolean awaitingReply = false;
    public PresenceData forcedData = null;
    private Pair<String, String> lastRequestedImageData = new Pair();
    private RichPresence currentPresence;
    private long lastStartTime;
    private long currentStartTime;

    public synchronized void setup() {
        Thread shutdownThread = new Thread("CraftPresence-ShutDown-Handler"){

            @Override
            public void run() {
                CraftPresence.SYSTEM.IS_GAME_CLOSING = true;
                CraftPresence.timerObj.cancel();
                DiscordUtils.this.shutDown();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init(boolean debugMode, boolean verboseMode, boolean updateTimestamp) {
        block7: {
            try {
                this.scriptEngine = new Starscript();
                FunctionsLib.init(this.scriptEngine);
                this.ipcInstance = new IPCClient(Long.parseLong(this.CLIENT_ID), debugMode, verboseMode, this.AUTO_REGISTER, this.CLIENT_ID);
                this.ipcInstance.setListener(new ModIPCListener());
                if (this.PREFERRED_CLIENT != DiscordBuild.ANY) {
                    this.ipcInstance.connect(this.PREFERRED_CLIENT, DiscordBuild.ANY);
                } else {
                    this.ipcInstance.connect(new DiscordBuild[0]);
                }
                this.ipcInstance.subscribe(IPCClient.Event.ACTIVITY_JOIN);
                this.ipcInstance.subscribe(IPCClient.Event.ACTIVITY_JOIN_REQUEST);
                this.ipcInstance.subscribe(IPCClient.Event.ACTIVITY_SPECTATE);
            }
            catch (Exception ex) {
                if (!CommandUtils.isVerboseMode()) break block7;
                ex.printStackTrace();
            }
        }
        TreeMap<String, Supplier<Value>> ex = this.placeholderData;
        synchronized (ex) {
            this.overrideData.clear();
            this.placeholderData.clear();
        }
        CommandUtils.isInMainMenu = false;
        long newStartTime = System.currentTimeMillis() / 1000L;
        this.currentStartTime = !updateTimestamp && this.lastStartTime > 0L ? this.lastStartTime : newStartTime;
        this.lastStartTime = newStartTime;
    }

    public synchronized void init(boolean debugMode, boolean updateTimestamp) {
        this.init(debugMode, CommandUtils.isVerboseMode(), updateTimestamp);
    }

    public synchronized void init(boolean updateTimestamp) {
        this.init(CommandUtils.isDebugMode(), updateTimestamp);
    }

    public List<String> createButtonsList(Map<String, Button> list) {
        ArrayList result = Lists.newArrayList();
        for (String buttonEntry : list.keySet()) {
            if (StringUtils.isNullOrEmpty(buttonEntry)) continue;
            result.add(buttonEntry);
        }
        return result;
    }

    public List<String> createButtonsList() {
        return this.createButtonsList(this.getPresenceData().buttons);
    }

    public String sanitizePlaceholders(String input, int length, String fallback) {
        return StringUtils.getOrDefault(input, fallback, StringUtils.NULL_OR_EMPTY.negate().and(e -> StringUtils.getBytes(e, "UTF-8").length < length)).trim();
    }

    public String sanitizePlaceholders(String input, int length) {
        return this.sanitizePlaceholders(input, length, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public final Supplier<Value> compileData(String input, String overrideId, boolean plain, Pair<String, Supplier<String>> ... replacements) {
        TreeMap<String, Supplier<Value>> treeMap = this.placeholderData;
        synchronized (treeMap) {
            TreeMap placeholders = Maps.newTreeMap(this.placeholderData);
            String data = StringUtils.getOrDefault(input);
            if (!plain) {
                return this.getCompileResult(data, null, this.generateTransformer(data, overrideId, placeholders, replacements));
            }
            return () -> Value.string(data);
        }
    }

    @SafeVarargs
    public final VariableReplacementTransformer generateTransformer(String input, String overrideId, Map<String, Supplier<Value>> placeholders, Pair<String, Supplier<String>> ... replacements) {
        VariableReplacementTransformer transformer = new VariableReplacementTransformer();
        String data = StringUtils.getOrDefault(input);
        if (!StringUtils.isNullOrEmpty(overrideId)) {
            for (String placeholderName : placeholders.keySet()) {
                if (placeholderName.startsWith("overrides.")) continue;
                transformer.addReplacer(placeholderName, () -> {
                    String overrideName = "overrides." + placeholderName + "." + overrideId;
                    return placeholders.containsKey(overrideName) && !StringUtils.isNullOrEmpty(((Value)((Supplier)placeholders.get(overrideName)).get()).toString()) ? overrideName : placeholderName;
                });
            }
        }
        if (replacements != null) {
            for (Pair<String, Supplier<String>> replacement : replacements) {
                Supplier<String> info;
                if (replacement == null || (info = replacement.getSecond()) == null) continue;
                String value = info.get();
                if (placeholders.containsKey(value)) {
                    transformer.addReplacer(replacement.getFirst(), info);
                    continue;
                }
                data = data.replace(replacement.getFirst(), !StringUtils.isNullOrEmpty(value) ? "'" + value + "'" : "null");
            }
        }
        return transformer;
    }

    public Supplier<Value> getCompileResult(String data, Appendable output, Expr.Visitor ... transforms) {
        Parser.Result result = null;
        try {
            result = Parser.parse(data);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String originalPrefix = ModUtils.TRANSLATOR.translate("gui.config.message.editor.original", new Object[0]);
        String messagePrefix = ModUtils.TRANSLATOR.translate("gui.config.message.editor.message", new Object[0]);
        String verbosePrefix = ModUtils.TRANSLATOR.translate("craftpresence.logger.error.verbose", new Object[0]);
        if (result == null || result.hasErrors()) {
            if (result != null) {
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.parser", new Object[0]), new Object[0]);
                ModUtils.LOG.error("%1$s \"%2$s\"", originalPrefix, data);
                ModUtils.LOG.error(messagePrefix, new Object[0]);
                for (Error error : result.errors) {
                    if (output != null) {
                        try {
                            output.append(error.toString()).append('\n');
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ModUtils.LOG.error("\t" + error.toString(), new Object[0]);
                }
            }
            return Value::null_;
        }
        for (Expr.Visitor transformer : transforms) {
            result.accept(transformer);
        }
        Script script = Compiler.compile(result);
        return () -> {
            Section sect;
            try {
                sect = new Starscript(this.scriptEngine).run(script);
                if (output != null) {
                    script.decompile(output);
                }
            }
            catch (Throwable ex) {
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.compiler", new Object[0]), new Object[0]);
                ModUtils.LOG.error("%1$s \"%2$s\"", originalPrefix, data);
                List<String> splitEx = StringUtils.splitTextByNewLine(ExceptionUtils.getStackTrace((Throwable)ex));
                if (output != null) {
                    try {
                        if (CommandUtils.isVerboseMode()) {
                            for (String line : splitEx) {
                                line = line.replace("\t", "    ");
                                output.append(line).append('\n');
                            }
                        } else {
                            output.append(splitEx.get(0)).append('\n');
                            if (splitEx.size() > 1) {
                                output.append('\n').append(verbosePrefix).append('\n');
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (CommandUtils.isVerboseMode()) {
                    ModUtils.LOG.error(messagePrefix, new Object[0]);
                    ex.printStackTrace();
                } else {
                    ModUtils.LOG.error("%1$s \"%2$s\"", messagePrefix, splitEx.get(0));
                    if (splitEx.size() > 1) {
                        ModUtils.LOG.error(verbosePrefix, new Object[0]);
                    }
                }
                return Value.null_();
            }
            return !StringUtils.isNullOrEmpty(sect.toString()) ? Value.string(sect.toString()) : Value.null_();
        };
    }

    @SafeVarargs
    public final String getResult(String input, String overrideId, boolean plain, Pair<String, Supplier<String>> ... replacements) {
        Value data = this.compileData(input, overrideId, plain, replacements).get();
        return !data.isNull() ? data.toString() : "";
    }

    @SafeVarargs
    public final Supplier<Value> compileData(String input, String overrideId, Pair<String, Supplier<String>> ... replacements) {
        return this.compileData(input, overrideId, false, replacements);
    }

    @SafeVarargs
    public final String getResult(String input, String overrideId, Pair<String, Supplier<String>> ... replacements) {
        return this.getResult(input, overrideId, false, replacements);
    }

    @SafeVarargs
    public final Supplier<Value> compileData(String input, boolean plain, Pair<String, Supplier<String>> ... replacements) {
        return this.compileData(input, null, plain, replacements);
    }

    @SafeVarargs
    public final String getResult(String input, boolean plain, Pair<String, Supplier<String>> ... replacements) {
        return this.getResult(input, null, plain, replacements);
    }

    @SafeVarargs
    public final Supplier<Value> compileData(String input, Pair<String, Supplier<String>> ... replacements) {
        return this.compileData(input, false, replacements);
    }

    @SafeVarargs
    public final String getResult(String input, Pair<String, Supplier<String>> ... replacements) {
        return this.getResult(input, false, replacements);
    }

    public Supplier<Value> compileData(String input) {
        return this.compileData(input, new Pair[]{null});
    }

    public String getResult(String input) {
        return this.getResult(input, new Pair[]{null});
    }

    public void syncTimestamp(String ... args) {
        long newTimestamp = System.currentTimeMillis() / 1000L;
        for (String argumentName : args) {
            this.syncArgument(argumentName, newTimestamp);
        }
    }

    public void syncOverride(ModuleData data, String ... args) {
        PresenceData presenceInfo = null;
        if (data != null && Config.getProperty(data, "data") != null) {
            presenceInfo = data.getData();
        }
        boolean isPresenceOn = presenceInfo != null && presenceInfo.enabled;
        for (String argumentName : args) {
            if (StringUtils.isNullOrEmpty(argumentName)) continue;
            this.overrideData.put(argumentName, data);
            String prefix = "overrides." + argumentName;
            if (isPresenceOn && !presenceInfo.useAsMain) {
                this.syncArgument(prefix + ".details", presenceInfo.details);
                this.syncArgument(prefix + ".gameState", presenceInfo.gameState);
                this.syncArgument(prefix + ".largeImageKey", presenceInfo.largeImageKey);
                this.syncArgument(prefix + ".largeImageText", presenceInfo.largeImageText);
                this.syncArgument(prefix + ".smallImageKey", presenceInfo.smallImageKey);
                this.syncArgument(prefix + ".smallImageText", presenceInfo.smallImageText);
                this.syncArgument(prefix + ".startTimestamp", presenceInfo.startTimestamp);
                this.syncArgument(prefix + ".endTimestamp", presenceInfo.endTimestamp);
                for (Map.Entry<String, Button> buttonData : presenceInfo.buttons.entrySet()) {
                    String buttonId = buttonData.getKey();
                    Button buttonInfo = buttonData.getValue();
                    if (StringUtils.isNullOrEmpty(buttonId) || buttonId.equalsIgnoreCase("default")) continue;
                    this.syncArgument(prefix + "." + buttonId + ".label", buttonInfo.label);
                    this.syncArgument(prefix + "." + buttonId + ".url", buttonInfo.url);
                }
                continue;
            }
            this.removeArguments(prefix);
        }
        if (isPresenceOn && presenceInfo.useAsMain) {
            this.forcedData = data.getData();
        }
    }

    public void clearOverride(String ... args) {
        for (String argumentName : args) {
            if (StringUtils.isNullOrEmpty(argumentName) || !this.overrideData.containsKey(argumentName)) continue;
            ModuleData oldData = this.overrideData.get(argumentName);
            this.overrideData.remove(argumentName);
            this.removeArguments("overrides." + argumentName);
            if (oldData == null || Config.getProperty(oldData, "data") == null || !oldData.getData().equals(this.forcedData)) continue;
            this.forcedData = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncArgument(String argumentName, Supplier<Value> data) {
        TreeMap<String, Supplier<Value>> treeMap = this.placeholderData;
        synchronized (treeMap) {
            if (!StringUtils.isNullOrEmpty(argumentName)) {
                this.scriptEngine.set(argumentName, data);
                this.placeholderData.put(argumentName, data);
            }
        }
    }

    public void syncArgument(String argumentName, Object data, boolean plain) {
        this.syncArgument(argumentName, () -> this.toValue(data, plain));
    }

    public void syncArgument(String argumentName, Object data) {
        this.syncArgument(argumentName, data, false);
    }

    public void initArgument(String ... args) {
        for (String argumentName : args) {
            this.syncArgument(argumentName, Value::null_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeArguments(String ... args) {
        TreeMap<String, Supplier<Value>> treeMap = this.placeholderData;
        synchronized (treeMap) {
            ArrayList items = Lists.newArrayList(this.placeholderData.keySet());
            block3: for (String key : items) {
                for (String format : args) {
                    if (!key.startsWith(format)) continue;
                    this.scriptEngine.remove(key);
                    this.placeholderData.remove(key);
                    continue block3;
                }
            }
        }
    }

    public Object fromValue(Value data) {
        if (data.isNumber()) {
            return data.getNumber();
        }
        if (data.isBool()) {
            return data.getBool();
        }
        if (data.isMap()) {
            return data.getMap();
        }
        if (data.isFunction()) {
            return data.getFunction();
        }
        if (data.isString()) {
            return data.getString();
        }
        return data.isObject() ? data.getObject() : null;
    }

    public Value toValue(Object data, boolean plain) {
        if (data instanceof Number) {
            return Value.number(((Number)data).doubleValue());
        }
        if (data instanceof Boolean) {
            return Value.bool((Boolean)data);
        }
        if (data instanceof ValueMap) {
            return Value.map((ValueMap)data);
        }
        if (data instanceof SFunction) {
            return Value.function((SFunction)data);
        }
        if (data instanceof String) {
            return this.compileData(data.toString(), plain, new Pair[0]).get();
        }
        return data != null ? Value.object(data) : Value.null_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Supplier<Value>> getArguments(String ... args) {
        TreeMap<String, Supplier<Value>> treeMap = this.placeholderData;
        synchronized (treeMap) {
            TreeMap items = Maps.newTreeMap(this.placeholderData);
            TreeMap list = Maps.newTreeMap();
            for (Map.Entry entry : items.entrySet()) {
                boolean addToList;
                String item = (String)entry.getKey();
                Supplier data = (Supplier)entry.getValue();
                boolean bl = addToList = args == null || args.length < 1 || args[0] == null;
                if (!addToList) {
                    for (String name : args) {
                        if (!StringUtils.isNullOrEmpty(name)) {
                            boolean bl2 = addToList = item.startsWith(name) || name.equalsIgnoreCase("type:all") || name.equalsIgnoreCase("all") || name.startsWith("type:") && this.matchesType(name.replaceFirst("type:", "").toLowerCase(), (Value)data.get());
                        }
                        if (addToList) break;
                    }
                }
                if (!addToList) continue;
                list.put(item, data);
            }
            return list;
        }
    }

    public boolean matchesType(String type, Value data) {
        switch (type) {
            case "function": {
                return data.isFunction();
            }
            case "object": {
                return data.isObject();
            }
            case "bool": 
            case "boolean": {
                return data.isBool();
            }
            case "map": {
                return data.isMap();
            }
            case "int": 
            case "integer": 
            case "float": 
            case "double": 
            case "number": {
                return data.isNumber();
            }
            case "text": 
            case "string": {
                return data.isString();
            }
            case "empty": 
            case "null": {
                return data.isNull();
            }
            case "any": 
            case "all": {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Supplier<Value> getArgument(String key) {
        TreeMap<String, Supplier<Value>> treeMap = this.placeholderData;
        synchronized (treeMap) {
            return this.placeholderData.getOrDefault(key, Value::null_);
        }
    }

    public List<String> getArgumentEntries(boolean formatToLower, String ... args) {
        Map<String, Supplier<Value>> list = this.getArguments(args);
        ArrayList result = Lists.newArrayList();
        for (String item : list.keySet()) {
            result.add(formatToLower ? item.toLowerCase() : item);
        }
        return result;
    }

    public List<String> getArgumentEntries(String ... args) {
        return this.getArgumentEntries(false, args);
    }

    public boolean hasArgumentsMatching(String ... args) {
        return !this.getArguments(args).isEmpty();
    }

    public String generateArgumentMessage(List<String> formats, boolean addExtraData, Map<String, Supplier<Value>> args) {
        StringBuilder resultString = new StringBuilder(ModUtils.TRANSLATOR.translate(String.format("%s.placeholders.notes", "craftpresence"), new Object[0]));
        resultString.append("\\n\\n").append(ModUtils.TRANSLATOR.translate(String.format("%s.placeholders.title", "craftpresence"), new Object[0]));
        if (!formats.isEmpty()) {
            resultString.append(" (").append(String.join((CharSequence)",", formats)).append(")");
        }
        resultString.append(":");
        StringBuilder placeholderString = new StringBuilder();
        if (args != null && !args.isEmpty()) {
            for (Map.Entry<String, Supplier<Value>> argData : args.entrySet()) {
                Supplier<Value> suppliedInfo;
                String placeholderName = argData.getKey();
                String placeholderTranslation = String.format("%s.placeholders.%s.description", "craftpresence", placeholderName);
                String placeholderUsage = String.format("%s.placeholders.%s.usage", "craftpresence", placeholderName);
                String placeholderDescription = "";
                String placeholderFormat = "\\n - %s";
                if (ModUtils.TRANSLATOR.hasTranslation(placeholderTranslation)) {
                    placeholderDescription = ModUtils.TRANSLATOR.translate(placeholderTranslation, new Object[0]);
                    placeholderFormat = "\\n - %s = %s";
                }
                placeholderString.append(String.format(placeholderFormat, placeholderName.toLowerCase(), placeholderDescription));
                if (ModUtils.TRANSLATOR.hasTranslation(placeholderUsage)) {
                    placeholderString.append(String.format("\\n ==> %s \"%s\"", ModUtils.TRANSLATOR.translate("gui.config.message.editor.usage", new Object[0]), ModUtils.TRANSLATOR.translate(placeholderUsage, new Object[0])));
                }
                if (!addExtraData || (suppliedInfo = argData.getValue()) == null) continue;
                Value rawValue = suppliedInfo.get();
                String tagValue = rawValue.toString();
                if (rawValue.isNull() || rawValue.isFunction() || StringUtils.isNullOrEmpty(tagValue)) continue;
                placeholderString.append(String.format("\\n ==> %s \"%s\"", ModUtils.TRANSLATOR.translate("gui.config.message.editor.preview", new Object[0]), tagValue.length() >= 128 ? "<...>" : tagValue));
            }
        }
        if (placeholderString.length() == 0) {
            placeholderString.append("\\n - N/A");
        }
        resultString.append((CharSequence)placeholderString);
        return resultString.toString();
    }

    public String generateArgumentMessage(boolean addExtraData, String ... formats) {
        return this.generateArgumentMessage(Arrays.asList(formats), addExtraData, this.getArguments(formats));
    }

    public String generateArgumentMessage(String ... formats) {
        return this.generateArgumentMessage(CraftPresence.CONFIG.advancedSettings.allowPlaceholderPreviews, formats);
    }

    private void syncPackArguments() {
        String foundPackName = "";
        String foundPackIcon = "";
        if (!StringUtils.isNullOrEmpty(CurseUtils.INSTANCE_NAME)) {
            foundPackIcon = foundPackName = CurseUtils.INSTANCE_NAME;
        } else if (!StringUtils.isNullOrEmpty(MultiMCUtils.INSTANCE_NAME)) {
            foundPackName = MultiMCUtils.INSTANCE_NAME;
            foundPackIcon = MultiMCUtils.ICON_KEY;
        } else if (MCUpdaterUtils.instance != null && !StringUtils.isNullOrEmpty(MCUpdaterUtils.instance.getPackName())) {
            foundPackIcon = foundPackName = MCUpdaterUtils.instance.getPackName();
        } else if (!StringUtils.isNullOrEmpty(TechnicUtils.PACK_NAME)) {
            foundPackName = TechnicUtils.PACK_NAME;
            foundPackIcon = TechnicUtils.ICON_NAME;
        }
        if (!StringUtils.isNullOrEmpty(foundPackName)) {
            this.syncArgument("pack.name", foundPackName);
            this.syncArgument("pack.icon", this.imageOf("pack.icon", true, !StringUtils.isNullOrEmpty(foundPackIcon) ? StringUtils.formatAsIcon(foundPackIcon) : ""));
        } else {
            this.removeArguments("pack");
        }
    }

    public void syncPlaceholders() {
        this.syncArgument("_general.instance", CraftPresence.instance);
        this.syncArgument("_general.player", CraftPresence.player);
        this.syncArgument("_general.world", CraftPresence.player != null ? CraftPresence.player.field_3248 : null);
        this.syncArgument("_config.instance", CraftPresence.CONFIG);
        this.removeArguments("custom.");
        for (Map.Entry<String, String> entry : CraftPresence.CONFIG.displaySettings.dynamicVariables.entrySet()) {
            if (entry.getKey().equals("default")) continue;
            this.syncArgument("custom." + entry.getKey(), entry.getValue());
        }
        String playerName = CraftPresence.session.method_5583();
        this.syncArgument("general.mods", FileUtils.getModCount());
        this.syncArgument("player.name", playerName);
        String uniqueId = CraftPresence.session.method_6667();
        if (StringUtils.isValidUuid(uniqueId)) {
            this.syncArgument("player.uuid.short", StringUtils.getFromUuid(uniqueId, true));
            this.syncArgument("player.uuid.full", StringUtils.getFromUuid(uniqueId, false));
        }
        if (CraftPresence.CONFIG.advancedSettings.allowEndpointIcons && !StringUtils.isNullOrEmpty(CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint)) {
            if (!CraftPresence.CONFIG.displaySettings.dynamicIcons.containsKey(playerName)) {
                CraftPresence.CONFIG.displaySettings.dynamicIcons.put(playerName, this.compileData(String.format(CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint, StringUtils.getOrDefault(uniqueId, playerName))).get().toString());
                DiscordAssetUtils.syncCustomAssets();
                CraftPresence.CONFIG.save();
            }
            this.syncArgument("player.icon", playerName);
        }
        this.syncArgument("general.version", ModUtils.MCVersion);
        this.syncArgument("general.brand", ModUtils.BRAND);
        this.syncArgument("data.general.time", this.currentStartTime);
        this.syncArgument("general.icon", CraftPresence.CONFIG.generalSettings.defaultIcon);
        this.syncPackArguments();
        this.syncScriptArguments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncScriptArguments() {
        TreeMap<String, Supplier<Value>> treeMap = this.placeholderData;
        synchronized (treeMap) {
            ValueMap map = this.scriptEngine.getGlobals();
            for (String name : map.keys()) {
                this.placeholderData.put(name, map.get(name));
            }
        }
    }

    public void updatePresence(RichPresence presence) {
        if (!(presence == null || this.currentPresence != null && presence.toJson().toString().equals(this.currentPresence.toJson().toString()) || this.ipcInstance.getStatus() != PipeStatus.CONNECTED)) {
            this.ipcInstance.sendRichPresence(presence);
            this.currentPresence = presence;
        }
    }

    public void updatePresence() {
        this.updatePresence(this.buildRichPresence());
    }

    public String imageOf(boolean allowNull, boolean showLogging, String ... evalStrings) {
        String result;
        if (!DiscordAssetUtils.ASSET_LIST.isEmpty() && !StringUtils.isNullOrEmpty(evalStrings[0])) {
            String primaryKey = evalStrings[0];
            if (!this.cachedImageData.containsKey(primaryKey)) {
                String defaultIcon;
                String finalKey = defaultIcon = allowNull ? "" : StringUtils.getOrDefault(DiscordAssetUtils.getKey(CraftPresence.CONFIG.generalSettings.defaultIcon), DiscordAssetUtils.getRandomAssetName());
                int i = 0;
                while (i < evalStrings.length) {
                    String currentString = evalStrings[i];
                    boolean isPrimaryEntry = currentString.equals(primaryKey);
                    DiscordAsset foundAsset = DiscordAssetUtils.get(currentString);
                    if (foundAsset != null) {
                        finalKey = foundAsset.getName();
                        if (!showLogging || isPrimaryEntry) break;
                        ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.discord.assets.fallback", primaryKey, finalKey), new Object[0]);
                        break;
                    }
                    if (++i < evalStrings.length) {
                        if (!showLogging) continue;
                        ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.discord.assets.fallback", currentString, evalStrings[i]), new Object[0]);
                        if (!isPrimaryEntry) continue;
                        ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.discord.assets.request", currentString), new Object[0]);
                        continue;
                    }
                    if (showLogging) {
                        ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.discord.assets.default", primaryKey, defaultIcon), new Object[0]);
                    }
                    finalKey = defaultIcon;
                }
                this.cachedImageData.put(primaryKey, finalKey);
                result = finalKey;
            } else {
                result = this.cachedImageData.get(primaryKey);
                if ((StringUtils.isNullOrEmpty(this.lastRequestedImageData.getFirst()) || !this.lastRequestedImageData.getFirst().equals(primaryKey)) && CommandUtils.isVerboseMode() && !result.equals(primaryKey)) {
                    ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.discord.assets.cached", primaryKey, result), new Object[0]);
                    ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.discord.assets.request", primaryKey), new Object[0]);
                }
            }
            this.lastRequestedImageData.setFirst(primaryKey);
            this.lastRequestedImageData.setSecond(result);
        } else {
            result = "";
        }
        return result;
    }

    public String imageOf(String argumentName, boolean allowNull, String ... evalStrings) {
        return this.imageOf(allowNull, this.isImageInUse(argumentName) || this.isImageInUse(evalStrings), evalStrings);
    }

    public String imageOf(boolean allowNull, String ... evalStrings) {
        return this.imageOf(allowNull, true, evalStrings);
    }

    public boolean isImageInUse(String ... evalStrings) {
        PresenceData configData = this.getPresenceData();
        for (String evalString : evalStrings) {
            if (!configData.largeImageKey.contains(evalString) && !configData.smallImageKey.contains(evalString)) continue;
            return true;
        }
        return false;
    }

    public void clearPartyData(boolean clearRequestData, boolean updateRPC) {
        if (clearRequestData) {
            this.awaitingReply = false;
            this.REQUESTER_USER = null;
            CraftPresence.SYSTEM.TIMER = 0;
        }
        this.JOIN_SECRET = null;
        this.PARTY_ID = null;
        this.PARTY_SIZE = 0;
        this.PARTY_MAX = 0;
        if (updateRPC) {
            this.updatePresence();
        }
    }

    public void clearPresenceData(Tuple<Boolean, Boolean, Boolean> partyClearArgs) {
        this.GAME_STATE = "";
        this.DETAILS = "";
        this.LARGE_IMAGE_ASSET = null;
        this.LARGE_IMAGE_KEY = "";
        this.LARGE_IMAGE_TEXT = "";
        this.SMALL_IMAGE_ASSET = null;
        this.SMALL_IMAGE_KEY = "";
        this.SMALL_IMAGE_TEXT = "";
        this.BUTTONS = new JsonArray();
        if (partyClearArgs.getFirst().booleanValue()) {
            this.clearPartyData(partyClearArgs.getSecond(), partyClearArgs.getThird());
        }
    }

    public synchronized void shutDown() {
        if (CraftPresence.SYSTEM.HAS_LOADED) {
            block3: {
                try {
                    this.ipcInstance.close();
                }
                catch (Exception ex) {
                    if (!CommandUtils.isVerboseMode()) break block3;
                    ex.printStackTrace();
                }
            }
            this.STATUS = DiscordStatus.Disconnected;
            this.currentPresence = null;
            this.clearPresenceData(new Tuple<Boolean, Boolean, Boolean>(true, true, false));
            this.CURRENT_USER = null;
            this.lastRequestedImageData = new Pair();
            this.cachedImageData.clear();
            CommandUtils.clearModuleData();
            CraftPresence.SYSTEM.HAS_LOADED = false;
            ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.shutdown", new Object[0]), new Object[0]);
        }
    }

    public RichPresence buildRichPresence(PresenceData configData) {
        this.DETAILS = StringUtils.formatWord(this.getResult(configData.details, "details", new Pair[0]), !CraftPresence.CONFIG.advancedSettings.formatWords, true, 1);
        this.GAME_STATE = StringUtils.formatWord(this.getResult(configData.gameState, "gameState", new Pair[0]), !CraftPresence.CONFIG.advancedSettings.formatWords, true, 1);
        this.LARGE_IMAGE_RAW = this.getResult(configData.largeImageKey, "largeImageKey", new Pair[0]);
        this.SMALL_IMAGE_RAW = this.getResult(configData.smallImageKey, "smallImageKey", new Pair[0]);
        this.LARGE_IMAGE_ASSET = DiscordAssetUtils.get(this.LARGE_IMAGE_RAW);
        this.SMALL_IMAGE_ASSET = DiscordAssetUtils.get(this.SMALL_IMAGE_RAW);
        String string = this.LARGE_IMAGE_ASSET != null ? (this.LARGE_IMAGE_ASSET.getType().equals((Object)DiscordAsset.AssetType.CUSTOM) ? this.getResult(this.LARGE_IMAGE_ASSET.getUrl()) : this.LARGE_IMAGE_ASSET.getName()) : (this.LARGE_IMAGE_KEY = this.LARGE_IMAGE_RAW);
        this.SMALL_IMAGE_KEY = this.SMALL_IMAGE_ASSET != null ? (this.SMALL_IMAGE_ASSET.getType().equals((Object)DiscordAsset.AssetType.CUSTOM) ? this.getResult(this.SMALL_IMAGE_ASSET.getUrl()) : this.SMALL_IMAGE_ASSET.getName()) : this.SMALL_IMAGE_RAW;
        this.LARGE_IMAGE_TEXT = StringUtils.formatWord(this.getResult(configData.largeImageText, "largeImageText", new Pair[0]), !CraftPresence.CONFIG.advancedSettings.formatWords, true, 1);
        this.SMALL_IMAGE_TEXT = StringUtils.formatWord(this.getResult(configData.smallImageText, "smallImageText", new Pair[0]), !CraftPresence.CONFIG.advancedSettings.formatWords, true, 1);
        Pair<Boolean, Long> startData = StringUtils.getValidLong(this.getResult(configData.startTimestamp, "startTimestamp", new Pair[0]));
        if (startData.getFirst().booleanValue()) {
            this.START_TIMESTAMP = startData.getSecond();
            Pair<Boolean, Long> endData = StringUtils.getValidLong(this.getResult(configData.endTimestamp, "endTimestamp", new Pair[0]));
            this.END_TIMESTAMP = (Boolean)endData.getFirst() != false ? (Long)endData.getSecond() : 0L;
        } else {
            this.START_TIMESTAMP = 0L;
            this.END_TIMESTAMP = 0L;
        }
        this.BUTTONS = new JsonArray();
        for (Map.Entry entry : configData.buttons.entrySet()) {
            JsonObject buttonObj = new JsonObject();
            String overrideId = (String)entry.getKey();
            Button button = (Button)entry.getValue();
            if (StringUtils.isNullOrEmpty(overrideId) || overrideId.equalsIgnoreCase("default") || StringUtils.isNullOrEmpty(button.label)) continue;
            String label = StringUtils.formatWord(this.getResult(button.label, overrideId + ".label", new Pair[0]), !CraftPresence.CONFIG.advancedSettings.formatWords, true, 1);
            String url = !StringUtils.isNullOrEmpty(button.url) ? this.getResult(button.url, overrideId + ".url", new Pair[0]) : "";
            label = this.sanitizePlaceholders(label, 32);
            url = this.sanitizePlaceholders(url, 512);
            if (StringUtils.isNullOrEmpty(label) || StringUtils.isNullOrEmpty(url)) continue;
            buttonObj.addProperty("label", label);
            buttonObj.addProperty("url", url);
            this.BUTTONS.add((JsonElement)buttonObj);
        }
        this.GAME_STATE = this.sanitizePlaceholders(this.GAME_STATE, 128);
        this.DETAILS = this.sanitizePlaceholders(this.DETAILS, 128);
        this.LARGE_IMAGE_KEY = this.sanitizePlaceholders(this.LARGE_IMAGE_KEY, 256);
        this.LARGE_IMAGE_TEXT = this.sanitizePlaceholders(this.LARGE_IMAGE_TEXT, 128);
        this.SMALL_IMAGE_KEY = this.sanitizePlaceholders(this.SMALL_IMAGE_KEY, 256);
        this.SMALL_IMAGE_TEXT = this.sanitizePlaceholders(this.SMALL_IMAGE_TEXT, 128);
        RichPresence newRPCData = new RichPresence.Builder().setState(this.GAME_STATE).setDetails(this.DETAILS).setStartTimestamp(this.START_TIMESTAMP).setEndTimestamp(this.END_TIMESTAMP).setLargeImage(this.LARGE_IMAGE_KEY, this.LARGE_IMAGE_TEXT).setSmallImage(this.SMALL_IMAGE_KEY, this.SMALL_IMAGE_TEXT).setParty(this.PARTY_ID, this.PARTY_SIZE, this.PARTY_MAX, this.PARTY_PRIVACY.ordinal()).setMatchSecret(this.MATCH_SECRET).setJoinSecret(this.JOIN_SECRET).setSpectateSecret(this.SPECTATE_SECRET).setButtons(this.BUTTONS).build();
        this.GAME_STATE = StringUtils.convertString(this.GAME_STATE, "UTF-8", false);
        this.DETAILS = StringUtils.convertString(this.DETAILS, "UTF-8", false);
        this.LARGE_IMAGE_KEY = StringUtils.convertString(this.LARGE_IMAGE_KEY, "UTF-8", false);
        this.SMALL_IMAGE_KEY = StringUtils.convertString(this.SMALL_IMAGE_KEY, "UTF-8", false);
        this.LARGE_IMAGE_TEXT = StringUtils.convertString(this.LARGE_IMAGE_TEXT, "UTF-8", false);
        this.SMALL_IMAGE_TEXT = StringUtils.convertString(this.SMALL_IMAGE_TEXT, "UTF-8", false);
        return newRPCData;
    }

    public RichPresence buildRichPresence() {
        return this.buildRichPresence(this.getPresenceData());
    }

    public PresenceData getPresenceData() {
        return this.forcedData != null ? this.forcedData : CraftPresence.CONFIG.displaySettings.presenceData;
    }

    public void onTick() {
        boolean isFullyLoaded;
        CommandUtils.syncModuleArguments();
        this.syncPlaceholders();
        boolean isMenuActive = CommandUtils.isLoadingGame || CommandUtils.isInMainMenu;
        boolean bl = isFullyLoaded = CraftPresence.SYSTEM.HAS_LOADED && CraftPresence.SYSTEM.HAS_GAME_LOADED;
        if (!isFullyLoaded && !isMenuActive) {
            CommandUtils.setLoadingPresence();
        } else if (CraftPresence.player == null && !CommandUtils.isInMainMenu) {
            CommandUtils.setMainMenuPresence();
        } else if (CraftPresence.player != null && isMenuActive) {
            CommandUtils.clearInitialPresence();
        }
        if (!CraftPresence.CONFIG.hasChanged && isFullyLoaded) {
            if (this.awaitingReply && CraftPresence.SYSTEM.TIMER == 0) {
                StringUtils.sendMessageToPlayer((class_864)CraftPresence.player, ModUtils.TRANSLATOR.translate("craftpresence.command.request.ignored", this.REQUESTER_USER.getName()));
                this.ipcInstance.respondToJoinRequest(this.REQUESTER_USER, IPCClient.ApprovalMode.DENY);
                this.awaitingReply = false;
                this.STATUS = DiscordStatus.Ready;
            } else if (!this.awaitingReply && this.REQUESTER_USER != null) {
                this.REQUESTER_USER = null;
                this.STATUS = DiscordStatus.Ready;
            }
        }
    }
}

