/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Module;
import fabric.com.gitlab.cdagaming.craftpresence.utils.NbtUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1069;
import net.minecraft.class_1071;
import net.minecraft.class_1653;
import net.minecraft.class_197;
import net.minecraft.class_322;

public class TileEntityUtils
implements Module {
    public final List<String> BLOCK_NAMES = Lists.newArrayList();
    public final List<String> ITEM_NAMES = Lists.newArrayList();
    private final List<String> BLOCK_CLASSES = Lists.newArrayList();
    private final List<String> ITEM_CLASSES = Lists.newArrayList();
    private final List<String> TILE_ENTITY_CLASSES = Lists.newArrayList();
    private final class_1069 EMPTY_ITEM = null;
    private final class_1071 EMPTY_STACK = new class_1071(this.EMPTY_ITEM);
    public boolean isInUse = false;
    public boolean enabled = false;
    public boolean hasScanned = false;
    public List<String> TILE_ENTITY_NAMES = Lists.newArrayList();
    public Map<String, class_1653> TILE_ENTITY_RESOURCES = Maps.newHashMap();
    private class_1071 CURRENT_MAIN_HAND_ITEM;
    private class_1071 CURRENT_HELMET;
    private class_1071 CURRENT_CHEST;
    private class_1071 CURRENT_LEGS;
    private class_1071 CURRENT_BOOTS;
    private String CURRENT_MAIN_HAND_ITEM_NAME;
    private String CURRENT_HELMET_NAME;
    private String CURRENT_CHEST_NAME;
    private String CURRENT_LEGS_NAME;
    private String CURRENT_BOOTS_NAME;
    private class_322 CURRENT_MAIN_HAND_ITEM_DATA;
    private class_322 CURRENT_HELMET_DATA;
    private class_322 CURRENT_CHEST_DATA;
    private class_322 CURRENT_LEGS_DATA;
    private class_322 CURRENT_BOOTS_DATA;

    @Override
    public void emptyData() {
        this.hasScanned = false;
        this.BLOCK_NAMES.clear();
        this.BLOCK_CLASSES.clear();
        this.ITEM_NAMES.clear();
        this.ITEM_CLASSES.clear();
        this.TILE_ENTITY_NAMES.clear();
        this.TILE_ENTITY_CLASSES.clear();
        this.TILE_ENTITY_RESOURCES.clear();
        this.clearClientData();
    }

    @Override
    public void clearClientData() {
        this.CURRENT_MAIN_HAND_ITEM = this.EMPTY_STACK;
        this.CURRENT_MAIN_HAND_ITEM_NAME = null;
        this.CURRENT_HELMET = this.EMPTY_STACK;
        this.CURRENT_CHEST = this.EMPTY_STACK;
        this.CURRENT_LEGS = this.EMPTY_STACK;
        this.CURRENT_BOOTS = this.EMPTY_STACK;
        this.CURRENT_HELMET_NAME = null;
        this.CURRENT_CHEST_NAME = null;
        this.CURRENT_LEGS_NAME = null;
        this.CURRENT_BOOTS_NAME = null;
        this.CURRENT_MAIN_HAND_ITEM_DATA = null;
        this.CURRENT_HELMET_DATA = null;
        this.CURRENT_CHEST_DATA = null;
        this.CURRENT_LEGS_DATA = null;
        this.CURRENT_BOOTS_DATA = null;
        this.setInUse(false);
        CraftPresence.CLIENT.removeArguments("item", "data.item");
        CraftPresence.CLIENT.clearOverride("item.message", "item.icon");
    }

    @Override
    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.advancedSettings.enablePerItem : this.enabled;
        boolean bl = needsUpdate = this.enabled && !this.hasScanned;
        if (needsUpdate) {
            new Thread(this::getAllData, "CraftPresence-TileEntity-Lookup").start();
            this.hasScanned = true;
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.setInUse(true);
                this.updateData();
            } else if (this.isInUse()) {
                this.clearClientData();
            }
        } else if (this.isInUse()) {
            this.emptyData();
        }
    }

    private boolean isEmpty(class_1069 item) {
        return item == null || this.isEmpty(this.getDefaultInstance(item));
    }

    private boolean isEmpty(class_197 block) {
        return block == null || this.isEmpty(class_1069.method_6363((class_197)block));
    }

    private class_1071 getDefaultInstance(class_1069 itemIn) {
        return new class_1071(itemIn);
    }

    private boolean isEmpty(class_1071 itemStack) {
        if (itemStack == null || itemStack.equals(this.EMPTY_STACK)) {
            return true;
        }
        if (itemStack.method_3421() != this.EMPTY_ITEM) {
            if (itemStack.field_4376 <= 0) {
                return true;
            }
            return itemStack.method_3440() < Short.MIN_VALUE || itemStack.method_3440() > 65535;
        }
        return true;
    }

    @Override
    public void updateData() {
        boolean hasBootsNBTChanged;
        class_1071 NEW_CURRENT_MAIN_HAND_ITEM = CraftPresence.player.method_2640();
        class_1071 NEW_CURRENT_HELMET = CraftPresence.player.field_3999.field_3965[3];
        class_1071 NEW_CURRENT_CHEST = CraftPresence.player.field_3999.field_3965[2];
        class_1071 NEW_CURRENT_LEGS = CraftPresence.player.field_3999.field_3965[1];
        class_1071 NEW_CURRENT_BOOTS = CraftPresence.player.field_3999.field_3965[0];
        class_322 NEW_CURRENT_MAIN_HAND_ITEM_DATA = NbtUtils.getNbt(NEW_CURRENT_MAIN_HAND_ITEM);
        class_322 NEW_CURRENT_HELMET_DATA = NbtUtils.getNbt(NEW_CURRENT_HELMET);
        class_322 NEW_CURRENT_CHEST_DATA = NbtUtils.getNbt(NEW_CURRENT_CHEST);
        class_322 NEW_CURRENT_LEGS_DATA = NbtUtils.getNbt(NEW_CURRENT_LEGS);
        class_322 NEW_CURRENT_BOOTS_DATA = NbtUtils.getNbt(NEW_CURRENT_BOOTS);
        String NEW_CURRENT_MAIN_HAND_ITEM_NAME = !this.isEmpty(NEW_CURRENT_MAIN_HAND_ITEM) ? StringUtils.stripColors(NEW_CURRENT_MAIN_HAND_ITEM.method_4623()) : "";
        String NEW_CURRENT_HELMET_NAME = !this.isEmpty(NEW_CURRENT_HELMET) ? StringUtils.stripColors(NEW_CURRENT_HELMET.method_4623()) : "";
        String NEW_CURRENT_CHEST_NAME = !this.isEmpty(NEW_CURRENT_CHEST) ? StringUtils.stripColors(NEW_CURRENT_CHEST.method_4623()) : "";
        String NEW_CURRENT_LEGS_NAME = !this.isEmpty(NEW_CURRENT_LEGS) ? StringUtils.stripColors(NEW_CURRENT_LEGS.method_4623()) : "";
        String NEW_CURRENT_BOOTS_NAME = !this.isEmpty(NEW_CURRENT_BOOTS) ? StringUtils.stripColors(NEW_CURRENT_BOOTS.method_4623()) : "";
        boolean hasMainHandChanged = !this.isEmpty(NEW_CURRENT_MAIN_HAND_ITEM) && !NEW_CURRENT_MAIN_HAND_ITEM.equals(this.CURRENT_MAIN_HAND_ITEM) || !NEW_CURRENT_MAIN_HAND_ITEM_NAME.equals(this.CURRENT_MAIN_HAND_ITEM_NAME) || this.isEmpty(NEW_CURRENT_MAIN_HAND_ITEM) && !this.isEmpty(this.CURRENT_MAIN_HAND_ITEM);
        boolean hasMainHandNBTChanged = !NEW_CURRENT_MAIN_HAND_ITEM_DATA.equals((Object)this.CURRENT_MAIN_HAND_ITEM_DATA);
        boolean hasHelmetChanged = !this.isEmpty(NEW_CURRENT_HELMET) && !NEW_CURRENT_HELMET.equals(this.CURRENT_HELMET) || !NEW_CURRENT_HELMET_NAME.equals(this.CURRENT_HELMET_NAME) || this.isEmpty(NEW_CURRENT_HELMET) && !this.isEmpty(this.CURRENT_HELMET);
        boolean hasHelmetNBTChanged = !NEW_CURRENT_HELMET_DATA.equals((Object)this.CURRENT_HELMET_DATA);
        boolean hasChestChanged = !this.isEmpty(NEW_CURRENT_CHEST) && !NEW_CURRENT_CHEST.equals(this.CURRENT_CHEST) || !NEW_CURRENT_CHEST_NAME.equals(this.CURRENT_CHEST_NAME) || this.isEmpty(NEW_CURRENT_CHEST) && !this.isEmpty(this.CURRENT_CHEST);
        boolean hasChestNBTChanged = !NEW_CURRENT_CHEST_DATA.equals((Object)this.CURRENT_CHEST_DATA);
        boolean hasLegsChanged = !this.isEmpty(NEW_CURRENT_LEGS) && !NEW_CURRENT_LEGS.equals(this.CURRENT_LEGS) || !NEW_CURRENT_LEGS_NAME.equals(this.CURRENT_LEGS_NAME) || this.isEmpty(NEW_CURRENT_LEGS) && !this.isEmpty(this.CURRENT_LEGS);
        boolean hasLegsNBTChanged = !NEW_CURRENT_LEGS_DATA.equals((Object)this.CURRENT_LEGS_DATA);
        boolean hasBootsChanged = !this.isEmpty(NEW_CURRENT_BOOTS) && !NEW_CURRENT_BOOTS.equals(this.CURRENT_BOOTS) || !NEW_CURRENT_BOOTS_NAME.equals(this.CURRENT_BOOTS_NAME) || this.isEmpty(NEW_CURRENT_BOOTS) && !this.isEmpty(this.CURRENT_BOOTS);
        boolean bl = hasBootsNBTChanged = !NEW_CURRENT_BOOTS_DATA.equals((Object)this.CURRENT_BOOTS_DATA);
        if (hasMainHandChanged) {
            this.CURRENT_MAIN_HAND_ITEM = NEW_CURRENT_MAIN_HAND_ITEM;
            this.CURRENT_MAIN_HAND_ITEM_NAME = NEW_CURRENT_MAIN_HAND_ITEM_NAME;
            if (!this.isEmpty(this.CURRENT_MAIN_HAND_ITEM)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.main_hand.time");
            }
        }
        if (hasMainHandNBTChanged) {
            this.CURRENT_MAIN_HAND_ITEM_DATA = NEW_CURRENT_MAIN_HAND_ITEM_DATA;
            NbtUtils.parseTags("data.item.main_hand.nbt", this.CURRENT_MAIN_HAND_ITEM_DATA);
        }
        if (hasHelmetChanged) {
            this.CURRENT_HELMET = NEW_CURRENT_HELMET;
            this.CURRENT_HELMET_NAME = NEW_CURRENT_HELMET_NAME;
            if (!this.isEmpty(this.CURRENT_HELMET)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.helmet.time");
            }
        }
        if (hasHelmetNBTChanged) {
            this.CURRENT_HELMET_DATA = NEW_CURRENT_HELMET_DATA;
            NbtUtils.parseTags("data.item.helmet.nbt", this.CURRENT_HELMET_DATA);
        }
        if (hasChestChanged) {
            this.CURRENT_CHEST = NEW_CURRENT_CHEST;
            this.CURRENT_CHEST_NAME = NEW_CURRENT_CHEST_NAME;
            if (!this.isEmpty(this.CURRENT_CHEST)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.chestplate.time");
            }
        }
        if (hasChestNBTChanged) {
            this.CURRENT_CHEST_DATA = NEW_CURRENT_CHEST_DATA;
            NbtUtils.parseTags("data.item.chestplate.nbt", this.CURRENT_CHEST_DATA);
        }
        if (hasLegsChanged) {
            this.CURRENT_LEGS = NEW_CURRENT_LEGS;
            this.CURRENT_LEGS_NAME = NEW_CURRENT_LEGS_NAME;
            if (!this.isEmpty(this.CURRENT_LEGS)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.leggings.time");
            }
        }
        if (hasLegsNBTChanged) {
            this.CURRENT_LEGS_DATA = NEW_CURRENT_LEGS_DATA;
            NbtUtils.parseTags("data.item.leggings.nbt", this.CURRENT_LEGS_DATA);
        }
        if (hasBootsChanged) {
            this.CURRENT_BOOTS = NEW_CURRENT_BOOTS;
            this.CURRENT_BOOTS_NAME = NEW_CURRENT_BOOTS_NAME;
            if (!this.isEmpty(this.CURRENT_BOOTS)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.boots.time");
            }
        }
        if (hasBootsNBTChanged) {
            this.CURRENT_BOOTS_DATA = NEW_CURRENT_BOOTS_DATA;
            NbtUtils.parseTags("data.item.boots.nbt", this.CURRENT_BOOTS_DATA);
        }
        if (hasMainHandChanged || hasHelmetChanged || hasChestChanged || hasLegsChanged || hasBootsChanged) {
            this.updatePresence();
        }
    }

    @Override
    public void updatePresence() {
        String defaultItemMessage = CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault("default", "");
        String mainItemMessage = CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_MAIN_HAND_ITEM_NAME, this.CURRENT_MAIN_HAND_ITEM_NAME);
        String helmetMessage = CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_HELMET_NAME, this.CURRENT_HELMET_NAME);
        String chestMessage = CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_CHEST_NAME, this.CURRENT_CHEST_NAME);
        String legsMessage = CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_LEGS_NAME, this.CURRENT_LEGS_NAME);
        String bootsMessage = CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_BOOTS_NAME, this.CURRENT_BOOTS_NAME);
        CraftPresence.CLIENT.syncArgument("item.message.default", defaultItemMessage);
        CraftPresence.CLIENT.syncArgument("item.message.holding", String.format("[%s, %s]", StringUtils.getOrDefault(this.CURRENT_MAIN_HAND_ITEM_NAME, "N/A"), "N/A"), true);
        CraftPresence.CLIENT.syncArgument("item.message.equipped", String.format("[%s, %s, %s, %s]", StringUtils.getOrDefault(this.CURRENT_HELMET_NAME, "N/A"), StringUtils.getOrDefault(this.CURRENT_CHEST_NAME, "N/A"), StringUtils.getOrDefault(this.CURRENT_LEGS_NAME, "N/A"), StringUtils.getOrDefault(this.CURRENT_BOOTS_NAME, "N/A")), true);
        if (!this.isEmpty(this.CURRENT_MAIN_HAND_ITEM)) {
            CraftPresence.CLIENT.syncArgument("data.item.main_hand.instance", this.CURRENT_MAIN_HAND_ITEM);
            CraftPresence.CLIENT.syncArgument("data.item.main_hand.class", this.CURRENT_MAIN_HAND_ITEM.getClass());
            CraftPresence.CLIENT.syncArgument("item.main_hand.name", this.CURRENT_MAIN_HAND_ITEM_NAME);
            CraftPresence.CLIENT.syncArgument("item.main_hand.message", mainItemMessage);
        } else {
            CraftPresence.CLIENT.removeArguments("item.main_hand", "data.item.main_hand");
        }
        if (!this.isEmpty(this.CURRENT_HELMET)) {
            CraftPresence.CLIENT.syncArgument("data.item.helmet.instance", this.CURRENT_HELMET);
            CraftPresence.CLIENT.syncArgument("data.item.helmet.class", this.CURRENT_HELMET.getClass());
            CraftPresence.CLIENT.syncArgument("item.helmet.name", this.CURRENT_HELMET_NAME);
            CraftPresence.CLIENT.syncArgument("item.helmet.message", helmetMessage);
        } else {
            CraftPresence.CLIENT.removeArguments("item.helmet", "data.item.helmet");
        }
        if (!this.isEmpty(this.CURRENT_CHEST)) {
            CraftPresence.CLIENT.syncArgument("data.item.chestplate.instance", this.CURRENT_CHEST);
            CraftPresence.CLIENT.syncArgument("data.item.chestplate.class", this.CURRENT_CHEST.getClass());
            CraftPresence.CLIENT.syncArgument("item.chestplate.name", this.CURRENT_CHEST_NAME);
            CraftPresence.CLIENT.syncArgument("item.chestplate.message", chestMessage);
        } else {
            CraftPresence.CLIENT.removeArguments("item.chestplate", "data.item.chestplate");
        }
        if (!this.isEmpty(this.CURRENT_LEGS)) {
            CraftPresence.CLIENT.syncArgument("data.item.leggings.instance", this.CURRENT_LEGS);
            CraftPresence.CLIENT.syncArgument("data.item.leggings.class", this.CURRENT_LEGS.getClass());
            CraftPresence.CLIENT.syncArgument("item.leggings.name", this.CURRENT_LEGS_NAME);
            CraftPresence.CLIENT.syncArgument("item.leggings.message", legsMessage);
        } else {
            CraftPresence.CLIENT.removeArguments("item.leggings", "data.item.leggings");
        }
        if (!this.isEmpty(this.CURRENT_BOOTS)) {
            CraftPresence.CLIENT.syncArgument("data.item.boots.instance", this.CURRENT_BOOTS);
            CraftPresence.CLIENT.syncArgument("data.item.boots.class", this.CURRENT_BOOTS.getClass());
            CraftPresence.CLIENT.syncArgument("item.boots.name", this.CURRENT_BOOTS_NAME);
            CraftPresence.CLIENT.syncArgument("item.boots.message", bootsMessage);
        } else {
            CraftPresence.CLIENT.removeArguments("item.boots", "data.item.boots");
        }
    }

    @Override
    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"})
    public void getAllData() {
        for (Object blockObj : class_197.field_7260) {
            class_197 block = class_197.method_6448((int)class_197.field_7260.method_7330(blockObj));
            if (this.isEmpty(block)) continue;
            String blockName = block.method_480();
            if (!this.BLOCK_NAMES.contains(blockName)) {
                this.BLOCK_NAMES.add(blockName);
            }
            if (this.BLOCK_CLASSES.contains(block.getClass().getName())) continue;
            this.BLOCK_CLASSES.add(block.getClass().getName());
        }
        for (Object itemObj : class_1069.field_6973) {
            class_1069 item = class_1069.method_6366((int)class_1069.field_6973.method_7330(itemObj));
            if (this.isEmpty(item)) continue;
            String itemName = item.method_3383(this.getDefaultInstance(item));
            if (!this.ITEM_NAMES.contains(itemName)) {
                this.ITEM_NAMES.add(itemName);
            }
            if (this.ITEM_CLASSES.contains(item.getClass().getName())) continue;
            this.ITEM_CLASSES.add(item.getClass().getName());
        }
        for (String itemEntry : CraftPresence.CONFIG.advancedSettings.itemMessages.keySet()) {
            if (StringUtils.isNullOrEmpty(itemEntry)) continue;
            if (!this.ITEM_NAMES.contains(itemEntry)) {
                this.ITEM_NAMES.add(itemEntry);
            }
            if (this.BLOCK_NAMES.contains(itemEntry)) continue;
            this.BLOCK_NAMES.add(itemEntry);
        }
        this.verifyEntities();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }

    public void verifyEntities() {
        ArrayList removingBlocks = Lists.newArrayList();
        ArrayList removingItems = Lists.newArrayList();
        for (String itemName : this.ITEM_NAMES) {
            String lowerItemName;
            if (StringUtils.isNullOrEmpty(itemName) || !(lowerItemName = itemName.toLowerCase()).contains("tile.") && !lowerItemName.contains("item.") && !lowerItemName.contains(".") && !lowerItemName.contains(".name")) continue;
            removingItems.add(itemName);
        }
        for (String blockName : this.BLOCK_NAMES) {
            String lowerBlockName;
            if (StringUtils.isNullOrEmpty(blockName) || !(lowerBlockName = blockName.toLowerCase()).contains("tile.") && !lowerBlockName.contains("item.") && !lowerBlockName.contains(".") && !lowerBlockName.contains(".name")) continue;
            removingBlocks.add(blockName);
        }
        this.ITEM_NAMES.removeAll(removingItems);
        this.ITEM_NAMES.removeAll(this.BLOCK_NAMES);
        this.BLOCK_NAMES.removeAll(this.ITEM_NAMES);
        this.BLOCK_NAMES.removeAll(removingBlocks);
        StringUtils.addEntriesNotPresent(this.TILE_ENTITY_NAMES, this.BLOCK_NAMES);
        StringUtils.addEntriesNotPresent(this.TILE_ENTITY_NAMES, this.ITEM_NAMES);
        StringUtils.addEntriesNotPresent(this.TILE_ENTITY_CLASSES, this.BLOCK_CLASSES);
        StringUtils.addEntriesNotPresent(this.TILE_ENTITY_CLASSES, this.ITEM_CLASSES);
    }
}

