/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import external.org.meteordev.starscript.value.Value;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Pair;
import fabric.com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.MappingUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1600;
import net.minecraft.class_1653;
import net.minecraft.class_370;
import net.minecraft.class_390;
import net.minecraft.class_485;
import net.minecraft.class_533;

public class ScrollableListControl
extends class_390 {
    public final Map<String, String> entryAliases = Maps.newHashMap();
    public String currentValue;
    public List<String> currentHoverText = Lists.newArrayList();
    public List<String> itemList;
    public RenderType renderType;
    public ExtendedScreen currentScreen;

    public ScrollableListControl(class_1600 mc, ExtendedScreen currentScreen, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue) {
        this(mc, currentScreen, width, height, topIn, bottomIn, slotHeightIn, itemList, currentValue, RenderType.None);
    }

    public ScrollableListControl(class_1600 mc, ExtendedScreen currentScreen, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue, RenderType renderType) {
        super(mc, width, height, topIn, bottomIn, slotHeightIn);
        this.setList(itemList);
        this.currentScreen = currentScreen;
        this.currentValue = currentValue;
        this.renderType = renderType;
        if (renderType == RenderType.ItemData) {
            CraftPresence.TILE_ENTITIES.getAllData();
        }
    }

    public ScrollableListControl(class_1600 mc, ExtendedScreen currentScreen, int width, int height, int topIn, int bottomIn, List<String> itemList, String currentValue, RenderType renderType) {
        this(mc, currentScreen, width, height, topIn, bottomIn, renderType.canRenderImage() ? 45 : 18, itemList, currentValue, renderType);
    }

    public boolean isWithinBounds(int mouseX, int mouseY) {
        return CraftPresence.GUIS.isMouseWithin(mouseX, mouseY, this.field_1242, this.field_1243, this.field_7734, this.field_1249);
    }

    protected int method_1050() {
        return this.itemList.size();
    }

    public void method_1057(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
        this.currentValue = this.getSelectedItem(slotIndex);
    }

    public boolean method_1051(int slotIndex) {
        return this.getSelectedItem(slotIndex).equals(this.currentValue);
    }

    protected void method_1066() {
    }

    protected void method_1055(int slotIndex, int xPos, int yPos, int heightIn, class_533 tessellatorIn, int mouseXIn, int mouseYIn) {
        this.renderSlotItem(this.getSelectedItem(slotIndex), xPos, yPos, this.method_6706(), heightIn, mouseXIn, mouseYIn);
    }

    public String getSelectedItem(int slotIndex) {
        try {
            return this.itemList.get(slotIndex);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public class_370 getFontRenderer() {
        return GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        return this.getFontRenderer().field_1141;
    }

    public void setList(List<String> itemList) {
        if (itemList == null) {
            itemList = Lists.newArrayList();
        }
        if (!itemList.equals(this.itemList)) {
            this.itemList = itemList;
            this.method_1063(Integer.MIN_VALUE);
        }
        this.setupAliasData();
    }

    public void setupAliasData() {
        this.entryAliases.clear();
        Iterator iterator = Lists.newArrayList(this.itemList).iterator();
        while (iterator.hasNext()) {
            String originalName;
            String displayName = originalName = (String)iterator.next();
            if (this.renderType == RenderType.EntityData && StringUtils.isValidUuid(originalName)) {
                String fullUuid = StringUtils.getFromUuid(originalName, false);
                String trimmedUuid = StringUtils.getFromUuid(originalName, true);
                displayName = CraftPresence.ENTITIES.PLAYER_BINDINGS.getOrDefault(fullUuid, trimmedUuid);
            }
            if (originalName.equals(displayName)) continue;
            this.entryAliases.put(originalName, displayName);
        }
    }

    public void renderSlotItem(String originalName, int xPos, int yPos, int widthIn, int heightIn, int mouseXIn, int mouseYIn) {
        String identifierName;
        ArrayList hoverText = Lists.newArrayList();
        String displayName = this.entryAliases.getOrDefault(originalName, originalName);
        int xOffset = xPos;
        class_1653 texture = new class_1653("");
        if (this.renderType == RenderType.ServerData) {
            class_485 data = CraftPresence.SERVER.getDataFromName(originalName);
            if (data != null) {
                String assetUrl = "data:image/unknown;base64," + data.method_6850();
                texture = ImageUtils.getTextureFromUrl(originalName, new Pair<ImageUtils.InputType, Object>(ImageUtils.InputType.ByteStream, assetUrl));
            } else if (CraftPresence.CONFIG.advancedSettings.allowEndpointIcons && !StringUtils.isNullOrEmpty(CraftPresence.CONFIG.advancedSettings.serverIconEndpoint)) {
                String formattedIP = originalName.contains(":") ? StringUtils.formatAddress(originalName, false) : originalName;
                String endpointUrl = CraftPresence.CLIENT.compileData(String.format(CraftPresence.CONFIG.advancedSettings.serverIconEndpoint, originalName), new Pair<String, Supplier<String>>("server.address.short", () -> formattedIP), new Pair<String, Supplier<String>>("server.address.full", () -> originalName)).get().toString();
                texture = ImageUtils.getTextureFromUrl(originalName, endpointUrl);
                if (this.currentScreen.isDebugMode()) {
                    hoverText.add(ModUtils.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]) + " " + endpointUrl);
                }
            }
        } else if (this.renderType == RenderType.DiscordAsset || this.renderType == RenderType.CustomDiscordAsset) {
            String assetUrl = DiscordAssetUtils.getUrl(this.renderType == RenderType.CustomDiscordAsset ? DiscordAssetUtils.CUSTOM_ASSET_LIST : DiscordAssetUtils.ASSET_LIST, originalName);
            if (this.currentScreen.isDebugMode()) {
                hoverText.add(ModUtils.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]) + " " + assetUrl);
            }
            texture = ImageUtils.getTextureFromUrl(originalName, assetUrl);
        } else if (this.renderType == RenderType.EntityData) {
            boolean isPlayer = CraftPresence.ENTITIES.PLAYER_BINDINGS.containsKey(originalName);
            boolean isValidUuid = StringUtils.isValidUuid(originalName);
            if (isPlayer && CraftPresence.CONFIG.advancedSettings.allowEndpointIcons && !StringUtils.isNullOrEmpty(CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint)) {
                String endpointUrl = CraftPresence.CLIENT.compileData(String.format(CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint, originalName), new Pair<String, Supplier<String>>("player.name", () -> originalName), new Pair<String, Supplier<String>>("player.uuid.full", () -> isValidUuid ? StringUtils.getFromUuid(originalName, false) : ""), new Pair<String, Supplier<String>>("player.uuid.short", () -> isValidUuid ? StringUtils.getFromUuid(originalName, true) : "")).get().toString();
                texture = ImageUtils.getTextureFromUrl(originalName, endpointUrl);
                if (this.currentScreen.isDebugMode()) {
                    hoverText.add(ModUtils.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]) + " " + endpointUrl);
                }
            }
        } else if (this.renderType == RenderType.ItemData) {
            texture = CraftPresence.TILE_ENTITIES.TILE_ENTITY_RESOURCES.getOrDefault(originalName, texture);
        } else if (this.renderType == RenderType.Placeholder) {
            Supplier<Value> suppliedInfo;
            String placeholderTranslation = String.format("%s.placeholders.%s.description", "craftpresence", originalName);
            String placeholderUsage = String.format("%s.placeholders.%s.usage", "craftpresence", originalName);
            if (ModUtils.TRANSLATOR.hasTranslation(placeholderTranslation)) {
                hoverText.add(String.format("%s \"%s\"", ModUtils.TRANSLATOR.translate("gui.config.message.editor.description", new Object[0]), ModUtils.TRANSLATOR.translate(placeholderTranslation, new Object[0])));
            }
            if (ModUtils.TRANSLATOR.hasTranslation(placeholderUsage)) {
                hoverText.add(String.format("%s \"%s\"", ModUtils.TRANSLATOR.translate("gui.config.message.editor.usage", new Object[0]), ModUtils.TRANSLATOR.translate(placeholderUsage, new Object[0])));
            }
            if (CraftPresence.CONFIG.advancedSettings.allowPlaceholderPreviews && (suppliedInfo = CraftPresence.CLIENT.getArgument(originalName)) != null) {
                Value rawValue = suppliedInfo.get();
                String tagValue = rawValue.toString();
                if (!(rawValue.isNull() || rawValue.isFunction() || StringUtils.isNullOrEmpty(tagValue))) {
                    hoverText.add(String.format("%s \"%s\"", ModUtils.TRANSLATOR.translate("gui.config.message.editor.preview", new Object[0]), tagValue.length() >= 128 ? "<...>" : tagValue));
                }
            }
        }
        if (this.renderType.canRenderImage() && !ImageUtils.isTextureNull(texture)) {
            CraftPresence.GUIS.drawTextureRect(0.0, xOffset, (double)yPos + 4.5, 32.0, 32.0, 0.0, texture);
            if (this.currentScreen.isDebugMode()) {
                hoverText.add(ModUtils.TRANSLATOR.translate("gui.config.message.editor.texture_path", new Object[0]) + " " + texture);
            }
            xOffset += 35;
        }
        if (!(identifierName = this.renderType.getIdentifier(originalName)).equals(displayName)) {
            hoverText.add(ModUtils.TRANSLATOR.translate("gui.config.message.editor.original", new Object[0]) + " " + identifierName);
        }
        this.getFontRenderer().method_956(displayName, xOffset, yPos + (heightIn / 2 - this.getFontHeight() / 2), 0xFFFFFF);
        boolean isOverEntry = CraftPresence.GUIS.isMouseOver(mouseXIn, mouseYIn, xPos, yPos, widthIn, heightIn);
        if (this.isWithinBounds(mouseXIn, mouseYIn) && isOverEntry) {
            this.currentHoverText = hoverText;
        }
    }

    @SuppressFBWarnings(value={"ME_ENUM_FIELD_SETTER"})
    public static enum RenderType {
        DiscordAsset,
        CustomDiscordAsset,
        ServerData,
        EntityData,
        ItemData,
        Placeholder,
        None;

        private IdentifierType identifierType = IdentifierType.None;
        private boolean canRenderImage;

        private RenderType() {
            this.canRenderImage = !CraftPresence.CONFIG.accessibilitySettings.stripExtraGuiElements;
        }

        public boolean canRenderImage() {
            return this != None && this.canRenderImage;
        }

        public RenderType setCanRenderImage(boolean canRenderImage) {
            this.canRenderImage = canRenderImage;
            return this;
        }

        public RenderType setIdentifierType(IdentifierType type) {
            this.identifierType = type;
            return this;
        }

        public String getIdentifier(String originalName) {
            String identifierName;
            switch (this.identifierType) {
                case Gui: {
                    Class<?> target = CraftPresence.GUIS.GUI_CLASSES.get(originalName);
                    identifierName = target != null ? MappingUtils.getCanonicalName(target) : originalName;
                    break;
                }
                default: {
                    identifierName = originalName;
                }
            }
            return identifierName;
        }

        public static enum IdentifierType {
            Gui,
            None;

        }
    }
}

